/*
 * Decompiled with CFR 0.152.
 */
package org.jetos.neu.eams.net;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetos.neu.eams.net.SerializableCookie;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetos/neu/eams/net/SimpleCookieJar;", "Lokhttp3/CookieJar;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "cookieStore", "", "", "", "Lokhttp3/Cookie;", "clear", "", "loadCookie", "loadForRequest", "", "url", "Lokhttp3/HttpUrl;", "saveCookie", "saveFromResponse", "cookies", "NeuEams"})
@SourceDebugExtension(value={"SMAP\nConnectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectUtil.kt\norg/jetos/neu/eams/net/SimpleCookieJar\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,530:1\n76#2:531\n96#2,2:532\n98#2,3:538\n1549#3:534\n1620#3,3:535\n1855#3,2:543\n766#3:545\n857#3,2:546\n13309#4,2:541\n*S KotlinDebug\n*F\n+ 1 ConnectUtil.kt\norg/jetos/neu/eams/net/SimpleCookieJar\n*L\n46#1:531\n46#1:532,2\n46#1:538,3\n47#1:534\n47#1:535,3\n78#1:543,2\n97#1:545\n97#1:546,2\n61#1:541,2\n*E\n"})
final class SimpleCookieJar
implements CookieJar {
    @NotNull
    private final File file;
    @NotNull
    private final Map<String, List<Cookie>> cookieStore;

    public SimpleCookieJar(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.cookieStore = new LinkedHashMap();
        this.loadCookie();
    }

    /*
     * WARNING - void declaration
     */
    private final void saveCookie() {
        void $this$flatMapTo$iv$iv;
        Map<String, List<Cookie>> $this$flatMap$iv = this.cookieStore;
        boolean $i$f$flatMap = false;
        Map<String, List<Cookie>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)entry.getValue();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Cookie cookie = (Cookie)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(SerializableCookie.Companion.fromCookie((Cookie)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allCookies = (List)destination$iv$iv;
        String json = new Gson().toJson((Object)allCookies);
        Intrinsics.checkNotNull((Object)json);
        FilesKt.writeText$default((File)this.file, (String)json, null, (int)2, null);
    }

    private final void loadCookie() {
        SerializableCookie[] allCookies;
        if (!this.file.exists()) {
            return;
        }
        File file = this.file;
        Charset charset = Charsets.UTF_8;
        SerializableCookie[] serializableCookieArray = (SerializableCookie[])new Gson().fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), SerializableCookie[].class);
        if (serializableCookieArray == null) {
            SimpleCookieJar $this$loadCookie_u24lambda_u242 = this;
            boolean bl = false;
            return;
        }
        SerializableCookie[] $this$forEach$iv = allCookies = serializableCookieArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SerializableCookie element$iv;
            SerializableCookie serializableCookie = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Cookie cookie = serializableCookie.toCookie();
            String host = cookie.domain();
            List list = this.cookieStore.get(host);
            if (list == null) {
                list = new ArrayList();
            }
            List storedCookies = list;
            storedCookies.add((Cookie)cookie);
            this.cookieStore.put(host, storedCookies);
        }
    }

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        String host = url.host();
        List list = this.cookieStore.get(host);
        if (list == null) {
            list = new ArrayList();
        }
        List storedCookies = list;
        Iterable $this$forEach$iv = cookies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Cookie newCookie = (Cookie)element$iv;
            boolean bl = false;
            Iterator iterator = storedCookies.iterator();
            while (iterator.hasNext()) {
                Cookie existingCookie = (Cookie)iterator.next();
                if (!Intrinsics.areEqual((Object)existingCookie.name(), (Object)newCookie.name()) || !Intrinsics.areEqual((Object)existingCookie.path(), (Object)newCookie.path())) continue;
                iterator.remove();
            }
            storedCookies.add(newCookie);
        }
        this.cookieStore.put(host, storedCookies);
        this.saveCookie();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.host();
        List<Cookie> list = this.cookieStore.get(host);
        if (list == null) {
            return CollectionsKt.emptyList();
        }
        List<Cookie> storedCookies = list;
        Iterable $this$filter$iv = storedCookies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Cookie it = (Cookie)element$iv$iv;
            boolean bl = false;
            if (!(it.expiresAt() > System.currentTimeMillis() && it.matches(url))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validCookies = (List)destination$iv$iv;
        if (validCookies.size() < storedCookies.size()) {
            this.cookieStore.put(host, CollectionsKt.toMutableList((Collection)validCookies));
        }
        return validCookies;
    }

    public final void clear() {
        this.cookieStore.clear();
        this.saveCookie();
    }
}

