/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.ProgressDialog;
import org.jets3t.service.S3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;

public class BucketLoggingDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7251165117085406917L;
    private Frame ownerFrame = null;
    private S3Service s3Service = null;
    private HashMap loggingStatusMap = new HashMap();
    private JComboBox loggedBucketComboBox = null;
    private JComboBox loggedToBucketComboBox = null;
    private JTextField prefixTextField = null;
    private JButton finishedButton = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);

    public BucketLoggingDialog(Frame ownerFrame, S3Service s3Service, String[] bucketNames, HyperlinkActivatedListener hyperlinkListener) {
        super(ownerFrame, "Bucket Logging Status", true);
        this.ownerFrame = ownerFrame;
        this.s3Service = s3Service;
        String introductionText = "<html><center>View and modify your bucket logging settings<br>Select a bucket in the <b>Log to</b> list to apply changes<br><b>Note</b>: The target bucket's ACL permissions are updated if necessary to allow logging<p>&nbsp;</center></html>";
        JHtmlLabel introductionLabel = new JHtmlLabel(introductionText, hyperlinkListener);
        introductionLabel.setHorizontalAlignment(0);
        JHtmlLabel loggingStatusLabel = new JHtmlLabel("<html><b>Logging status</b></html>", hyperlinkListener);
        loggingStatusLabel.setHorizontalAlignment(0);
        JHtmlLabel loggedBucketLabel = new JHtmlLabel("Bucket:", hyperlinkListener);
        this.loggedBucketComboBox = new JComboBox<String>(bucketNames);
        this.loggedBucketComboBox.insertItemAt("-- Choose a bucket --", 0);
        this.loggedBucketComboBox.addActionListener(this);
        JHtmlLabel prefixLabel = new JHtmlLabel("Log file prefix:", hyperlinkListener);
        this.prefixTextField = new JTextField();
        this.prefixTextField.setToolTipText("Log files for the bucket start with this prefix. The prefix cannot be empty");
        JHtmlLabel loggedToBucketLabel = new JHtmlLabel("Log to:", hyperlinkListener);
        this.loggedToBucketComboBox = new JComboBox<String>(bucketNames);
        this.loggedToBucketComboBox.setToolTipText("Where the bucket's log files will be stored");
        this.loggedToBucketComboBox.insertItemAt("-- Not Logged --", 0);
        this.loggedToBucketComboBox.addActionListener(this);
        this.finishedButton = new JButton("Finished");
        this.finishedButton.setActionCommand("Finished");
        this.finishedButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.finishedButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6225706489569112809L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BucketLoggingDialog.this.setVisible(false);
            }
        });
        this.loggedBucketComboBox.setSelectedIndex(0);
        this.loggedToBucketComboBox.setSelectedIndex(0);
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        panel.add((Component)introductionLabel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        panel.add((Component)loggedBucketLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.loggedBucketComboBox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)loggingStatusLabel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)prefixLabel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.prefixTextField, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)loggedToBucketLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)this.loggedToBucketComboBox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)this.finishedButton, new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 10, 0, this.insetsDefault, 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(ownerFrame);
    }

    private int findBucketIndexByName(String bucketName) {
        for (int i = 0; i < this.loggedToBucketComboBox.getItemCount(); ++i) {
            String testBucketName = (String)this.loggedToBucketComboBox.getItemAt(i);
            if (!testBucketName.equals(bucketName)) continue;
            return i;
        }
        return 0;
    }

    private void displayBucketLoggingStatus(S3BucketLoggingStatus loggingStatus) {
        if (loggingStatus.isLoggingEnabled()) {
            this.loggedToBucketComboBox.setSelectedIndex(this.findBucketIndexByName(loggingStatus.getTargetBucketName()));
            this.prefixTextField.setText(loggingStatus.getLogfilePrefix());
        } else {
            this.loggedToBucketComboBox.setSelectedIndex(0);
            if (this.loggedBucketComboBox.getSelectedIndex() != 0) {
                this.prefixTextField.setText(this.loggedBucketComboBox.getSelectedItem() + ".");
            } else {
                this.prefixTextField.setText("");
            }
        }
        this.prefixTextField.setEnabled(true);
        this.loggedToBucketComboBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.finishedButton)) {
            String bucketName = (String)this.loggedBucketComboBox.getSelectedItem();
            if (this.loggingStatusMap.containsKey(bucketName)) {
                S3BucketLoggingStatus loggingStatus = (S3BucketLoggingStatus)this.loggingStatusMap.get(bucketName);
                if (!this.prefixTextField.getText().equals(loggingStatus.getLogfilePrefix()) && this.loggedToBucketComboBox.getSelectedIndex() != 0) {
                    this.loggedToBucketComboBox.setSelectedIndex(this.loggedToBucketComboBox.getSelectedIndex());
                }
            }
            this.setVisible(false);
        } else if (event.getSource().equals(this.loggedBucketComboBox)) {
            this.prefixTextField.setEnabled(false);
            this.loggedToBucketComboBox.setEnabled(false);
            if (this.loggedBucketComboBox.getSelectedIndex() == 0) {
                this.prefixTextField.setText("");
                this.loggedToBucketComboBox.setSelectedIndex(0);
            } else {
                final String bucketName = (String)this.loggedBucketComboBox.getSelectedItem();
                if (this.loggingStatusMap.containsKey(bucketName)) {
                    S3BucketLoggingStatus loggingStatus = (S3BucketLoggingStatus)this.loggingStatusMap.get(bucketName);
                    this.displayBucketLoggingStatus(loggingStatus);
                } else {
                    new Thread(){

                        @Override
                        public void run() {
                            final ProgressDialog progressDialog = new ProgressDialog(BucketLoggingDialog.this.ownerFrame, "Bucket Logging", null);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    progressDialog.startDialog("Retrieving bucket logging status", null, 0, 0, null, null);
                                }
                            });
                            try {
                                S3BucketLoggingStatus loggingStatus = BucketLoggingDialog.this.s3Service.getBucketLoggingStatus(bucketName);
                                BucketLoggingDialog.this.loggingStatusMap.put(bucketName, loggingStatus);
                                BucketLoggingDialog.this.displayBucketLoggingStatus(loggingStatus);
                            }
                            catch (Exception e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        progressDialog.stopDialog();
                                    }
                                });
                                ErrorDialog.showDialog((Frame)BucketLoggingDialog.this.ownerFrame, null, (String)("Unable to retrieve bucket logging status for " + bucketName), (Throwable)e);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    progressDialog.stopDialog();
                                }
                            });
                        }
                    }.start();
                }
            }
        } else if (event.getSource().equals(this.loggedToBucketComboBox)) {
            if (!this.loggedToBucketComboBox.isEnabled()) {
                return;
            }
            final String loggedBucketName = (String)this.loggedBucketComboBox.getSelectedItem();
            final String[] loggedToBucketName = new String[1];
            final String[] loggingFilePrefix = new String[1];
            if (this.loggedToBucketComboBox.getSelectedIndex() != 0) {
                if (this.prefixTextField.getText().length() == 0) {
                    ErrorDialog.showDialog((Frame)this.ownerFrame, null, (String)"A log file name prefix must be provided to log buckets", null);
                    this.loggedToBucketComboBox.setSelectedIndex(0);
                    return;
                }
                loggedToBucketName[0] = (String)this.loggedToBucketComboBox.getSelectedItem();
                loggingFilePrefix[0] = this.prefixTextField.getText();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final ProgressDialog progressDialog = new ProgressDialog(BucketLoggingDialog.this.ownerFrame, "Bucket Logging", null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.startDialog("Setting bucket logging status", null, 0, 0, null, null);
                        }
                    });
                    try {
                        S3BucketLoggingStatus loggingStatus = new S3BucketLoggingStatus(loggedToBucketName[0], loggingFilePrefix[0]);
                        BucketLoggingDialog.this.s3Service.setBucketLoggingStatus(loggedBucketName, loggingStatus, true);
                        BucketLoggingDialog.this.loggingStatusMap.put(loggedBucketName, loggingStatus);
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressDialog.stopDialog();
                            }
                        });
                        ErrorDialog.showDialog((Frame)BucketLoggingDialog.this.ownerFrame, null, (String)("Unable to set bucket logging status for " + loggedBucketName), (Throwable)e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                }
            }).start();
        }
    }

    public static void showDialog(Frame ownerFrame, S3Service s3Service, S3Bucket[] buckets, HyperlinkActivatedListener hyperlinkListener) {
        String[] bucketNames = new String[buckets.length];
        for (int i = 0; i < buckets.length; ++i) {
            bucketNames[i] = buckets[i].getName();
        }
        BucketLoggingDialog.showDialog(ownerFrame, s3Service, bucketNames, hyperlinkListener);
    }

    public static void showDialog(Frame ownerFrame, S3Service s3Service, String[] bucketNames, HyperlinkActivatedListener hyperlinkListener) {
        BucketLoggingDialog dialog = new BucketLoggingDialog(ownerFrame, s3Service, bucketNames, hyperlinkListener);
        dialog.setVisible(true);
        dialog.dispose();
    }
}

