/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import org.jets3t.gui.GuiUtils;
import org.jets3t.service.model.S3Bucket;

public class BucketTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 7957867859342194534L;
    private GuiUtils guiUtils;
    private ArrayList bucketList;
    private boolean includeDistributions;
    private Icon distributionActiveIcon;

    public BucketTableModel(boolean includeDistributions) {
        Object[] objectArray;
        if (includeDistributions) {
            String[] stringArray = new String[2];
            stringArray[0] = "Bucket Name";
            objectArray = stringArray;
            stringArray[1] = "";
        } else {
            Object[] objectArray2 = new String[1];
            objectArray = objectArray2;
            objectArray2[0] = "Bucket Name";
        }
        super(objectArray, 0);
        this.guiUtils = new GuiUtils();
        this.bucketList = new ArrayList();
        this.includeDistributions = false;
        this.distributionActiveIcon = null;
        this.includeDistributions = includeDistributions;
        JLabel dummyLabel = new JLabel();
        if (this.guiUtils.applyIcon((Object)dummyLabel, "/images/nuvola/16x16/actions/irkick.png")) {
            this.distributionActiveIcon = dummyLabel.getIcon();
        }
    }

    protected int findBucketsIndex(S3Bucket bucket) {
        return Collections.binarySearch(this.bucketList, new S3BucketAndDistributionFlag(bucket, false), new Comparator(){

            public int compare(Object o1, Object o2) {
                String b1Name = ((S3BucketAndDistributionFlag)o1).getS3Bucket().getName();
                String b2Name = ((S3BucketAndDistributionFlag)o2).getS3Bucket().getName();
                int result = b1Name.compareTo(b2Name);
                return result;
            }
        });
    }

    public int addBucket(S3Bucket bucket, boolean hasDistributions) {
        int insertRow = this.findBucketsIndex(bucket);
        if (insertRow >= 0) {
            this.bucketList.remove(insertRow);
            this.removeRow(insertRow);
        } else {
            insertRow = -insertRow - 1;
        }
        this.bucketList.add(insertRow, new S3BucketAndDistributionFlag(bucket, hasDistributions));
        if (this.includeDistributions) {
            Boolean flag = hasDistributions ? Boolean.TRUE : Boolean.FALSE;
            this.insertRow(insertRow, new Object[]{bucket.getName(), flag});
        } else {
            this.insertRow(insertRow, new Object[]{bucket.getName()});
        }
        return insertRow;
    }

    public void removeBucket(S3Bucket bucket) {
        int index = this.findBucketsIndex(bucket);
        this.removeRow(index);
        this.bucketList.remove(index);
    }

    public void removeAllBuckets() {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.removeRow(0);
        }
        this.bucketList.clear();
    }

    public S3Bucket getBucket(int row) {
        return ((S3BucketAndDistributionFlag)this.bucketList.get(row)).getS3Bucket();
    }

    public S3Bucket[] getBuckets() {
        S3Bucket[] buckets = new S3Bucket[this.bucketList.size()];
        for (int i = 0; i < this.bucketList.size(); ++i) {
            buckets[i] = this.getBucket(i);
        }
        return buckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBucketIndexByName(String name) {
        ArrayList arrayList = this.bucketList;
        synchronized (arrayList) {
            for (int index = 0; index < this.bucketList.size(); ++index) {
                S3Bucket bucket = this.getBucket(index);
                if (!bucket.getName().equals(name)) continue;
                return index;
            }
            return -1;
        }
    }

    public boolean hasDistributions() {
        for (int i = 0; i < this.bucketList.size(); ++i) {
            if (!((S3BucketAndDistributionFlag)this.bucketList.get(i)).distributionFlag) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            if (this.distributionActiveIcon != null) {
                return ImageIcon.class;
            }
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1 && this.distributionActiveIcon != null && ((S3BucketAndDistributionFlag)this.bucketList.get(rowIndex)).hasDistribution()) {
            return this.distributionActiveIcon;
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    private class S3BucketAndDistributionFlag {
        private S3Bucket bucket = null;
        private boolean distributionFlag = false;

        public S3BucketAndDistributionFlag(S3Bucket bucket, boolean distributionFlag) {
            this.bucket = bucket;
            this.distributionFlag = distributionFlag;
        }

        public S3Bucket getS3Bucket() {
            return this.bucket;
        }

        public boolean hasDistribution() {
            return this.distributionFlag;
        }
    }
}

