/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jets3t.apps.cockpit.gui.LoginCredentialsPanel;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.security.GSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class CredentialsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8201015667689728582L;
    private LoginCredentialsPanel loginCredentialsPanel = null;
    private JButton okButton = null;
    private boolean isConfirmed = false;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);

    public CredentialsDialog(Frame ownerFrame, boolean askForFriendlyName, Jets3tProperties jets3tProperties, HyperlinkActivatedListener hyperlinkListener) {
        super(ownerFrame, "Service Credentials", true);
        this.loginCredentialsPanel = new LoginCredentialsPanel(askForFriendlyName, hyperlinkListener);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.loginCredentialsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.getContentPane().add((Component)buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6225706489569112809L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CredentialsDialog.this.isConfirmed = false;
                CredentialsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(ownerFrame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.okButton)) {
            String[] inputErrors = this.loginCredentialsPanel.checkForInputErrors();
            if (inputErrors.length == 0) {
                this.isConfirmed = true;
                this.setVisible(false);
            } else {
                String errorMessages = "<html>Please correct the following errors:<ul>";
                for (int i = 0; i < inputErrors.length; ++i) {
                    errorMessages = errorMessages + "<li>" + inputErrors[i] + "</li>";
                }
                errorMessages = errorMessages + "</ul></html>";
                ErrorDialog.showDialog((JDialog)this, null, (String)errorMessages, null);
            }
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.isConfirmed = false;
            this.setVisible(false);
        }
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }

    public String getAccessKey() {
        return this.loginCredentialsPanel.getAccessKey().trim();
    }

    public String getSecretKey() {
        return this.loginCredentialsPanel.getSecretKey().trim();
    }

    public boolean getUsingDevPay() {
        return this.loginCredentialsPanel.getUsingDevPay();
    }

    public String getAWSUserToken() {
        return this.loginCredentialsPanel.getAWSUserToken().trim();
    }

    public String getAWSProductToken() {
        return this.loginCredentialsPanel.getAWSProductToken().trim();
    }

    public String getFriendlyName() {
        return this.loginCredentialsPanel.getFriendlyName().trim();
    }

    public static ProviderCredentials showDialog(Frame ownerFrame, boolean askForFriendlyName, boolean isTargetS3, Jets3tProperties jets3tProperties, HyperlinkActivatedListener hyperlinkListener) {
        CredentialsDialog dialog = new CredentialsDialog(ownerFrame, askForFriendlyName, jets3tProperties, hyperlinkListener);
        dialog.setVisible(true);
        Object credentials = null;
        credentials = dialog.isConfirmed() ? (!isTargetS3 ? new GSCredentials(dialog.getAccessKey(), dialog.getSecretKey(), dialog.getFriendlyName()) : (dialog.getUsingDevPay() ? new AWSDevPayCredentials(dialog.getAccessKey(), dialog.getSecretKey(), dialog.getAWSUserToken(), dialog.getAWSProductToken(), dialog.getFriendlyName()) : new AWSCredentials(dialog.getAccessKey(), dialog.getSecretKey(), dialog.getFriendlyName()))) : null;
        dialog.dispose();
        return credentials;
    }
}

