/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.service.Constants;
import org.jets3t.service.security.ProviderCredentials;

public class LoginLocalFolderPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1500994545263522051L;
    private static final Log log = LogFactory.getLog(LoginLocalFolderPanel.class);
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    private Frame ownerFrame = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private File cockpitHomeFolder = null;
    private JTextField folderPathTextField = null;
    private JTable accountNicknameTable = null;
    private ProviderCredentialsFileTableModel nicknamesTableModel = null;
    private JPasswordField passwordPasswordField = null;

    public LoginLocalFolderPanel(Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener) {
        super(new GridBagLayout());
        this.ownerFrame = ownerFrame;
        this.cockpitHomeFolder = Constants.DEFAULT_PREFERENCES_DIRECTORY.exists() ? Constants.DEFAULT_PREFERENCES_DIRECTORY : new File(System.getProperty("user.home"));
        this.hyperlinkListener = hyperlinkListener;
        this.initGui();
        this.refreshStoredCredentialsTable();
    }

    private void initGui() {
        String descriptionText = "<html><center>Your credentials are stored in encrypted files in a folder on your computer. Each stored login has a nickname.<br><font size=\"-2\">You need to store your credentials before you can use this login method.</font></center></html>";
        String folderTooltipText = "The folder containing your credentials";
        String browseButtonText = "Change Folder";
        String accountNicknameText = "Stored logins";
        String accountNicknameTooltipText = "Nicknames of the login credentials you have stored";
        String passwordLabelText = "Password";
        String passwordTooltipText = "The password that protects your encrypted file. This password may be left empty if you are sure your computer cannot be compromised";
        JHtmlLabel descriptionLabel = new JHtmlLabel(descriptionText, this.hyperlinkListener);
        descriptionLabel.setHorizontalAlignment(0);
        this.folderPathTextField = new JTextField(this.cockpitHomeFolder.getAbsolutePath());
        this.folderPathTextField.setEnabled(false);
        this.folderPathTextField.setToolTipText(folderTooltipText);
        JButton browseButton = new JButton(browseButtonText);
        browseButton.addActionListener(this);
        JHtmlLabel accountNicknamesLabel = new JHtmlLabel(accountNicknameText, this.hyperlinkListener);
        this.nicknamesTableModel = new ProviderCredentialsFileTableModel();
        this.accountNicknameTable = new JTable(this.nicknamesTableModel);
        this.accountNicknameTable.setSelectionMode(0);
        this.accountNicknameTable.setShowHorizontalLines(true);
        this.accountNicknameTable.getTableHeader().setVisible(false);
        JScrollPane accountNicknamesScrollPane = new JScrollPane(this.accountNicknameTable);
        accountNicknamesScrollPane.setToolTipText(accountNicknameTooltipText);
        JHtmlLabel passwordLabel = new JHtmlLabel(passwordLabelText, this.hyperlinkListener);
        this.passwordPasswordField = new JPasswordField();
        this.passwordPasswordField.setToolTipText(passwordTooltipText);
        int row = 0;
        this.add((Component)descriptionLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        this.add((Component)this.folderPathTextField, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)browseButton, new GridBagConstraints(1, row++, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        this.add((Component)accountNicknamesLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        this.add((Component)accountNicknamesScrollPane, new GridBagConstraints(0, row++, 2, 1, 0.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.add((Component)passwordLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)this.passwordPasswordField, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
    }

    public void refreshStoredCredentialsTable() {
        this.nicknamesTableModel.removeAll();
        try {
            File[] files = this.cockpitHomeFolder.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                File candidateFile = files[i];
                if (!candidateFile.getName().endsWith(".enc")) continue;
                ProviderCredentials credentials = ProviderCredentials.load(null, (File)candidateFile);
                this.nicknamesTableModel.addCredentialsFile(credentials, candidateFile);
            }
        }
        catch (Exception e) {
            String message = "Unable to find credential files in the folder " + this.cockpitHomeFolder.getAbsolutePath();
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((Frame)this.ownerFrame, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, (Throwable)e);
        }
    }

    private void chooseFolder() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setDialogTitle("Choose Cockpit Home Folder");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText("Choose Folder");
        fileChooser.setCurrentDirectory(this.cockpitHomeFolder);
        int returnVal = fileChooser.showOpenDialog(this.ownerFrame);
        if (returnVal != 0) {
            return;
        }
        this.cockpitHomeFolder = fileChooser.getSelectedFile();
        this.folderPathTextField.setText(this.cockpitHomeFolder.getAbsolutePath());
        this.refreshStoredCredentialsTable();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.chooseFolder();
    }

    public File getHomeFolder() {
        return this.cockpitHomeFolder;
    }

    public File getCredentialsFile() {
        int selectedNicknameIndex = this.accountNicknameTable.getSelectedRow();
        if (selectedNicknameIndex < 0) {
            return null;
        }
        return this.nicknamesTableModel.getCredentialsFile(selectedNicknameIndex);
    }

    public String getPassword() {
        return new String(this.passwordPasswordField.getPassword());
    }

    public void clearPassword() {
        this.passwordPasswordField.setText("");
    }

    private class ProviderCredentialsFileTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 8560515388653630790L;
        ArrayList credentialsList;
        ArrayList credentialFileList;

        public ProviderCredentialsFileTableModel() {
            super(new String[]{""}, 0);
            this.credentialsList = new ArrayList();
            this.credentialFileList = new ArrayList();
        }

        public int addCredentialsFile(ProviderCredentials credentials, File credentialsFile) {
            int insertRow = Collections.binarySearch(this.credentialsList, credentials, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String name1 = ((ProviderCredentials)o1).getFriendlyName();
                    String name2 = ((ProviderCredentials)o2).getFriendlyName();
                    int result = name1.compareToIgnoreCase(name2);
                    return result;
                }
            });
            if (insertRow >= 0) {
                this.credentialsList.remove(insertRow);
                this.credentialFileList.remove(insertRow);
                this.removeRow(insertRow);
            } else {
                insertRow = -insertRow - 1;
            }
            this.credentialsList.add(insertRow, credentials);
            this.credentialFileList.add(insertRow, credentialsFile);
            this.insertRow(insertRow, new Object[]{credentials.getFriendlyName()});
            return insertRow;
        }

        public void removeAll() {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.removeRow(0);
            }
            this.credentialFileList.clear();
            this.credentialsList.clear();
        }

        public File getCredentialsFile(int row) {
            return (File)this.credentialFileList.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

