/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.service.S3Service;
import org.jets3t.service.model.S3Object;

public class SignedGetUrlDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = -3243824805519630114L;
    private static final Log log = LogFactory.getLog(SignedGetUrlDialog.class);
    private Frame ownerFrame = null;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private S3Service s3Service = null;
    private S3Object[] objects = null;
    private JCheckBox virtualHostCheckBox = null;
    private JCheckBox requesterPaysCheckBox = null;
    private JCheckBox httpsUrlsCheckBox = null;
    private JTextField expiryTimeTextField = null;
    private JTextArea signedUrlsTextArea = null;
    private JButton finishedButton = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);

    public SignedGetUrlDialog(Frame ownerFrame, HyperlinkActivatedListener hyperlinkListener, S3Service s3Service, S3Object[] objects) {
        super(ownerFrame, "Generate Signed GET URLs", true);
        this.ownerFrame = ownerFrame;
        this.hyperlinkListener = hyperlinkListener;
        this.s3Service = s3Service;
        this.objects = objects;
        String introductionText = "<html><center>Generate signed GET URLs that you can provide to anyone<br>who needs to access objects in your bucket for a limited time.</center></html>";
        JHtmlLabel introductionLabel = new JHtmlLabel(introductionText, hyperlinkListener);
        introductionLabel.setHorizontalAlignment(0);
        JHtmlLabel expiryTimeLabel = new JHtmlLabel("<html><b>Expiry Time</b> (Hours)</html>", hyperlinkListener);
        expiryTimeLabel.setHorizontalAlignment(4);
        JHtmlLabel httpsUrlsLabel = new JHtmlLabel("<html><b>Secure HTTPS URLs?</b></html>", hyperlinkListener);
        httpsUrlsLabel.setHorizontalAlignment(4);
        JHtmlLabel virtualHostLabel = new JHtmlLabel("<html><b>Bucket is a Virtual Host?</b></html>", hyperlinkListener);
        virtualHostLabel.setHorizontalAlignment(4);
        JHtmlLabel requesterPaysLabel = new JHtmlLabel("<html><b>Bucket is Requester Pays?</b></html>", hyperlinkListener);
        requesterPaysLabel.setHorizontalAlignment(4);
        this.expiryTimeTextField = new JTextField("1.0");
        this.expiryTimeTextField.setToolTipText("How long in hours until the URL will expire");
        this.expiryTimeTextField.getDocument().addDocumentListener(this);
        this.httpsUrlsCheckBox = new JCheckBox();
        this.httpsUrlsCheckBox.setSelected(false);
        this.httpsUrlsCheckBox.setToolTipText("Check this box to generate secure HTTPS URLs.");
        this.httpsUrlsCheckBox.addActionListener(this);
        this.virtualHostCheckBox = new JCheckBox();
        this.virtualHostCheckBox.setSelected(false);
        this.virtualHostCheckBox.setToolTipText("Check this box if your bucket is configured as a virtual host.");
        this.virtualHostCheckBox.addActionListener(this);
        this.requesterPaysCheckBox = new JCheckBox();
        this.requesterPaysCheckBox.setSelected(false);
        this.requesterPaysCheckBox.setToolTipText("Check this box if the bucket has Requester Pays enabled.");
        this.requesterPaysCheckBox.addActionListener(this);
        this.finishedButton = new JButton("Finished");
        this.finishedButton.setActionCommand("Finished");
        this.finishedButton.addActionListener(this);
        this.signedUrlsTextArea = new JTextArea();
        this.signedUrlsTextArea.setEditable(false);
        this.getRootPane().setDefaultButton(this.finishedButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -6225706489569112809L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SignedGetUrlDialog.this.setVisible(false);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        panel.add((Component)introductionLabel, new GridBagConstraints(0, row, 6, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        panel.add((Component)expiryTimeLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 2, this.insetsDefault, 0, 0));
        panel.add((Component)this.expiryTimeTextField, new GridBagConstraints(1, row, 5, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        panel.add((Component)httpsUrlsLabel, new GridBagConstraints(0, ++row, 1, 1, 0.3, 0.0, 13, 2, this.insetsDefault, 0, 0));
        panel.add((Component)this.httpsUrlsCheckBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)virtualHostLabel, new GridBagConstraints(2, row, 1, 1, 0.3, 0.0, 13, 2, this.insetsDefault, 0, 0));
        panel.add((Component)this.virtualHostCheckBox, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)requesterPaysLabel, new GridBagConstraints(4, row, 1, 1, 0.3, 0.0, 13, 2, this.insetsDefault, 0, 0));
        panel.add((Component)this.requesterPaysCheckBox, new GridBagConstraints(5, row, 1, 1, 0.0, 0.0, 17, 0, this.insetsDefault, 0, 0));
        panel.add((Component)new JScrollPane(this.signedUrlsTextArea), new GridBagConstraints(0, ++row, 6, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        panel.add((Component)this.finishedButton, new GridBagConstraints(0, ++row, 6, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.setSize(700, 450);
        this.setResizable(true);
        this.setLocationRelativeTo(ownerFrame);
        this.generateSignedUrls();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.finishedButton)) {
            this.setVisible(false);
        } else {
            this.generateSignedUrls();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.generateSignedUrls();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.generateSignedUrls();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.generateSignedUrls();
    }

    protected void generateSignedUrls() {
        try {
            this.signedUrlsTextArea.setText("");
            if (this.expiryTimeTextField.getText().length() == 0) {
                return;
            }
            double hoursFromNow = Double.parseDouble(this.expiryTimeTextField.getText());
            int secondsFromNow = (int)(hoursFromNow * 60.0 * 60.0);
            Calendar cal = Calendar.getInstance();
            cal.add(13, secondsFromNow);
            long secondsSinceEpoch = cal.getTimeInMillis() / 1000L;
            String specialParamName = null;
            if (this.requesterPaysCheckBox.isSelected()) {
                specialParamName = "x-amz-request-payer=requester";
            }
            boolean disableDnsBuckets = this.s3Service.getJetS3tProperties().getBoolProperty("s3service.disable-dns-buckets", false);
            StringBuffer signedUrlsBuffer = new StringBuffer();
            for (int i = 0; i < this.objects.length; ++i) {
                S3Object currentObject = this.objects[i];
                String signedUrl = this.s3Service.createSignedUrl("GET", currentObject.getBucketName(), currentObject.getKey(), specialParamName, null, secondsSinceEpoch, this.virtualHostCheckBox.isSelected(), this.httpsUrlsCheckBox.isSelected(), disableDnsBuckets);
                signedUrlsBuffer.append(signedUrl + "\n");
            }
            this.signedUrlsTextArea.setText(signedUrlsBuffer.toString());
        }
        catch (NumberFormatException e) {
            String message = "Hours must be a valid decimal value; eg 3, 0.1";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog((Frame)this.ownerFrame, (HyperlinkActivatedListener)this.hyperlinkListener, (String)message, (Throwable)e);
        }
    }
}

