/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpitlite;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.skins.SkinsFactory;

public class ToggleAclDialog
extends JDialog
implements ActionListener {
    private static final Log log = LogFactory.getLog(ToggleAclDialog.class);
    private Properties applicationProperties = null;
    private boolean isPublicObject = false;
    private HyperlinkActivatedListener hyperlinkListener = null;
    private SkinsFactory skinsFactory = null;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    private JRadioButton privateRadioButton = null;
    private JRadioButton publicRadioButton = null;

    public ToggleAclDialog(Frame ownerFrame, boolean isPublicObject, HyperlinkActivatedListener hyperlinkListener, Properties applicationProperties) {
        super(ownerFrame, "Toggle privacy settings", true);
        this.hyperlinkListener = hyperlinkListener;
        this.applicationProperties = applicationProperties;
        this.isPublicObject = isPublicObject;
        this.initGui();
    }

    public ToggleAclDialog(JDialog ownerDialog, boolean isPublicObject, HyperlinkActivatedListener hyperlinkListener, Properties applicationProperties) {
        super(ownerDialog, "Change privacy", true);
        this.hyperlinkListener = hyperlinkListener;
        this.applicationProperties = applicationProperties;
        this.isPublicObject = isPublicObject;
        this.initGui();
    }

    public boolean isPublicAclSet() {
        return this.publicRadioButton.isSelected();
    }

    private void initGui() {
        this.skinsFactory = SkinsFactory.getInstance((Properties)this.applicationProperties);
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        JHtmlLabel messageLabel = this.skinsFactory.createSkinnedJHtmlLabel("ToggleAclDialogMessage", this.hyperlinkListener);
        messageLabel.setText("File privacy setting:");
        messageLabel.setHorizontalAlignment(0);
        this.privateRadioButton = this.skinsFactory.createSkinnedJRadioButton("ToggleAclDialogPrivateRadioButton");
        this.privateRadioButton.setText("Private file");
        this.publicRadioButton = this.skinsFactory.createSkinnedJRadioButton("ToggleAclDialogPublicRadioButton");
        this.publicRadioButton.setText("Public file");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.privateRadioButton);
        buttonGroup.add(this.publicRadioButton);
        this.publicRadioButton.setSelected(this.isPublicObject);
        this.privateRadioButton.setSelected(!this.isPublicObject);
        JButton okButton = this.skinsFactory.createSkinnedJButton("ToggleAclDialogOkButton");
        okButton.setName("OK");
        okButton.setText("OK");
        okButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonsPanel = this.skinsFactory.createSkinnedJPanel("ToggleAclDialogButtonsPanel");
        buttonsPanel.setLayout(new GridBagLayout());
        buttonsPanel.add((Component)this.privateRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        buttonsPanel.add((Component)this.publicRadioButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        buttonsPanel.add((Component)okButton, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, this.insetsZero, 0, 0));
        int row = 0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)messageLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        this.getContentPane().add((Component)buttonsPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 2, this.insetsDefault, 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        JFrame ownerFrame = new JFrame("Test");
        ToggleAclDialog dialog = new ToggleAclDialog((Frame)ownerFrame, false, null, new Properties());
        dialog.setVisible(true);
        dialog.dispose();
        ownerFrame.dispose();
    }
}

