/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.multithread.CancelEventTrigger;

public class ProgressPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7880101403853417240L;
    private static final Log log = LogFactory.getLog(ProgressPanel.class);
    private final Insets insetsDefault = new Insets(5, 2, 5, 2);
    private final GuiUtils guiUtils = new GuiUtils();
    private Properties applicationProperties = null;
    private SkinsFactory skinsFactory = null;
    private JLabel statusMessageLabel = null;
    private JProgressBar progressBar = null;
    private JButton cancelButton = null;
    private CancelEventTrigger cancelEventTrigger = null;

    public ProgressPanel(Properties applicationProperties, CancelEventTrigger cancelEventTrigger) {
        this.applicationProperties = applicationProperties;
        this.cancelEventTrigger = cancelEventTrigger;
        this.initGui();
    }

    private void initGui() {
        this.skinsFactory = SkinsFactory.getInstance(this.applicationProperties);
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        this.setLayout(new GridBagLayout());
        this.statusMessageLabel = this.skinsFactory.createSkinnedJHtmlLabel("ProgressPanelStatusMessageLabel");
        this.statusMessageLabel.setText(" ");
        this.statusMessageLabel.setHorizontalAlignment(0);
        this.add((Component)this.statusMessageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.progressBar = this.skinsFactory.createSkinnedJProgressBar("ProgressPanelProgressBar", 0, 100);
        this.add((Component)this.progressBar, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.cancelButton = this.skinsFactory.createSkinnedJButton("ProgressPanelCancelButton");
        this.guiUtils.applyIcon(this.cancelButton, "/images/nuvola/16x16/actions/cancel.png");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setEnabled(this.cancelEventTrigger != null);
        this.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            this.cancelButton.setEnabled(false);
            if (this.cancelEventTrigger != null) {
                this.cancelEventTrigger.cancelTask((Object)this);
            }
        }
    }

    public void dispose() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
    }

    public void startProgress(String statusMessage, int minTaskValue, int maxTaskValue) {
        if (maxTaskValue > minTaskValue) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setMinimum(minTaskValue);
            this.progressBar.setMaximum(maxTaskValue);
            this.progressBar.setValue(minTaskValue);
            this.progressBar.setIndeterminate(false);
        } else {
            this.progressBar.setStringPainted(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(0);
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(true);
        }
        this.statusMessageLabel.setText(statusMessage);
    }

    public void updateProgress(String statusMessage, int progressValue) {
        this.statusMessageLabel.setText(statusMessage);
        if (!this.progressBar.isIndeterminate()) {
            this.progressBar.setValue(progressValue);
        }
    }
}

