/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.data;

import org.w3c.dom.Element;

public abstract class ProfileEntry {
    public static final String JZR_PATTERN = "pattern";
    public static final String JZR_PATTERN_REGEX = "pattern_regex";
    public static final String JZR_NAME = "name";
    public static final String JZR_SIZE = "size";
    public static final String JZR_PRIORITY = "priority";
    protected Element node;
    protected Element nextNode;

    public ProfileEntry(Element node, Element nextNode) {
        this.node = node;
        this.nextNode = nextNode;
    }

    public String getName() {
        return this.node.getAttribute(JZR_NAME);
    }

    protected String getPattern() {
        return this.node.getAttribute(JZR_PATTERN);
    }

    public Element getNextNode() {
        return this.nextNode;
    }

    public int getPriority() {
        String value = this.node.getAttribute(JZR_PRIORITY);
        return !value.isEmpty() ? Integer.parseInt(value) : -1;
    }

    public boolean nodeEquals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        Element nodetoCompare = (Element)obj;
        if (!this.getName().equals(nodetoCompare.getAttribute(JZR_NAME))) {
            return false;
        }
        if (!this.patternEquals(nodetoCompare)) {
            return false;
        }
        return this.priorityEquals(nodetoCompare);
    }

    public boolean patternEquals(Element nodetoCompare) {
        return nodetoCompare.getAttribute(JZR_PATTERN).contains(this.getPattern());
    }

    public boolean priorityEquals(Element nodetoCompare) {
        String value = nodetoCompare.getAttribute(JZR_PRIORITY);
        int priorityToCompare = !value.isEmpty() ? Integer.parseInt(value) : -1;
        return this.getPriority() == priorityToCompare;
    }

    public void updatePriority(Element sourceNode) {
        this.node.setAttribute(JZR_PRIORITY, sourceNode.getAttribute(JZR_PRIORITY));
    }

    public void removePriority() {
        this.node.removeAttribute(JZR_PRIORITY);
    }
}

