/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.pattern;

import org.jeyzer.profile.data.OperationEntry;
import org.jeyzer.profile.data.ProfileEntry;
import org.jeyzer.profile.data.validation.ProfileEntryValidator;
import org.jeyzer.profile.error.InvalidPatternsException;
import org.jeyzer.profile.error.InvalidProfileEntryException;
import org.jeyzer.profile.pattern.PatternUpdater;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OperationUpdater
extends PatternUpdater {
    protected Element firstLowLevelPatternNode;

    public OperationUpdater(Document doc) throws InvalidPatternsException {
        super(doc);
        for (int i = 0; i < this.targetNodes.getLength(); ++i) {
            Element node = (Element)this.targetNodes.item(i);
            String value = node.getAttribute("pattern");
            if (!value.endsWith(".")) continue;
            this.firstLowLevelPatternNode = node;
            break;
        }
    }

    @Override
    public String getName() {
        return "operation";
    }

    @Override
    protected ProfileEntry createProfileEntry(Element node, Element nextNode) throws InvalidProfileEntryException {
        this.getValidator().validate(node);
        return new OperationEntry(node, nextNode);
    }

    @Override
    protected ProfileEntryValidator getValidator() {
        return new ProfileEntryValidator();
    }

    @Override
    protected void appendNewPattern(Element newNode) {
        String value = newNode.getAttribute("pattern");
        if (!value.endsWith(".")) {
            if (this.firstLowLevelPatternNode != null) {
                super.insertNewPattern(newNode, this.firstLowLevelPatternNode);
            } else {
                super.appendNewPattern(newNode);
            }
        } else {
            super.appendNewPattern(newNode);
            if (this.firstLowLevelPatternNode == null) {
                this.firstLowLevelPatternNode = newNode;
            }
        }
    }

    @Override
    protected void updatePatternOptionalFields(ProfileEntry entry, Element newNode) {
        super.updatePatternOptionalFields(entry, newNode);
        if (!(entry instanceof OperationEntry)) {
            return;
        }
        OperationEntry operationEntry = (OperationEntry)entry;
        if (!operationEntry.contentionTypeEquals(newNode)) {
            String value = newNode.getAttribute("type");
            if (value.isEmpty()) {
                operationEntry.removeContentionType();
            } else {
                operationEntry.updateContentionType(newNode);
            }
        }
    }
}

