/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.pattern;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jeyzer.profile.data.ProfileEntry;
import org.jeyzer.profile.data.validation.ProfileEntryValidator;
import org.jeyzer.profile.error.InvalidPatternsException;
import org.jeyzer.profile.error.InvalidProfileEntryException;
import org.jeyzer.profile.util.ConfigUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class PatternUpdater {
    public static final String JZR_PROFILE = "profile";
    public static final String JZR_PATTERNS = "patterns";
    public static final String JZR_FUNCTION = "function";
    public static final String JZR_OPERATION = "operation";
    public static final String JZR_LOCKER = "locker";
    public static final String JZR_EXCLUDE = "exclude";
    public static final String JZR_EXCLUDE_THREAD_NAME = "exclude_thread_name";
    public static final String JZR_EXECUTOR = "executor";
    public static final String JZR_EXECUTOR_THREAD_NAME = "executor_thread_name";
    protected Document doc;
    protected Element typePatternsNode;
    protected NodeList targetNodes;

    public PatternUpdater(Document doc) throws InvalidPatternsException {
        this.doc = doc;
        NodeList nodes = doc.getElementsByTagName(JZR_PROFILE);
        if (nodes.getLength() == 0) {
            throw new InvalidPatternsException("profile node is missing in target profile file " + doc.getDocumentURI());
        }
        Element profileNode = (Element)nodes.item(0);
        Element patternsNode = ConfigUtil.getFirstChildNode(profileNode, JZR_PATTERNS);
        if (patternsNode == null) {
            throw new InvalidPatternsException("patterns node is missing in target profile file " + doc.getDocumentURI());
        }
        this.typePatternsNode = this.getTypePatternsNode(patternsNode, true);
        this.targetNodes = this.typePatternsNode.getElementsByTagName(this.getName());
    }

    public abstract String getName();

    public void updatePatterns(Element newPatterns) {
        Element newTypePatternsNode = this.getTypePatternsNode(newPatterns, false);
        if (newTypePatternsNode == null) {
            return;
        }
        NodeList newNodes = newTypePatternsNode.getElementsByTagName(this.getName());
        if (newNodes.getLength() == 0) {
            return;
        }
        Multimap<String, ProfileEntry> targetNodeCache = this.buildCache(this.targetNodes);
        for (int i = 0; i < newNodes.getLength(); ++i) {
            Element newNode = (Element)newNodes.item(i);
            try {
                this.getValidator().validate(newNode);
            }
            catch (InvalidProfileEntryException ex) {
                System.err.println("Warning : Invalid profile entry to add : " + ex.getMessage());
                continue;
            }
            this.insertNewPattern(newNode, targetNodeCache);
        }
    }

    protected abstract ProfileEntry createProfileEntry(Element var1, Element var2) throws InvalidProfileEntryException;

    protected abstract ProfileEntryValidator getValidator();

    protected void updatePatternOptionalFields(ProfileEntry entry, Element newNode) {
        if (!entry.priorityEquals(newNode)) {
            int newPriority;
            String value = newNode.getAttribute("priority");
            int n = newPriority = !value.isEmpty() ? Integer.parseInt(value) : -1;
            if (newPriority == -1) {
                entry.removePriority();
            } else {
                entry.updatePriority(newNode);
            }
        }
    }

    protected void appendNewPattern(Element newNode) {
        Element newChild = (Element)newNode.cloneNode(true);
        this.doc.adoptNode(newChild);
        this.typePatternsNode.appendChild(newChild);
    }

    private void insertNewPattern(Element newNode, Multimap<String, ProfileEntry> targetNodeCache) {
        Collection entries = targetNodeCache.get((Object)newNode.getAttribute("name"));
        if (entries.isEmpty()) {
            this.appendNewPattern(newNode);
        } else {
            this.insertNewPattern(newNode, entries);
        }
    }

    private void insertNewPattern(Element newNode, Collection<ProfileEntry> entries) {
        ProfileEntry lastEntry = null;
        for (ProfileEntry entry : entries) {
            if (entry.nodeEquals(newNode)) {
                return;
            }
            if (entry.patternEquals(newNode)) {
                this.updatePatternOptionalFields(entry, newNode);
                return;
            }
            lastEntry = entry;
        }
        if (lastEntry == null) {
            return;
        }
        this.insertNewPattern(newNode, lastEntry);
    }

    private void insertNewPattern(Element newNode, ProfileEntry lastEntry) {
        Element nextNode = lastEntry.getNextNode();
        if (nextNode == null) {
            this.appendNewPattern(newNode);
        } else {
            this.insertNewPattern(newNode, nextNode);
        }
    }

    protected void insertNewPattern(Element newNode, Element nextNode) {
        Element newChild = (Element)newNode.cloneNode(true);
        this.doc.adoptNode(newChild);
        this.typePatternsNode.insertBefore(newChild, nextNode);
    }

    private Multimap<String, ProfileEntry> buildCache(NodeList targetNodes) {
        LinkedHashMultimap targetNodeCache = LinkedHashMultimap.create();
        for (int i = 0; i < targetNodes.getLength(); ++i) {
            Element node = (Element)targetNodes.item(i);
            Element nextNode = i != targetNodes.getLength() ? (Element)targetNodes.item(i + 1) : null;
            try {
                ProfileEntry entry = this.createProfileEntry(node, nextNode);
                targetNodeCache.put((Object)entry.getName(), (Object)entry);
                continue;
            }
            catch (InvalidProfileEntryException ex) {
                System.err.print("Warning : Failed to create profile entry. " + ex.getMessage());
            }
        }
        return targetNodeCache;
    }

    private Element getTypePatternsNode(Element patternsNode, boolean create) {
        NodeList patternTypesNodes = patternsNode.getElementsByTagName(this.getName() + "s");
        if (patternTypesNodes.getLength() == 0) {
            return create ? this.doc.createElement(this.getName() + "s") : null;
        }
        return (Element)patternTypesNodes.item(0);
    }
}

