/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.pattern;

import org.jeyzer.profile.error.InvalidPatternsException;
import org.jeyzer.profile.pattern.ExcludeThreadNameUpdater;
import org.jeyzer.profile.pattern.ExcludeUpdater;
import org.jeyzer.profile.pattern.ExecutorThreadNameUpdater;
import org.jeyzer.profile.pattern.ExecutorUpdater;
import org.jeyzer.profile.pattern.FunctionUpdater;
import org.jeyzer.profile.pattern.LockerUpdater;
import org.jeyzer.profile.pattern.OperationUpdater;
import org.jeyzer.profile.pattern.PatternUpdater;
import org.w3c.dom.Document;

public class PatternUpdaterFactory {
    private static final PatternUpdaterFactory factory = new PatternUpdaterFactory();

    private PatternUpdaterFactory() {
    }

    public static PatternUpdaterFactory newInstance() {
        return factory;
    }

    public PatternUpdater getPatternUpdater(String type, Document doc) throws InvalidPatternsException {
        if ("function".equals(type)) {
            return new FunctionUpdater(doc);
        }
        if ("operation".equals(type)) {
            return new OperationUpdater(doc);
        }
        if ("locker".equals(type)) {
            return new LockerUpdater(doc);
        }
        if ("exclude".equals(type)) {
            return new ExcludeUpdater(doc);
        }
        if ("executor".equals(type)) {
            return new ExecutorUpdater(doc);
        }
        if ("executor_thread_name".equals(type)) {
            return new ExecutorThreadNameUpdater(doc);
        }
        if ("exclude_thread_name".equals(type)) {
            return new ExcludeThreadNameUpdater(doc);
        }
        return null;
    }
}

