/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jeyzer.profile.error.InvalidPatternsException;
import org.jeyzer.profile.error.ProfileUpdaterInitException;
import org.jeyzer.profile.pattern.PatternUpdaterFactory;
import org.jeyzer.profile.util.ConfigUtil;
import org.jeyzer.profile.util.PrettyXMLPrinter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JeyzerProfileUpdater {
    private static final String JEYZER_PATTERNS_SOURCE_PATH = "jeyzer.patterns.source";
    private static final String JEYZER_PATTERNS_TARGET_PATH = "jeyzer.patterns.target";
    private static final String JEYZER_NEW_PATTERN_ENTRIES_PATH = "jeyzer.new.patterns.entries";
    private static final String PATTERNS_SOURCE_COPY_SUFFIX = ".source";

    public void execute(File patternsSource, File profileTarget, File newPatternEntries) throws InvalidPatternsException, ProfileUpdaterInitException, Exception {
        this.validateInputs(patternsSource, newPatternEntries);
        this.copyPatternsSource(patternsSource, profileTarget);
        Element newPatterns = this.loadNewPatternEntries(newPatternEntries);
        this.updatePatterns(profileTarget, newPatterns);
    }

    private void validateInputs(File patternsSource, File newPatternEntries) throws ProfileUpdaterInitException {
        if (!patternsSource.exists()) {
            throw new ProfileUpdaterInitException("Jeyzer patterns source file not found : " + patternsSource.getPath());
        }
        if (!newPatternEntries.exists()) {
            throw new ProfileUpdaterInitException("Jeyzer new pattern entries file not found : " + newPatternEntries.getPath());
        }
    }

    private Element loadNewPatternEntries(File newPatternEntriesPath) throws InvalidPatternsException, Exception {
        Document sourceDoc = ConfigUtil.loadXMLFile(newPatternEntriesPath);
        if (sourceDoc == null) {
            throw new InvalidPatternsException("Failed to open the pattern entries configuration using path : " + newPatternEntriesPath);
        }
        NodeList nodes = sourceDoc.getElementsByTagName("patterns");
        return (Element)nodes.item(0);
    }

    private void copyPatternsSource(File patternsSourcePath, File patternsTargetPath) throws IOException {
        Files.copy(patternsSourcePath.toPath(), patternsTargetPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
        PrettyXMLPrinter.makePrettyXML(patternsSourcePath, new File(patternsTargetPath.getPath() + PATTERNS_SOURCE_COPY_SUFFIX));
    }

    private void updatePatterns(File patternsTargetPath, Element newPatterns) throws InvalidPatternsException, Exception {
        Document doc = ConfigUtil.loadXMLFile(patternsTargetPath);
        if (doc == null) {
            throw new InvalidPatternsException("Failed to open the target patterns configuration using path : " + patternsTargetPath);
        }
        PatternUpdaterFactory factory = PatternUpdaterFactory.newInstance();
        factory.getPatternUpdater("function", doc).updatePatterns(newPatterns);
        factory.getPatternUpdater("operation", doc).updatePatterns(newPatterns);
        factory.getPatternUpdater("locker", doc).updatePatterns(newPatterns);
        factory.getPatternUpdater("executor", doc).updatePatterns(newPatterns);
        factory.getPatternUpdater("executor_thread_name", doc).updatePatterns(newPatterns);
        factory.getPatternUpdater("exclude", doc).updatePatterns(newPatterns);
        factory.getPatternUpdater("exclude_thread_name", doc).updatePatterns(newPatterns);
        this.updateXml(doc, patternsTargetPath);
        PrettyXMLPrinter.makePrettyXML(patternsTargetPath, patternsTargetPath);
    }

    private void updateXml(Document doc, File patternsTargetPath) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(patternsTargetPath);
        transformer.transform(source, result);
    }

    public static void main(String[] args) {
        JeyzerProfileUpdater updater = new JeyzerProfileUpdater();
        File patternsSource = new File(JeyzerProfileUpdater.loadStartupSystemProperty(JEYZER_PATTERNS_SOURCE_PATH));
        File patternsTarget = new File(JeyzerProfileUpdater.loadStartupSystemProperty(JEYZER_PATTERNS_TARGET_PATH));
        File newPatternEntries = new File(JeyzerProfileUpdater.loadStartupSystemProperty(JEYZER_NEW_PATTERN_ENTRIES_PATH));
        System.out.println("Generating patterns    : " + patternsSource.getPath());
        System.out.println("  from source patterns : " + patternsTarget.getPath());
        System.out.println("  with pattern entries from   : " + newPatternEntries.getPath());
        try {
            updater.execute(patternsSource, patternsTarget, newPatternEntries);
            System.out.println("Analysis patterns update succeeded. Result and source diff can be performed between those 2 files :");
            System.out.println("  Source : " + patternsTarget.getPath() + PATTERNS_SOURCE_COPY_SUFFIX);
            System.out.println("  Target : " + patternsTarget.getPath());
        }
        catch (Exception ex) {
            System.err.println("Analysis patterns update failed.");
            ex.printStackTrace();
        }
    }

    private static String loadStartupSystemProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            System.err.println("Profile updater system property  " + propertyName + " is missing.");
            System.exit(-1);
        }
        return value;
    }
}

