/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.data.validation;

import org.jeyzer.profile.data.validation.ProfileEntryNameBasedValidator;
import org.jeyzer.profile.error.InvalidProfileEntryException;
import org.w3c.dom.Element;

public class ExcludeThreadNameValidator
extends ProfileEntryNameBasedValidator {
    protected static final int MIN_SIZE = 1;

    @Override
    public void validate(Element node) throws InvalidProfileEntryException {
        super.validate(node);
        if (node.getAttribute("size").isEmpty()) {
            return;
        }
        if (this.getSize(node) < 1) {
            throw new InvalidProfileEntryException("Size value \"" + node.getAttribute("size") + "\" is invalid. It must be greater than " + 1);
        }
    }

    protected int getSize(Element node) {
        try {
            return Integer.parseInt(node.getAttribute("size"));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

