/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.data.validation;

import org.jeyzer.profile.error.InvalidProfileEntryException;
import org.w3c.dom.Element;

public class ProfileEntryValidator {
    protected static final int MIN_PRIORITY = 101;
    protected static final int MAX_PRIORITY = 1000;

    public void validate(Element node) throws InvalidProfileEntryException {
        if (this.getName(node).isEmpty()) {
            throw new InvalidProfileEntryException("Missing or empty profile entry name");
        }
        this.validatePattern(node);
        if (node.getAttribute("priority").isEmpty()) {
            return;
        }
        if (this.getPriority(node) < 101 || this.getPriority(node) > 1000) {
            throw new InvalidProfileEntryException("Priority value \"" + node.getAttribute("priority") + "\" is invalid. It must be set between " + 101 + " and " + 1000);
        }
    }

    protected void validatePattern(Element node) throws InvalidProfileEntryException {
        if (this.getPattern(node).isEmpty()) {
            throw new InvalidProfileEntryException("Missing or empty profile entry pattern");
        }
    }

    protected String getName(Element node) {
        return node.getAttribute("name");
    }

    protected String getPattern(Element node) {
        return node.getAttribute("pattern");
    }

    protected int getPriority(Element node) {
        try {
            return Integer.parseInt(node.getAttribute("priority"));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

