/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.profile.pattern;

import org.jeyzer.profile.data.ExcludeThreadNameEntry;
import org.jeyzer.profile.data.ProfileEntry;
import org.jeyzer.profile.data.validation.ExcludeThreadNameValidator;
import org.jeyzer.profile.data.validation.ProfileEntryValidator;
import org.jeyzer.profile.error.InvalidPatternsException;
import org.jeyzer.profile.error.InvalidProfileEntryException;
import org.jeyzer.profile.pattern.PatternUpdater;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExcludeThreadNameUpdater
extends PatternUpdater {
    public ExcludeThreadNameUpdater(Document doc) throws InvalidPatternsException {
        super(doc);
    }

    @Override
    public String getName() {
        return "exclude_thread_name";
    }

    @Override
    protected ProfileEntry createProfileEntry(Element node, Element nextNode) throws InvalidProfileEntryException {
        this.getValidator().validate(node);
        return new ExcludeThreadNameEntry(node, nextNode);
    }

    @Override
    protected ProfileEntryValidator getValidator() {
        return new ExcludeThreadNameValidator();
    }

    @Override
    protected void updatePatternOptionalFields(ProfileEntry entry, Element newNode) {
        super.updatePatternOptionalFields(entry, newNode);
        if (!(entry instanceof ExcludeThreadNameEntry)) {
            return;
        }
        ExcludeThreadNameEntry excludeEntry = (ExcludeThreadNameEntry)entry;
        if (!excludeEntry.sizeEquals(newNode)) {
            int newSize;
            String value = newNode.getAttribute("size");
            int n = newSize = !value.isEmpty() ? Integer.parseInt(value) : -1;
            if (newSize == -1) {
                excludeEntry.removeSize();
            } else {
                excludeEntry.updateSize(newNode);
            }
        }
    }
}

