/*
 * Decompiled with CFR 0.152.
 */
package com.hapiware.agent;

import com.hapiware.agent.BootLogger;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Agent {
    static final String AGENT_CONFIGURATION_PATH = "agent-configuration-path";
    private static final String PROPERTY_JEYZER_AGENT_VERSION = "jzr.agent.version";
    private static final String VARIABLE_PATTERN = "(\\$\\{([^\\$\\{\\}]+?)\\})";
    private static final String PREMAIN_SIGNATURE = "static void premain(java.util.regex.Pattern[], java.util.regex.Pattern[], Object, Instrumentation)";
    private static final String SUN_XML_SCHEMA_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory";
    private static final String APACHE_XML_SCHEMA_FACTORY = "org.apache.xerces.jaxp.validation.XMLSchemaFactory";
    private static final String VARIABLE_PREFIX = "${";
    private static final String VARIABLE_SUFFIX = "}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Map<String, String> agentParams = Agent.parseAgentParameters(agentArgs);
        ConfigElements configElements = Agent.readConfigurationFile(agentParams);
        ClassLoader originalClassLoader = null;
        try {
            originalClassLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader cl = new URLClassLoader(configElements.getClasspaths(), originalClassLoader);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> delegateAgentClass = cl.loadClass(configElements.getDelegateAgentName());
            Object delegateConfiguration = Agent.unmarshall(delegateAgentClass, configElements);
            Agent.publishAgentVersion();
            BootLogger.debug("Agent loaded successfully. Calling now the application delegated premain method.");
            delegateAgentClass.getMethod("premain", Pattern[].class, Pattern[].class, Object.class, Instrumentation.class).invoke(null, configElements.getIncludePatterns(), configElements.getExcludePatterns(), delegateConfiguration, instrumentation);
            BootLogger.debug("Agent premain ending.");
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationError("A delegate agent \"" + configElements.getDelegateAgentName() + "\" was not found.", e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationError("static void premain(java.util.regex.Pattern[], java.util.regex.Pattern[], Object, Instrumentation) method was not defined in \"" + configElements.getDelegateAgentName() + "\".", e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationError("Argument mismatch with static void premain(java.util.regex.Pattern[], java.util.regex.Pattern[], Object, Instrumentation) in \"" + configElements.getDelegateAgentName() + "\".", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationError("static void premain(java.util.regex.Pattern[], java.util.regex.Pattern[], Object, Instrumentation) in \"" + configElements.getDelegateAgentName() + "\" threw an exception.", e);
        }
        catch (IllegalAccessException e) {
            assert (false) : e;
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private static Map<String, String> parseAgentParameters(String agentArgs) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(agentArgs, ";", false);
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String agentArg = tokenizer.nextToken();
            if (first) {
                params.put(AGENT_CONFIGURATION_PATH, agentArg);
                first = false;
                continue;
            }
            int endPos = agentArg.indexOf(61);
            if (endPos <= 0 || endPos == agentArg.length() - 1) {
                BootLogger.error("Invalid agent parameter : " + agentArg + " It must be a key=value pair");
                continue;
            }
            String key = agentArg.substring(0, endPos);
            String value = agentArg.substring(endPos + 1);
            params.put(key, value);
        }
        return params;
    }

    static ConfigElements readConfigurationFile(Map<String, String> agentParams) {
        String agentConfigPath = agentParams.get(AGENT_CONFIGURATION_PATH);
        if (agentConfigPath == null) {
            throw new ConfigurationError("The agent configuration file is not defined.");
        }
        File configFile = new File(agentConfigPath);
        if (configFile.exists()) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                return Agent.readDOMDocument(builder.parse(configFile), configFile.getCanonicalPath(), agentParams);
            }
            catch (ParserConfigurationException e) {
                throw new ConfigurationError("XML document builder cannot be created.", e);
            }
            catch (SAXException e) {
                throw new ConfigurationError("Parsing the agent configuration file \"" + configFile + "\" didn't succeed.\n\t->Make sure that the configuration file has been saved using the correct encoding (i.e the same what is claimed in XML declaration).", e);
            }
            catch (IOException e) {
                throw new ConfigurationError("IO error with the agent configuration file \"" + configFile + "\".", e);
            }
        }
        throw new ConfigurationError("The agent configuration file \"" + configFile + "\" does not exist.");
    }

    static ConfigElements readDOMDocument(Document configDocument, String configFileName, Map<String, String> agentParams) {
        ConfigElements retVal = null;
        try {
            Agent.validateDOMDocument(configDocument);
            HashMap<String, VariableValue> variables = new HashMap<String, VariableValue>();
            Agent.loadAgentVariables(configDocument, variables, agentParams);
            Agent.populateAllAttributes(configDocument, variables, agentParams);
            Agent.populateAllData(configDocument, variables, agentParams);
            Agent.instantiateUnresolvedVariables(variables);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String delegateAgent = (String)xpath.evaluate("/agent/delegate", configDocument, XPathConstants.STRING);
            NodeList classpathEntries = (NodeList)xpath.evaluate("/agent/classpath/entry", configDocument, XPathConstants.NODESET);
            ArrayList<String> classpaths = new ArrayList<String>();
            for (int i = 0; i < classpathEntries.getLength(); ++i) {
                Node classpathEntry = classpathEntries.item(i).getFirstChild();
                classpaths.add(((Text)classpathEntry).getData());
            }
            NodeList includeEntries = (NodeList)xpath.evaluate("/agent/filter/include", configDocument, XPathConstants.NODESET);
            ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
            for (int i = 0; i < includeEntries.getLength(); ++i) {
                Node includeEntry = includeEntries.item(i).getFirstChild();
                if (includeEntry == null) continue;
                includePatterns.add(Pattern.compile(((Text)includeEntry).getData()));
            }
            if (includePatterns.size() == 0) {
                includePatterns.add(Pattern.compile(".+"));
            }
            NodeList excludeEntries = (NodeList)xpath.evaluate("/agent/filter/exclude", configDocument, XPathConstants.NODESET);
            ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
            for (int i = 0; i < excludeEntries.getLength(); ++i) {
                Node excludeEntry = excludeEntries.item(i).getFirstChild();
                if (excludeEntry == null) continue;
                excludePatterns.add(Pattern.compile(((Text)excludeEntry).getData()));
            }
            Node configuration = (Node)xpath.evaluate("/agent/configuration", configDocument, XPathConstants.NODE);
            retVal = new ConfigElements(classpaths, includePatterns, excludePatterns, delegateAgent, (Element)configuration);
        }
        catch (SAXException e) {
            throw new ConfigurationError("Validating the agent configuration file \"" + configFileName + "\" didn't succeed.\n\t->" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationError("IO error with the agent configuration file \"" + configFileName + "\".", e);
        }
        catch (XPathExpressionException e) {
            throw new ConfigurationError("A desired config node was not found from the agent configuration file \"" + configFileName + "\".", e);
        }
        return retVal;
    }

    private static void instantiateUnresolvedVariables(Map<String, VariableValue> variables) {
        Pattern variablePattern = Pattern.compile(VARIABLE_PATTERN);
        block0: for (String key : variables.keySet()) {
            String value = variables.get(key).getValue();
            String defaultValue = variables.get(key).getDefaultValue();
            Matcher m = variablePattern.matcher(value);
            while (m.find()) {
                String variableName = m.group(2);
                if (System.getenv().get(variableName) != null || System.getProperty(variableName) != null) continue;
                BootLogger.debug("Agent variable " + key + " is referencing an unresolved variable. Set it as system property " + variableName + " with the default value : " + defaultValue);
                System.setProperty(variableName, defaultValue);
                continue block0;
            }
        }
    }

    private static void populateAllData(Document configDocument, Map<String, VariableValue> variables, Map<String, String> agentParams) throws XPathExpressionException {
        boolean matched;
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList allElements = (NodeList)xpath.evaluate("/agent//*[not(self::variable)]/text()", configDocument, XPathConstants.NODESET);
        do {
            matched = false;
            for (int i = 0; i < allElements.getLength(); ++i) {
                Node elementEntry = allElements.item(i);
                String elementValue = ((Text)elementEntry).getData();
                Pattern variablePattern = Pattern.compile(VARIABLE_PATTERN);
                Matcher m = variablePattern.matcher(elementValue);
                while (m.find()) {
                    matched = true;
                    VariableValue substituteValue = variables.get(m.group(2));
                    if (substituteValue == null) {
                        String ex = "Element \"" + elementEntry.getParentNode().getNodeName() + "\" has an unrecognised variable " + m.group(1);
                        throw new ConfigurationError(ex);
                    }
                    String substitute = substituteValue.getValue();
                    if (substitute.trim().startsWith(VARIABLE_PREFIX)) {
                        if (substituteValue.hasDefaultValue()) {
                            BootLogger.debug("Taking the default value for the " + m.group(1) + " unresolved agent variable. Agent variable value is now : " + substituteValue.getDefaultValue());
                            substitute = substituteValue.getDefaultValue();
                        } else {
                            String ex = "Element \"" + elementEntry.getParentNode().getNodeName() + "\" has an unrecognised variable " + m.group(1) + " and does not have any default value.";
                            throw new ConfigurationError(ex);
                        }
                    }
                    elementValue = elementValue.replace(m.group(1), substitute);
                    ((Text)elementEntry).setData(elementValue);
                }
            }
            NodeList variableEntriesWithName = (NodeList)xpath.evaluate("/agent/variable[@name]", configDocument, XPathConstants.NODESET);
            Agent.putVariablesWithNamesToMap(variableEntriesWithName, variables, agentParams);
        } while (matched);
    }

    private static void populateAllAttributes(Document configDocument, Map<String, VariableValue> variables, Map<String, String> agentParams) throws XPathExpressionException {
        boolean matched;
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList allAttributes = (NodeList)xpath.evaluate("/agent//@*", configDocument, XPathConstants.NODESET);
        Pattern variablePattern = Pattern.compile(VARIABLE_PATTERN);
        do {
            matched = false;
            for (int i = 0; i < allAttributes.getLength(); ++i) {
                Node attributeEntry = allAttributes.item(i);
                String attributeValue = ((Attr)attributeEntry).getValue();
                Matcher m = variablePattern.matcher(attributeValue);
                while (m.find()) {
                    matched = true;
                    VariableValue substituteValue = variables.get(m.group(2));
                    if (substituteValue == null) {
                        String ex = "Attribute \"" + ((Attr)attributeEntry).getOwnerElement().getNodeName() + "[@" + attributeEntry.getNodeName() + "]\" has an unrecognised variable " + m.group(1) + ".";
                        throw new ConfigurationError(ex);
                    }
                    String substitute = variables.get(m.group(2)).getValue();
                    attributeValue = attributeValue.replace(m.group(1), substitute);
                    ((Attr)attributeEntry).setValue(attributeValue);
                }
            }
            NodeList variableEntriesWithName = (NodeList)xpath.evaluate("/agent/variable[@name]", configDocument, XPathConstants.NODESET);
            Agent.putVariablesWithNamesToMap(variableEntriesWithName, variables, agentParams);
        } while (matched);
    }

    private static void loadAgentVariables(Document configDocument, Map<String, VariableValue> variables, Map<String, String> agentParams) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList allVariableEntries = (NodeList)xpath.evaluate("/agent/variable", configDocument, XPathConstants.NODESET);
        NodeList variableEntriesWithName = (NodeList)xpath.evaluate("/agent/variable[@name]", configDocument, XPathConstants.NODESET);
        if (allVariableEntries.getLength() != variableEntriesWithName.getLength()) {
            throw new ConfigurationError("\"name\" attribute is mandatory on the /agent/variable element.");
        }
        Agent.putVariablesWithNamesToMap(variableEntriesWithName, variables, agentParams);
    }

    private static void validateDOMDocument(Document configDocument) throws SAXException, IOException {
        SchemaFactory factory;
        ClassLoader classLoader;
        boolean validate;
        block3: {
            validate = true;
            classLoader = Thread.currentThread().getContextClassLoader();
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", SUN_XML_SCHEMA_FACTORY, Agent.class.getClassLoader());
            }
            catch (IllegalArgumentException ex) {
                BootLogger.debug("Sun Apache schema factory : com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory not found. Loading default one.");
                factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                BootLogger.debug("Default JVM schema factory is : " + factory.getClass().getName());
                if (!APACHE_XML_SCHEMA_FACTORY.equals(factory.getClass().getName())) break block3;
                validate = false;
            }
        }
        if (validate) {
            StreamSource schemaFile = new StreamSource(classLoader.getResourceAsStream("agent.xsd"));
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(configDocument));
        }
    }

    private static void putVariablesWithNamesToMap(NodeList variableEntries, Map<String, VariableValue> map, Map<String, String> agentParams) {
        map.clear();
        for (int i = 0; i < variableEntries.getLength(); ++i) {
            Node variableEntry = variableEntries.item(i);
            Node variableValue = variableEntry.getFirstChild();
            NamedNodeMap nameAttributes = variableEntry.getAttributes();
            Node nameAttribute = nameAttributes.getNamedItem("name");
            String value = Agent.resolveValue(((Text)variableValue).getData(), map, agentParams);
            Node defaultAttribute = nameAttributes.getNamedItem("default");
            String defaultValue = null;
            if (defaultAttribute != null && defaultAttribute.getNodeValue() != null) {
                defaultValue = Agent.resolveValue(defaultAttribute.getNodeValue(), map, agentParams);
                defaultAttribute.setNodeValue(defaultValue);
            }
            map.put(nameAttribute.getNodeValue(), new VariableValue(value, defaultValue));
        }
    }

    private static String resolveValue(String value, Map<String, VariableValue> map, Map<String, String> agentParams) {
        StringBuilder resolvedValue = new StringBuilder(10);
        int end = 0;
        int pos = 0;
        int prev = 0;
        while (pos != -1) {
            if ((pos = value.indexOf(VARIABLE_PREFIX, pos)) != -1) {
                resolvedValue.append(value.substring(prev, pos));
                end = value.indexOf(VARIABLE_SUFFIX, pos);
                if (end == -1) {
                    resolvedValue.append(value.substring(pos));
                    return resolvedValue.toString();
                }
                resolvedValue.append(Agent.resolveVariable(value.substring(pos, end + 1), map, agentParams));
                prev = end + 1;
                pos = ++end;
                continue;
            }
            resolvedValue.append(value.substring(end, value.length()));
        }
        return resolvedValue.toString();
    }

    private static String resolveVariable(String value, Map<String, VariableValue> map, Map<String, String> agentParams) {
        if (value != null && value.startsWith(VARIABLE_PREFIX) && value.endsWith(VARIABLE_SUFFIX)) {
            String resolvedValue;
            String variable = value.substring(2, value.length() - 1);
            if (variable.length() == 0) {
                return value;
            }
            if (map.get(variable) != null && (resolvedValue = map.get(variable).getValue()) != null) {
                BootLogger.debug("Variable " + variable + " is resolved through inner variable. Resulting value is : " + resolvedValue);
                return Agent.resolveInnerVariable(resolvedValue, value, map, agentParams);
            }
            resolvedValue = agentParams.get(variable);
            if (resolvedValue != null) {
                BootLogger.debug("Variable " + variable + " is resolved through agent parameter. Resulting value is : " + resolvedValue);
                return Agent.resolveInnerVariable(resolvedValue, value, map, agentParams);
            }
            resolvedValue = System.getProperty(variable);
            if (resolvedValue != null) {
                BootLogger.debug("Variable " + variable + " is resolved through system property. Resulting value is : " + resolvedValue);
                return Agent.resolveInnerVariable(resolvedValue, value, map, agentParams);
            }
            resolvedValue = System.getenv(variable);
            if (resolvedValue != null) {
                BootLogger.debug("Variable " + variable + " is resolved through environment variable. Resulting value is : " + resolvedValue);
                return Agent.resolveInnerVariable(resolvedValue, value, map, agentParams);
            }
        }
        return value;
    }

    private static String resolveInnerVariable(String resolvedValue, String originalValue, Map<String, VariableValue> map, Map<String, String> agentParams) {
        String result = resolvedValue;
        if (resolvedValue.contains(VARIABLE_PREFIX)) {
            result = Agent.resolveValue(resolvedValue, map, agentParams);
        }
        return result;
    }

    static Object unmarshall(Class<?> delegateAgentClass, ConfigElements configElements) {
        Element configElement = configElements.getConfigurationElement();
        if (configElement != null) {
            Node firstNode;
            Node targetNode;
            if (configElement.getElementsByTagName("item").getLength() > 0) {
                return Agent.createCollectionConfiguration(configElements);
            }
            boolean customElementFound = false;
            boolean textNodeFound = false;
            for (targetNode = firstNode = configElement.getFirstChild(); targetNode != null; targetNode = targetNode.getNextSibling()) {
                if (targetNode.getNodeName().equals("#text") && targetNode.getNodeValue().trim().length() > 0) {
                    textNodeFound = true;
                }
                if (!targetNode.getNodeName().equals("custom")) continue;
                customElementFound = true;
                break;
            }
            if (textNodeFound && customElementFound) {
                throw new ConfigurationError("/agent/configuration/custom element cannot co-exist with a text element (i.e. a pure string under /agent/configuration).");
            }
            if (!customElementFound) {
                targetNode = firstNode;
            }
            if (customElementFound) {
                try {
                    return delegateAgentClass.getMethod("unmarshall", Element.class).invoke(null, targetNode);
                }
                catch (NoSuchMethodException e) {
                    throw new ConfigurationError("static Object unmarshall(Element) method was not defined in \"" + delegateAgentClass.getName() + "\".", e);
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationError("Argument mismatch with static Object unmarshall(Element) method in \"" + delegateAgentClass.getName() + "\".", e);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationError("static Object unmarshall(Element) method in \"" + delegateAgentClass.getName() + "\" threw an exception.", e);
                }
                catch (IllegalAccessException e) {
                    assert (false) : e;
                    return null;
                }
            }
            if (targetNode == null || targetNode.getNodeValue().trim().length() == 0) {
                throw new ConfigurationError("/agent/configuration does not have a proper string (i.e. text element) (or any other elements)");
            }
            return targetNode.getNodeValue().trim();
        }
        return null;
    }

    private static Object createCollectionConfiguration(ConfigElements configElements) {
        Cloneable retVal;
        block11: {
            boolean dontUseMap = false;
            boolean dontUseList = false;
            retVal = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            try {
                Node item;
                NodeList configurationItems = (NodeList)xpath.evaluate("./item", configElements.getConfigurationElement(), XPathConstants.NODESET);
                for (int i = 0; i < configurationItems.getLength(); ++i) {
                    Node item2 = configurationItems.item(i);
                    if (item2.getAttributes().getNamedItem("key") == null) {
                        dontUseMap = true;
                        continue;
                    }
                    dontUseList = true;
                }
                if (dontUseList && dontUseMap) {
                    throw new ConfigurationError("/agent/configuration/item tags have improper attributes.");
                }
                if (!dontUseList) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < configurationItems.getLength(); ++i) {
                        item = configurationItems.item(i).getFirstChild();
                        if (item != null) {
                            list.add(((Text)item).getData());
                            continue;
                        }
                        list.add("");
                    }
                    retVal = list;
                }
                if (!dontUseMap) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int i = 0; i < configurationItems.getLength(); ++i) {
                        String key;
                        item = configurationItems.item(i);
                        Node keyNode = item.getAttributes().getNamedItem("key");
                        String string = key = keyNode == null ? "" : keyNode.getNodeValue();
                        if (item == null) continue;
                        map.put(key, ((Text)item.getFirstChild()).getData());
                    }
                    retVal = map;
                }
            }
            catch (XPathExpressionException e) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)e);
            }
        }
        assert (retVal != null);
        return retVal;
    }

    public static void publishAgentVersion() {
        try {
            Class<Agent> clazz = Agent.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return;
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Specification-Version");
            if (value == null) {
                return;
            }
            System.setProperty(PROPERTY_JEYZER_AGENT_VERSION, value);
        }
        catch (IOException ex) {
            BootLogger.warning("Failed to access the Agent version from its Manifest file : " + ex.getMessage());
        }
    }

    static class VariableValue {
        private String value;
        private String defaultValue;

        public VariableValue(String value, String defaultValue) {
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }
    }

    static class ConfigurationError
    extends Error {
        private static final long serialVersionUID = 1L;

        public ConfigurationError() {
        }

        public ConfigurationError(String message, Throwable cause) {
            super(message, cause);
        }

        public ConfigurationError(String message) {
            super(message);
        }

        public ConfigurationError(Throwable cause) {
            super(cause);
        }
    }

    static class ConfigElements {
        private final String delegateAgentName;
        private final List<Pattern> includePatterns;
        private final List<Pattern> excludePatterns;
        private final List<URL> classpaths;
        private final Element configurationElement;

        public ConfigElements(List<String> classpaths, List<Pattern> includePatterns, List<Pattern> excludePatterns, String delegateAgentName, Element configElement) throws MalformedURLException {
            ArrayList<URL> classpathsAsURLs = new ArrayList<URL>();
            for (String classpath : classpaths) {
                File file = new File(classpath);
                if (!file.exists()) {
                    BootLogger.warning("Agent class path entry is invalid : " + file + " - Please fix the agent classpath configuration.");
                    continue;
                }
                classpathsAsURLs.add(file.toURI().toURL());
            }
            this.classpaths = Collections.unmodifiableList(classpathsAsURLs);
            this.includePatterns = Collections.unmodifiableList(includePatterns);
            this.excludePatterns = Collections.unmodifiableList(excludePatterns);
            this.delegateAgentName = delegateAgentName;
            this.configurationElement = configElement;
        }

        public Element getConfigurationElement() {
            return this.configurationElement;
        }

        public String getDelegateAgentName() {
            return this.delegateAgentName;
        }

        public URL[] getClasspaths() {
            return this.classpaths.toArray(new URL[0]);
        }

        public Pattern[] getIncludePatterns() {
            return this.includePatterns.toArray(new Pattern[0]);
        }

        public Pattern[] getExcludePatterns() {
            return this.excludePatterns.toArray(new Pattern[0]);
        }
    }
}

