/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.demo.shared;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Random;
import javax.management.MBeanServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DemoHelper {
    private static final Logger logger = LoggerFactory.getLogger(DemoHelper.class);
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String JVM_FLAG = "HeapDumpPath";
    private static final Random random = new Random();

    private DemoHelper() {
    }

    public static int getNextRandomInt(int limit) {
        return random.nextInt(limit);
    }

    public static int getNextRandomInt() {
        return random.nextInt();
    }

    public static void updateJVMHeapDumpPathFlag() {
        try {
            Class<?> hotspotDiagClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, hotspotDiagClass);
            Method m = hotspotDiagClass.getMethod("setVMOption", String.class, String.class);
            m.invoke(hotspotMBean, JVM_FLAG, System.getProperty("java.io.tmpdir"));
        }
        catch (RuntimeException re) {
            logger.error("Failed to set the JVM flag : {}", (Object)JVM_FLAG);
            logger.error("Error is : {}", (Object)re.getMessage());
        }
        catch (Exception exp) {
            logger.error("Failed to set the JVM flag : {}", (Object)JVM_FLAG);
            logger.error("Error is : {}", (Object)exp.getMessage());
        }
    }
}

