/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.mx.event;

import org.jeyzer.mx.event.JzrEventLevel;
import org.jeyzer.mx.event.JzrEventSubLevel;

public enum JzrPublisherEventCode {
    JZR_PUB_001(JzrEventLevel.WARNING, JzrEventSubLevel.HIGH, "Jeyzer Publisher is disabled : applicative events and data will not be made available to the Jeyzer Recorder. Set the jeyzer.publisher.active system property to true to activate it. Requires applicative restart."),
    JZR_PUB_002(JzrEventLevel.INFO, JzrEventSubLevel.LOW, "Jeyzer Publisher is active : applicative events and data are collected. Set the jeyzer.publisher.active system property to false to disable it. Requires applicative restart."),
    JZR_PUB_003(JzrEventLevel.INFO, JzrEventSubLevel.VERY_LOW, "Jeyzer recording collection."),
    JZR_PUB_101(JzrEventLevel.WARNING, JzrEventSubLevel.VERY_HIGH, "Applicative critical event list full. Events created after @token@ (process time) may be lost. Increase the events.critical.limit init property to accept more events or review the applicative critical event generation to reduce it."),
    JZR_PUB_102(JzrEventLevel.WARNING, JzrEventSubLevel.HIGH, "Applicative critical event collection suspended at initialization time."),
    JZR_PUB_103(JzrEventLevel.WARNING, JzrEventSubLevel.HIGH, "Applicative critical event collection suspended at runtime."),
    JZR_PUB_104(JzrEventLevel.INFO, JzrEventSubLevel.VERY_HIGH, "Applicative critical event collection resumed."),
    JZR_PUB_201(JzrEventLevel.WARNING, JzrEventSubLevel.HIGH, "Applicative warning event list full. Events created after @token@ (process time) may be lost. Increase the events.warning.limit init property to accept more events or review the applicative warning event generation to reduce it."),
    JZR_PUB_202(JzrEventLevel.WARNING, JzrEventSubLevel.MEDIUM, "Applicative warning event collection suspended at initialization time."),
    JZR_PUB_203(JzrEventLevel.WARNING, JzrEventSubLevel.MEDIUM, "Applicative warning event collection suspended at runtime."),
    JZR_PUB_204(JzrEventLevel.INFO, JzrEventSubLevel.HIGH, "Applicative warning event collection resumed."),
    JZR_PUB_301(JzrEventLevel.WARNING, JzrEventSubLevel.MEDIUM, "Applicative info event list full. Events created after @token@ (process time) may be lost. Increase the events.info.limit init property to accept more events or review the applicative info event generation to reduce it."),
    JZR_PUB_302(JzrEventLevel.WARNING, JzrEventSubLevel.MEDIUM, "Applicative info event collection suspended at initialization time."),
    JZR_PUB_303(JzrEventLevel.WARNING, JzrEventSubLevel.MEDIUM, "Applicative info event collection suspended at runtime."),
    JZR_PUB_304(JzrEventLevel.INFO, JzrEventSubLevel.MEDIUM, "Applicative info event collection resumed."),
    JZR_PUB_502(JzrEventLevel.WARNING, JzrEventSubLevel.HIGH, "Applicative data collection suspended at initialization time."),
    JZR_PUB_503(JzrEventLevel.WARNING, JzrEventSubLevel.HIGH, "Applicative data collection suspended at runtime."),
    JZR_PUB_504(JzrEventLevel.INFO, JzrEventSubLevel.HIGH, "Applicative data collection resumed.");

    private final String description;
    private final JzrEventLevel level;
    private final JzrEventSubLevel subLevel;

    private JzrPublisherEventCode(JzrEventLevel level, JzrEventSubLevel subLevel, String value) {
        this.level = level;
        this.subLevel = subLevel;
        this.description = value;
    }

    public String getDisplayValue() {
        return this.name();
    }

    public JzrEventLevel getLevel() {
        return this.level;
    }

    public JzrEventSubLevel getSubLevel() {
        return this.subLevel;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(String tokenValue) {
        return this.description.replace("@token@", tokenValue);
    }
}

