/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.publish;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jeyzer.mx.JeyzerMXBean;
import org.jeyzer.mx.JzrThreadInfo;
import org.jeyzer.mx.event.JzrEventCode;
import org.jeyzer.mx.event.JzrEventInfo;
import org.jeyzer.mx.event.JzrEventLevel;
import org.jeyzer.mx.event.JzrEventScope;
import org.jeyzer.mx.event.JzrEventSubLevel;
import org.jeyzer.mx.event.JzrPublisherEvent;
import org.jeyzer.mx.event.JzrPublisherEventCode;
import org.jeyzer.publish.JzrActionContext;
import org.jeyzer.publish.JzrActionHandler;
import org.jeyzer.publish.JzrMonitorHandler;
import org.jeyzer.publish.event.JzrEvent;

public abstract class JeyzerPublisher
implements JeyzerMXBean {
    private static final String JEYZER_PUBLISHER_ACTIVE_SYSTEM_PROPERTY = "jeyzer.publisher.active";
    private static final JeyzerPublisher publisher = Boolean.parseBoolean(System.getProperty("jeyzer.publisher.active")) ? new JeyzerPublisherImpl() : new JeyzerPublisherNoImpl();
    private String publisherVersion;

    public static JeyzerPublisher instance() {
        return publisher;
    }

    public abstract boolean init(Properties var1);

    public abstract void setProfileName(String var1);

    public abstract void setNodeName(String var1);

    public abstract void setProcessName(String var1);

    public abstract void setProcessVersion(String var1);

    public abstract void setProcessBuildNumber(String var1);

    public abstract void addStaticProcessContextParam(String var1, String var2);

    public abstract void setDynamicProcessContextParam(String var1, String var2);

    public abstract void removeDynamicProcessContextParam(String var1);

    public abstract JzrMonitorHandler getMonitorHandler(String var1, String var2);

    public abstract JzrActionHandler getActionHandler();

    void register() {
        ObjectName mxbeanName = null;
        try {
            mxbeanName = new ObjectName("org.jeyzer.mx:type=Jeyzer");
        }
        catch (MalformedObjectNameException e) {
            System.err.print("Warning : Failed to start Jeyzer Publisher. Error is : " + e.getMessage());
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, mxbeanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            System.err.print("Warning : Failed to start Jeyzer Publisher. Error is : " + e.getMessage());
        }
    }

    @Override
    public String getPublisherVersion() {
        if (this.publisherVersion == null) {
            this.publisherVersion = this.loadPublisherVersion();
        }
        return this.publisherVersion;
    }

    private String loadPublisherVersion() {
        try {
            Class<JeyzerPublisher> clazz = JeyzerPublisher.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return "Not available : classes mode";
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String value = attr.getValue("Specification-Version");
            if (value == null) {
                return "Not available : war mode";
            }
            return value;
        }
        catch (IOException e) {
            return "Not available - Manifest read error";
        }
    }

    private static final class JeyzerPublisherNoImpl
    extends JeyzerPublisher {
        private static final String EMPTY_VALUE = "";
        private boolean getEventsFirstCall = true;

        protected JeyzerPublisherNoImpl() {
            this.register();
        }

        @Override
        public boolean init(Properties props) {
            return true;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public String getProfileName() {
            return EMPTY_VALUE;
        }

        @Override
        public String getNodeName() {
            return EMPTY_VALUE;
        }

        @Override
        public String getProcessName() {
            return EMPTY_VALUE;
        }

        @Override
        public String getProcessVersion() {
            return EMPTY_VALUE;
        }

        @Override
        public String getProcessBuildNumber() {
            return EMPTY_VALUE;
        }

        @Override
        public List<JzrThreadInfo> getThreadInfoList() {
            return new ArrayList<JzrThreadInfo>();
        }

        @Override
        public Map<String, String> getStaticProcessContextParams() {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> getDynamicProcessContextParams() {
            return new HashMap<String, String>();
        }

        @Override
        public void setProfileName(String profile) {
        }

        @Override
        public void setNodeName(String nodeName) {
        }

        @Override
        public void setProcessName(String name) {
        }

        @Override
        public void setProcessVersion(String version) {
        }

        @Override
        public void setProcessBuildNumber(String name) {
        }

        @Override
        public void addStaticProcessContextParam(String key, String value) {
        }

        @Override
        public void setDynamicProcessContextParam(String key, String value) {
        }

        @Override
        public void removeDynamicProcessContextParam(String key) {
        }

        @Override
        public JzrActionHandler getActionHandler() {
            return new JzrActionHandlerNoImpl();
        }

        @Override
        public List<JzrEventInfo> getEvents() {
            return new ArrayList<JzrEventInfo>(0);
        }

        @Override
        public List<JzrEventInfo> consumeEvents() {
            return new ArrayList<JzrEventInfo>(0);
        }

        @Override
        public JzrMonitorHandler getMonitorHandler(String source, String service) {
            return new JzrMonitorHandlerNoImpl();
        }

        @Override
        public List<JzrPublisherEvent> consumePublisherEvents() {
            if (this.getEventsFirstCall) {
                this.getEventsFirstCall = false;
                ArrayList<JzrPublisherEvent> publisherEvents = new ArrayList<JzrPublisherEvent>(1);
                JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_001);
                publisherEvents.add(publisherEvent);
                return publisherEvents;
            }
            return new ArrayList<JzrPublisherEvent>(0);
        }

        @Override
        public List<JzrPublisherEvent> getPublisherEvents() {
            if (this.getEventsFirstCall) {
                ArrayList<JzrPublisherEvent> publisherEvents = new ArrayList<JzrPublisherEvent>(1);
                JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_001);
                publisherEvents.add(publisherEvent);
                return publisherEvents;
            }
            return new ArrayList<JzrPublisherEvent>(0);
        }

        @Override
        public void suspendDataCollection() {
        }

        @Override
        public void resumeDataCollection() {
        }

        @Override
        public void suspendEventCollection(JzrEventLevel level) {
        }

        @Override
        public void resumeEventCollection(JzrEventLevel level) {
        }

        @Override
        public boolean isDataCollectionActive() {
            return false;
        }

        @Override
        public boolean isEventCollectionActive(JzrEventLevel level) {
            return false;
        }

        private static final class JzrMonitorHandlerNoImpl
        implements JzrMonitorHandler {
            private JzrMonitorHandlerNoImpl() {
            }

            @Override
            public boolean fireSystemEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean fireGlobalEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean fireLocalThreadEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean startGlobalEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean startLocalThreadEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean terminateEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean cancelEvent(JzrEvent event) {
                return true;
            }

            @Override
            public boolean isWaitingForPublication(JzrEvent event) {
                return false;
            }

            @Override
            public boolean isTerminated(JzrEvent event) {
                return true;
            }
        }

        private static final class JzrActionHandlerNoImpl
        implements JzrActionHandler {
            private JzrActionHandlerNoImpl() {
            }

            @Override
            public void startAction(JzrActionContext context) {
            }

            @Override
            public void closeAction() {
            }

            @Override
            public void setContextParameter(String param, String value) {
            }
        }
    }

    private static final class JeyzerPublisherImpl
    extends JeyzerPublisher {
        private volatile boolean initialized = false;
        private volatile boolean dataCollectionActive = true;
        private boolean generateJzrRecorderCollectionEvent = false;
        private boolean disableReaper = false;
        private String profile;
        private String nodeName;
        private String processName;
        private String processVersion;
        private String buildNumber;
        private Map<String, JzrThreadInfo> threadInfoMap = new HashMap<String, JzrThreadInfo>();
        private Object threadInfoMapLock = new Object();
        private Map<String, String> staticProcessCtxParams = new ConcurrentHashMap<String, String>();
        private Map<String, String> dynamicProcessCtxParams = new ConcurrentHashMap<String, String>();
        private JzrEventManager eventMgr = new JzrEventManager();
        private ScheduledExecutorService executor;

        protected JeyzerPublisherImpl() {
            this.register();
            this.startRepear();
            try {
                this.nodeName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.nodeName = null;
            }
            JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_002);
            this.eventMgr.addPublisherEvent(publisherEvent);
        }

        @Override
        public boolean init(Properties props) {
            boolean disableDataCollection;
            if (this.initialized) {
                return false;
            }
            this.initialized = true;
            this.disableReaper = Boolean.parseBoolean(props.getProperty("publisher.disable.action.context.reaper", Boolean.FALSE.toString()));
            if (this.disableReaper) {
                this.stopReaper();
            }
            if (disableDataCollection = Boolean.parseBoolean(props.getProperty("data.disable.collection", Boolean.FALSE.toString()))) {
                this.dataCollectionActive = false;
                JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_502);
                this.eventMgr.addPublisherEvent(publisherEvent);
            }
            this.generateJzrRecorderCollectionEvent = Boolean.parseBoolean(props.getProperty("publisher.enable.jzr_recorder_collection.event", Boolean.FALSE.toString()));
            this.eventMgr.init(props);
            return true;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isDataCollectionActive() {
            return this.dataCollectionActive;
        }

        @Override
        public boolean isEventCollectionActive(JzrEventLevel level) {
            return this.eventMgr.isEventCollectionActive(level);
        }

        @Override
        public void suspendDataCollection() {
            if (!this.dataCollectionActive) {
                return;
            }
            this.dataCollectionActive = false;
            JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_503);
            this.eventMgr.addPublisherEvent(publisherEvent);
        }

        @Override
        public void resumeDataCollection() {
            if (this.dataCollectionActive) {
                return;
            }
            this.dataCollectionActive = true;
            JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_504);
            this.eventMgr.addPublisherEvent(publisherEvent);
        }

        @Override
        public void suspendEventCollection(JzrEventLevel level) {
            this.eventMgr.suspendEventCollection(level);
        }

        @Override
        public void resumeEventCollection(JzrEventLevel level) {
            this.eventMgr.resumeEventCollection(level);
        }

        @Override
        public JzrActionHandler getActionHandler() {
            return new JzrActionHandlerImpl();
        }

        @Override
        public String getProfileName() {
            return this.profile;
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }

        @Override
        public String getProcessName() {
            return this.processName;
        }

        @Override
        public String getProcessVersion() {
            return this.processVersion;
        }

        @Override
        public String getProcessBuildNumber() {
            return this.buildNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<JzrThreadInfo> getThreadInfoList() {
            ArrayList<JzrThreadInfo> threadInfoList = new ArrayList<JzrThreadInfo>();
            if (this.disableReaper) {
                this.reapFinishedThreads();
            }
            Object object = this.threadInfoMapLock;
            synchronized (object) {
                threadInfoList.addAll(this.threadInfoMap.values());
            }
            return threadInfoList;
        }

        @Override
        public Map<String, String> getStaticProcessContextParams() {
            return new HashMap<String, String>(this.staticProcessCtxParams);
        }

        @Override
        public Map<String, String> getDynamicProcessContextParams() {
            return new HashMap<String, String>(this.dynamicProcessCtxParams);
        }

        @Override
        public void setProfileName(String profile) {
            this.profile = profile;
        }

        @Override
        public void setNodeName(String nodeName) {
            if (nodeName == null) {
                return;
            }
            this.nodeName = nodeName;
        }

        @Override
        public void setProcessName(String name) {
            this.processName = name;
        }

        @Override
        public void setProcessVersion(String version) {
            this.processVersion = version;
        }

        @Override
        public void setProcessBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
        }

        @Override
        public void addStaticProcessContextParam(String key, String value) {
            if (key == null || value == null) {
                return;
            }
            if (!this.isDataCollectionActive()) {
                return;
            }
            this.staticProcessCtxParams.put(key, value);
        }

        @Override
        public void setDynamicProcessContextParam(String key, String value) {
            if (key == null || value == null) {
                return;
            }
            if (!this.isDataCollectionActive()) {
                return;
            }
            this.dynamicProcessCtxParams.put(key, value);
        }

        @Override
        public void removeDynamicProcessContextParam(String key) {
            if (key == null) {
                return;
            }
            this.dynamicProcessCtxParams.remove(key);
        }

        @Override
        public List<JzrEventInfo> getEvents() {
            return this.eventMgr.getEvents();
        }

        @Override
        public List<JzrEventInfo> consumeEvents() {
            if (this.generateJzrRecorderCollectionEvent) {
                JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(JzrPublisherEventCode.JZR_PUB_003);
                this.eventMgr.addPublisherEvent(publisherEvent);
            }
            if (this.eventMgr.isEmpty()) {
                return new ArrayList<JzrEventInfo>();
            }
            this.eventMgr.terminateLocalOrphanEvents();
            return this.eventMgr.fetchEventsToPublish();
        }

        @Override
        public JzrMonitorHandler getMonitorHandler(String source, String service) {
            return new JzrMonitorHandlerImpl(source, service, this.eventMgr, this.processName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addActionContext(JzrThreadInfo threadInfo) {
            if (threadInfo == null) {
                return;
            }
            Object object = this.threadInfoMapLock;
            synchronized (object) {
                this.threadInfoMap.put(Long.toString(threadInfo.getThreadId()), threadInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeActionContext(JzrThreadInfo threadInfo) {
            if (threadInfo == null) {
                return;
            }
            Object object = this.threadInfoMapLock;
            synchronized (object) {
                this.threadInfoMap.remove(Long.toString(threadInfo.getThreadId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reapActionContext(JzrThreadInfo threadInfoToRemove) {
            if (threadInfoToRemove == null) {
                return;
            }
            Object object = this.threadInfoMapLock;
            synchronized (object) {
                JzrThreadInfo threadInfoStored = this.threadInfoMap.get(threadInfoToRemove.getId());
                if (threadInfoStored.getStartTime() != threadInfoToRemove.getStartTime()) {
                    return;
                }
                this.threadInfoMap.remove(threadInfoToRemove.getId());
            }
        }

        private void startRepear() {
            DeadThreadInfoReaperTask reaper = new DeadThreadInfoReaperTask();
            this.executor = Executors.newSingleThreadScheduledExecutor(new DeadThreadInfoReaperThreadFactory());
            this.executor.scheduleWithFixedDelay(reaper, 60L, 60L, TimeUnit.SECONDS);
        }

        private void stopReaper() {
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }

        void reapFinishedThreads() {
            List<JzrThreadInfo> candidateList = this.getThreadInfoList();
            if (candidateList.isEmpty()) {
                return;
            }
            ArrayList<JzrThreadInfo> deadList = new ArrayList<JzrThreadInfo>();
            ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
            long[] threadIds = tmbean.getAllThreadIds();
            for (JzrThreadInfo candidate : candidateList) {
                if (!this.isDeadThread(threadIds, candidate.getThreadId())) continue;
                deadList.add(candidate);
            }
            for (JzrThreadInfo dead : deadList) {
                this.reapActionContext(dead);
            }
        }

        private boolean isDeadThread(long[] threadIds, long id) {
            for (int i = 0; i < threadIds.length; ++i) {
                if (id != threadIds[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<JzrPublisherEvent> getPublisherEvents() {
            return this.eventMgr.getPublisherEvents();
        }

        @Override
        public List<JzrPublisherEvent> consumePublisherEvents() {
            return this.eventMgr.fetchPublisherEvents();
        }

        private static final class JzrEventInfoImpl
        implements JzrEventInfo {
            private String source;
            private String service;
            private JzrEvent event;
            private long startTime;
            private long endTime = -1L;
            private JzrEventScope scope;
            private long threadId = -1L;
            private boolean oneshot;

            public JzrEventInfoImpl(String source, String service, JzrEvent evt, JzrEventScope scope, boolean oneshot) {
                this.source = source;
                this.service = service;
                this.event = (JzrEvent)evt.clone();
                this.startTime = System.currentTimeMillis();
                this.scope = scope;
                this.oneshot = oneshot;
                if (oneshot) {
                    this.endTime = this.startTime;
                }
            }

            public JzrEventInfoImpl(String source, String service, JzrEvent evt, JzrEventScope scope, boolean oneshot, long threadId) {
                this(source, service, evt, scope, oneshot);
                this.threadId = threadId;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public String getService() {
                return this.service;
            }

            @Override
            public JzrEventCode getCode() {
                return this.event.getCode();
            }

            @Override
            public String getId() {
                return this.event.getId();
            }

            @Override
            public JzrEventScope getScope() {
                return this.scope;
            }

            @Override
            public String getMessage() {
                return this.event.getMessage();
            }

            @Override
            public short getTrustFactor() {
                return this.event.getTrustFactor();
            }

            @Override
            public long getStartTime() {
                return this.startTime;
            }

            @Override
            public long getEndTime() {
                return this.endTime;
            }

            @Override
            public long getThreadId() {
                return this.threadId;
            }

            @Override
            public boolean isOneshot() {
                return this.oneshot;
            }

            public boolean isTerminated() {
                return this.endTime != -1L;
            }

            public void terminate() {
                if (!this.oneshot) {
                    this.endTime = System.currentTimeMillis();
                }
            }

            public boolean equalsOrigin(JzrEventInfoImpl other) {
                if (other == null) {
                    return false;
                }
                if (this.service == null ? other.getService() != null : !this.service.equals(other.getService())) {
                    return false;
                }
                if (!this.source.equals(other.getSource())) {
                    return false;
                }
                if (this.event.getCode() == null ? other.getCode() != null : !this.event.getCode().equals(other.getCode())) {
                    return false;
                }
                return !(this.event.getMessage() == null ? other.getMessage() != null : !this.event.getMessage().equals(other.getMessage()));
            }

            public boolean isTimeContemporary(JzrEventInfoImpl other) {
                if (other == null) {
                    return false;
                }
                long diffTime = other.startTime > this.startTime ? other.startTime - this.startTime : this.startTime - other.startTime;
                return diffTime < 5000L;
            }
        }

        private static final class JzrThreadInfoImpl
        implements JzrThreadInfo {
            private static final AtomicInteger idCount = new AtomicInteger(0);
            private long threadId;
            private String jhId = Integer.toString(idCount.incrementAndGet());
            private JzrActionContext context;
            private long startTime;

            public JzrThreadInfoImpl(long threadId, JzrActionContext context, long startTime) {
                this.threadId = threadId;
                this.context = new JzrActionContext(context);
                this.startTime = startTime;
            }

            @Override
            public String getActionId() {
                return this.jhId;
            }

            @Override
            public String getId() {
                return this.context.getId();
            }

            @Override
            public String getUser() {
                return this.context.getUser();
            }

            @Override
            public String getFunctionPrincipal() {
                return this.context.getFunctionPrincipal();
            }

            @Override
            public Map<String, String> getContextParams() {
                return this.context.getContextParams();
            }

            @Override
            public long getStartTime() {
                return this.startTime;
            }

            @Override
            public long getThreadId() {
                return this.threadId;
            }

            public void setContextParameter(String param, String value) {
                this.context.setContextParam(param, value);
            }
        }

        private static final class JzrMonitorHandlerImpl
        implements JzrMonitorHandler {
            private JzrEventManager eventMgr;
            private String source;
            private String service;

            public JzrMonitorHandlerImpl(String source, String service, JzrEventManager eventMgr, String defaultSource) {
                this.source = source != null ? source : (defaultSource != null ? defaultSource : "NA");
                this.service = service;
                this.eventMgr = eventMgr;
            }

            @Override
            public boolean fireSystemEvent(JzrEvent event) {
                if (!this.isValidEvent(event)) {
                    return false;
                }
                JzrEventInfoImpl evtInfo = new JzrEventInfoImpl(this.source, this.service, event, JzrEventScope.SYSTEM, true);
                return this.eventMgr.add(evtInfo);
            }

            @Override
            public boolean fireGlobalEvent(JzrEvent event) {
                if (!this.isValidEvent(event)) {
                    return false;
                }
                JzrEventInfoImpl evtInfo = new JzrEventInfoImpl(this.source, this.service, event, JzrEventScope.GLOBAL, true);
                return this.eventMgr.add(evtInfo);
            }

            @Override
            public boolean fireLocalThreadEvent(JzrEvent event) {
                if (!this.isValidEvent(event)) {
                    return false;
                }
                JzrEventInfoImpl evtInfo = new JzrEventInfoImpl(this.source, this.service, event, JzrEventScope.ACTION, true, Thread.currentThread().getId());
                return this.eventMgr.add(evtInfo);
            }

            @Override
            public boolean startGlobalEvent(JzrEvent event) {
                if (!this.isValidEvent(event)) {
                    return false;
                }
                JzrEventInfoImpl evtInfo = new JzrEventInfoImpl(this.source, this.service, event, JzrEventScope.GLOBAL, false);
                return this.eventMgr.add(evtInfo);
            }

            @Override
            public boolean startLocalThreadEvent(JzrEvent event) {
                if (!this.isValidEvent(event)) {
                    return false;
                }
                JzrEventInfoImpl evtInfo = new JzrEventInfoImpl(this.source, this.service, event, JzrEventScope.ACTION, false, Thread.currentThread().getId());
                return this.eventMgr.add(evtInfo);
            }

            @Override
            public boolean terminateEvent(JzrEvent event) {
                return this.eventMgr.terminateEvent(event);
            }

            @Override
            public boolean cancelEvent(JzrEvent event) {
                return this.eventMgr.cancelEvent(event);
            }

            @Override
            public boolean isWaitingForPublication(JzrEvent event) {
                return this.eventMgr.isWaitingForPublication(event);
            }

            @Override
            public boolean isTerminated(JzrEvent event) {
                return this.eventMgr.isTerminated(event);
            }

            private boolean isValidEvent(JzrEvent event) {
                if (event == null) {
                    return false;
                }
                if (event.getId() == null || event.getId().isEmpty()) {
                    return false;
                }
                if (event.getCode() == null) {
                    return false;
                }
                return event.getCode().getLevel() != null && event.getCode().getSubLevel() != null;
            }
        }

        private static final class JzrActionHandlerImpl
        implements JzrActionHandler {
            private JzrThreadInfoImpl threadInfo;

            private JzrActionHandlerImpl() {
            }

            @Override
            public synchronized void startAction(JzrActionContext context) {
                if (context == null) {
                    return;
                }
                JeyzerPublisherImpl pub = (JeyzerPublisherImpl)publisher;
                if (!pub.isDataCollectionActive()) {
                    return;
                }
                if (this.threadInfo != null) {
                    pub.removeActionContext(this.threadInfo);
                }
                this.threadInfo = new JzrThreadInfoImpl(Thread.currentThread().getId(), context, new Date().getTime());
                pub.addActionContext(this.threadInfo);
            }

            @Override
            public synchronized void closeAction() {
                if (this.threadInfo == null) {
                    return;
                }
                JeyzerPublisherImpl mgr = (JeyzerPublisherImpl)publisher;
                mgr.removeActionContext(this.threadInfo);
            }

            @Override
            public synchronized void setContextParameter(String param, String value) {
                if (this.threadInfo == null || !publisher.isDataCollectionActive()) {
                    return;
                }
                this.threadInfo.setContextParameter(param, value);
            }
        }

        private static final class JzrEventManager {
            private static final int DEFAULT_EVENTS_LIMIT_PER_LEVEL = 1000;
            private JzrEventInfoImplGroup infoEventGroup = new JzrEventInfoImplGroup(JzrEventLevel.INFO);
            private JzrEventInfoImplGroup warnEventGroup = new JzrEventInfoImplGroup(JzrEventLevel.WARNING);
            private JzrEventInfoImplGroup criticalEventGroup = new JzrEventInfoImplGroup(JzrEventLevel.CRITICAL);
            private List<JzrPublisherEvent> publisherEvents = Collections.synchronizedList(new ArrayList());

            private JzrEventManager() {
            }

            public void init(Properties props) {
                this.initEventLimit(this.criticalEventGroup, "events.critical.limit", props);
                this.initEventLimit(this.warnEventGroup, "events.warning.limit", props);
                this.initEventLimit(this.infoEventGroup, "events.info.limit", props);
                this.initEventCollection(this.criticalEventGroup, "events.critical.disable.collection", props, JzrPublisherEventCode.JZR_PUB_102);
                this.initEventCollection(this.warnEventGroup, "events.warning.disable.collection", props, JzrPublisherEventCode.JZR_PUB_202);
                this.initEventCollection(this.infoEventGroup, "events.info.disable.collection", props, JzrPublisherEventCode.JZR_PUB_302);
            }

            private void initEventCollection(JzrEventInfoImplGroup eventGroup, String propertyName, Properties props, JzrPublisherEventCode code) {
                boolean disableDataCollection = Boolean.parseBoolean(props.getProperty(propertyName, Boolean.FALSE.toString()));
                if (disableDataCollection) {
                    eventGroup.suspendEventCollection();
                    JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(code);
                    this.publisherEvents.add(publisherEvent);
                }
            }

            public boolean isEventCollectionActive(JzrEventLevel level) {
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(level);
                return eventGroup.isEventCollectionActive();
            }

            public void suspendEventCollection(JzrEventLevel level) {
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(level);
                if (!eventGroup.isEventCollectionActive()) {
                    return;
                }
                eventGroup.suspendEventCollection();
                JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(this.getSuspendedCodeAtRuntime(level));
                this.publisherEvents.add(publisherEvent);
            }

            public void resumeEventCollection(JzrEventLevel level) {
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(level);
                if (eventGroup.isEventCollectionActive()) {
                    return;
                }
                eventGroup.resumeEventCollection();
                JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(this.getResumedCodeAtRuntime(level));
                this.publisherEvents.add(publisherEvent);
            }

            private void initEventLimit(JzrEventInfoImplGroup group, String eventsLimitProperty, Properties props) {
                String value = props.getProperty(eventsLimitProperty);
                if (value == null) {
                    return;
                }
                try {
                    int limit = Integer.parseInt(value);
                    group.setEventsLimit(limit);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            public boolean add(JzrEventInfoImpl evtInfo) {
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(evtInfo.getCode().getLevel());
                return eventGroup.addEvent(evtInfo, this.publisherEvents);
            }

            public void addPublisherEvent(JzrPublisherEvent publisherEvent) {
                this.publisherEvents.add(publisherEvent);
            }

            public List<JzrEventInfo> fetchEventsToPublish() {
                ArrayList<JzrEventInfo> eventToPublish = new ArrayList<JzrEventInfo>();
                this.criticalEventGroup.fetchEventsToPublish(eventToPublish);
                this.warnEventGroup.fetchEventsToPublish(eventToPublish);
                this.infoEventGroup.fetchEventsToPublish(eventToPublish);
                return eventToPublish;
            }

            public List<JzrEventInfo> getEvents() {
                ArrayList<JzrEventInfo> events = new ArrayList<JzrEventInfo>();
                events.addAll(this.criticalEventGroup.getEvents());
                events.addAll(this.warnEventGroup.getEvents());
                events.addAll(this.infoEventGroup.getEvents());
                return events;
            }

            public List<JzrPublisherEvent> fetchPublisherEvents() {
                ArrayList<JzrPublisherEvent> eventsToPublish = new ArrayList<JzrPublisherEvent>();
                eventsToPublish.addAll(this.publisherEvents);
                this.publisherEvents.removeAll(eventsToPublish);
                return eventsToPublish;
            }

            public List<JzrPublisherEvent> getPublisherEvents() {
                ArrayList<JzrPublisherEvent> events = new ArrayList<JzrPublisherEvent>();
                events.addAll(this.publisherEvents);
                return events;
            }

            public boolean isEmpty() {
                return this.criticalEventGroup.isEmpty() && this.warnEventGroup.isEmpty() && this.infoEventGroup.isEmpty();
            }

            public void terminateLocalOrphanEvents() {
                ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
                long[] threadIds = tmbean.getAllThreadIds();
                this.criticalEventGroup.terminateLocalOrphanEvents(threadIds);
                this.warnEventGroup.terminateLocalOrphanEvents(threadIds);
                this.infoEventGroup.terminateLocalOrphanEvents(threadIds);
            }

            public boolean terminateEvent(JzrEvent event) {
                if (event == null || event.getId() == null || event.getId().isEmpty()) {
                    return false;
                }
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(event.getCode().getLevel());
                return eventGroup.terminateEvent(event);
            }

            public boolean cancelEvent(JzrEvent event) {
                if (event == null || event.getId() == null || event.getId().isEmpty()) {
                    return false;
                }
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(event.getCode().getLevel());
                return eventGroup.cancelEvent(event);
            }

            public boolean isWaitingForPublication(JzrEvent event) {
                if (event == null || event.getId() == null || event.getId().isEmpty()) {
                    return false;
                }
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(event.getCode().getLevel());
                return eventGroup.isWaitingForPublication(event);
            }

            public boolean isTerminated(JzrEvent event) {
                if (event == null || event.getId() == null || event.getId().isEmpty()) {
                    return false;
                }
                JzrEventInfoImplGroup eventGroup = this.getLevelBasedEventInfoImplGroup(event.getCode().getLevel());
                return eventGroup.isTerminated(event);
            }

            private JzrEventInfoImplGroup getLevelBasedEventInfoImplGroup(JzrEventLevel level) {
                switch (level) {
                    case CRITICAL: {
                        return this.criticalEventGroup;
                    }
                    case WARNING: {
                        return this.warnEventGroup;
                    }
                }
                return this.infoEventGroup;
            }

            private JzrPublisherEventCode getSuspendedCodeAtRuntime(JzrEventLevel level) {
                switch (level) {
                    case CRITICAL: {
                        return JzrPublisherEventCode.JZR_PUB_103;
                    }
                    case WARNING: {
                        return JzrPublisherEventCode.JZR_PUB_203;
                    }
                }
                return JzrPublisherEventCode.JZR_PUB_303;
            }

            private JzrPublisherEventCode getResumedCodeAtRuntime(JzrEventLevel level) {
                switch (level) {
                    case CRITICAL: {
                        return JzrPublisherEventCode.JZR_PUB_104;
                    }
                    case WARNING: {
                        return JzrPublisherEventCode.JZR_PUB_204;
                    }
                }
                return JzrPublisherEventCode.JZR_PUB_304;
            }

            private static final class JzrEventInfoImplGroup {
                private JzrEventLevel level;
                private ConcurrentLinkedQueue<JzrEventInfoImpl> events = new ConcurrentLinkedQueue();
                private JzrEventInfoImpl previousEvent;
                private volatile int eventsLimit = 1000;
                private volatile boolean limitReached;
                private volatile boolean eventCollectionActive = true;

                public JzrEventInfoImplGroup(JzrEventLevel level) {
                    this.level = level;
                }

                public void resumeEventCollection() {
                    this.eventCollectionActive = true;
                }

                public void suspendEventCollection() {
                    this.eventCollectionActive = false;
                }

                public boolean isEventCollectionActive() {
                    return this.eventCollectionActive;
                }

                public void fetchEventsToPublish(List<JzrEventInfo> eventToPublish) {
                    Object[] candidates;
                    ArrayList<JzrEventInfoImpl> terminatedEvents = new ArrayList<JzrEventInfoImpl>();
                    for (Object obj : candidates = this.events.toArray()) {
                        JzrEventInfoImpl candidate = (JzrEventInfoImpl)obj;
                        eventToPublish.add(candidate);
                        if (!candidate.isOneshot() && !candidate.isTerminated()) continue;
                        terminatedEvents.add(candidate);
                    }
                    this.events.removeAll(terminatedEvents);
                    if (this.events.size() <= this.eventsLimit) {
                        this.limitReached = false;
                    }
                }

                public List<JzrEventInfo> getEvents() {
                    ArrayList<JzrEventInfo> returnedEvents = new ArrayList<JzrEventInfo>();
                    returnedEvents.addAll(Arrays.asList(this.events.toArray(new JzrEventInfoImpl[0])));
                    return returnedEvents;
                }

                public boolean isEmpty() {
                    return this.events.isEmpty();
                }

                public boolean addEvent(JzrEventInfoImpl evtInfo, List<JzrPublisherEvent> publisherEvents) {
                    if (!this.eventCollectionActive) {
                        return false;
                    }
                    if (this.isLoopedEvent(evtInfo)) {
                        return false;
                    }
                    this.events.offer(evtInfo);
                    if (this.events.size() > this.eventsLimit) {
                        JzrEventInfoImpl eventLost = this.events.poll();
                        if (!this.limitReached) {
                            this.limitReached = true;
                            SimpleDateFormat format = new SimpleDateFormat("yyyy MM dd HH mm ss SSS z");
                            JeyzerPublisherEventImpl publisherEvent = new JeyzerPublisherEventImpl(this.getLimitCodeLevel(), this.getLimitCodeLevel().getDescription(format.format(new Date(eventLost.getStartTime()))));
                            publisherEvents.add(publisherEvent);
                        }
                    }
                    return true;
                }

                public void setEventsLimit(int eventsLimit) {
                    if (eventsLimit > this.eventsLimit) {
                        this.eventsLimit = eventsLimit;
                    }
                }

                public void terminateLocalOrphanEvents(long[] threadIds) {
                    for (JzrEventInfoImpl event : this.events) {
                        if (!JzrEventScope.ACTION.equals((Object)event.getScope()) || event.getEndTime() != -1L || !this.isDeadThread(threadIds, event.getThreadId())) continue;
                        event.terminate();
                    }
                }

                public boolean terminateEvent(JzrEvent event) {
                    for (JzrEventInfoImpl candidate : this.events) {
                        if (!candidate.getId().equals(event.getId())) continue;
                        candidate.terminate();
                        return true;
                    }
                    return false;
                }

                public boolean cancelEvent(JzrEvent event) {
                    for (JzrEventInfoImpl candidate : this.events) {
                        if (!candidate.getId().equals(event.getId())) continue;
                        this.events.remove(candidate);
                        return true;
                    }
                    return false;
                }

                public boolean isWaitingForPublication(JzrEvent event) {
                    for (JzrEventInfoImpl candidate : this.events) {
                        if (!candidate.getId().equals(event.getId())) continue;
                        return true;
                    }
                    return false;
                }

                public boolean isTerminated(JzrEvent event) {
                    for (JzrEventInfoImpl candidate : this.events) {
                        if (!candidate.getId().equals(event.getId())) continue;
                        return candidate.isTerminated();
                    }
                    return false;
                }

                private boolean isDeadThread(long[] threadIds, long id) {
                    for (int i = 0; i < threadIds.length; ++i) {
                        if (id != threadIds[i]) continue;
                        return false;
                    }
                    return true;
                }

                private boolean isLoopedEvent(JzrEventInfoImpl evtInfo) {
                    if (this.previousEvent != null && this.previousEvent.equalsOrigin(evtInfo) && this.previousEvent.isTimeContemporary(evtInfo)) {
                        return true;
                    }
                    this.previousEvent = evtInfo;
                    return false;
                }

                private JzrPublisherEventCode getLimitCodeLevel() {
                    switch (this.level) {
                        case CRITICAL: {
                            return JzrPublisherEventCode.JZR_PUB_101;
                        }
                        case WARNING: {
                            return JzrPublisherEventCode.JZR_PUB_201;
                        }
                    }
                    return JzrPublisherEventCode.JZR_PUB_301;
                }
            }
        }

        private static final class DeadThreadInfoReaperThreadFactory
        implements ThreadFactory {
            private DeadThreadInfoReaperThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Jeyzer-thread-info-reaper");
                t.setDaemon(true);
                return t;
            }
        }

        private static final class DeadThreadInfoReaperTask
        implements Runnable {
            private DeadThreadInfoReaperTask() {
            }

            @Override
            public void run() {
                try {
                    ((JeyzerPublisherImpl)publisher).reapFinishedThreads();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static final class JeyzerPublisherEventImpl
    implements JzrPublisherEvent {
        private long time;
        private JzrPublisherEventCode code;
        private String message;

        public JeyzerPublisherEventImpl(JzrPublisherEventCode code, String message) {
            this.code = code;
            this.message = message;
            this.time = System.currentTimeMillis();
        }

        public JeyzerPublisherEventImpl(JzrPublisherEventCode code) {
            this(code, code.getDescription());
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public JzrEventLevel getLevel() {
            return this.code.getLevel();
        }

        @Override
        public JzrEventSubLevel getSubLevel() {
            return this.code.getSubLevel();
        }

        @Override
        public JzrPublisherEventCode getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

