/*
 * Decompiled with CFR 0.152.
 */
package org.jeyzer.publish.event;

import java.util.concurrent.atomic.AtomicInteger;
import org.jeyzer.mx.event.JzrEventCode;
import org.jeyzer.publish.event.JzrEvent;

public class JzrStandardEvent
implements JzrEvent {
    private static AtomicInteger idSuffix = new AtomicInteger(0);
    protected JzrEventCode code;
    protected String id;
    protected String message;
    protected short trustFactor;

    public JzrStandardEvent(JzrEventCode code) {
        this.code = code;
        this.id = code.getAbbreviation() + System.currentTimeMillis() + JzrStandardEvent.getSuffixId();
        this.message = code.getName();
        this.trustFactor = (short)100;
    }

    public JzrStandardEvent(JzrEventCode code, String message) {
        this.code = code;
        this.id = code.getAbbreviation() + System.currentTimeMillis() + JzrStandardEvent.getSuffixId();
        this.message = message != null && !message.isEmpty() ? message : code.getName();
        this.message = message;
        this.trustFactor = (short)100;
    }

    public JzrStandardEvent(JzrEventCode code, String message, short trustFactor) {
        this.code = code;
        this.id = code.getAbbreviation() + System.currentTimeMillis() + JzrStandardEvent.getSuffixId();
        this.message = message != null && !message.isEmpty() ? message : code.getName();
        this.trustFactor = trustFactor;
    }

    public JzrStandardEvent(JzrStandardEvent event) {
        this.code = event.getCode();
        this.id = event.getId();
        this.message = event.getMessage();
        this.trustFactor = event.getTrustFactor();
    }

    @Override
    public JzrEventCode getCode() {
        return this.code;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public short getTrustFactor() {
        return this.trustFactor;
    }

    public void setTrustFactor(short trustFactor) {
        this.trustFactor = trustFactor;
    }

    @Override
    public Object clone() {
        return new JzrStandardEvent(this);
    }

    private static String getSuffixId() {
        idSuffix.compareAndSet(10000, 0);
        return "-" + idSuffix.incrementAndGet();
    }
}

