/*
 * Decompiled with CFR 0.152.
 */
package org.jfleet.record;

import java.lang.reflect.RecordComponent;
import org.jfleet.record.CaseConverter;
import org.jfleet.record.CaseType;
import org.jfleet.record.ColumnNamingStrategy;
import org.jfleet.record.annotation.Alias;

class FieldToColumnMapper {
    private final ColumnNamingStrategy columnNamingStrategy;
    private final CaseType caseType;

    FieldToColumnMapper(ColumnNamingStrategy columnNamingStrategy, CaseType caseType) {
        this.columnNamingStrategy = columnNamingStrategy;
        this.caseType = caseType;
    }

    public String getColumnName(RecordComponent recordComponent) {
        String value;
        Alias annotation = recordComponent.getAnnotation(Alias.class);
        if (annotation != null) {
            return annotation.value();
        }
        String name = recordComponent.getName();
        switch (this.columnNamingStrategy) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FIELD_NAME: {
                String string = name;
                break;
            }
            case SNAKE_CASE: {
                String string = value = CaseConverter.camelCaseToSnakeCase(name);
            }
        }
        if (this.caseType == null) {
            return value;
        }
        return switch (this.caseType) {
            default -> throw new IncompatibleClassChangeError();
            case CaseType.UPPERCASE -> value.toUpperCase();
            case CaseType.LOWERCASE -> value.toLowerCase();
        };
    }
}

