/*
 * Decompiled with CFR 0.152.
 */
package org.jfleet.record;

import java.lang.reflect.RecordComponent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jfleet.ColumnInfo;
import org.jfleet.EntityFieldType;
import org.jfleet.EntityInfo;
import org.jfleet.record.CaseType;
import org.jfleet.record.ColumnNamingStrategy;
import org.jfleet.record.FieldToColumnMapper;
import org.jfleet.record.JFleetRecordException;
import org.jfleet.record.NotNullField;
import org.jfleet.record.Reflection;
import org.jfleet.record.annotation.Ordinal;

public class EntityInfoRecordBuilder {
    private final Class<?> entityClass;
    private String tableName;
    private ColumnNamingStrategy columnNamingStrategy = ColumnNamingStrategy.FIELD_NAME;
    private CaseType caseType;

    public static EntityInfoRecordBuilder fromRecord(Class<?> entityClass) {
        return new EntityInfoRecordBuilder(entityClass);
    }

    public static EntityInfo entityInfoFromRecord(Class<?> entityClass) {
        return new EntityInfoRecordBuilder(entityClass).build();
    }

    public EntityInfoRecordBuilder(Class<?> entityClass) {
        this.entityClass = entityClass;
        if (!entityClass.isRecord()) {
            throw new JFleetRecordException(entityClass.getName() + " is not a record");
        }
    }

    public EntityInfoRecordBuilder name(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public EntityInfoRecordBuilder columnNamingStrategy(ColumnNamingStrategy columnNamingStrategy) {
        this.columnNamingStrategy = columnNamingStrategy;
        return this;
    }

    public EntityInfoRecordBuilder upperCase() {
        this.caseType(CaseType.UPPERCASE);
        return this;
    }

    public EntityInfoRecordBuilder lowerCase() {
        this.caseType(CaseType.LOWERCASE);
        return this;
    }

    public EntityInfoRecordBuilder caseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    public EntityInfo build() {
        return new Builder(this.entityClass, this.tableName, this.columnNamingStrategy, this.caseType).build();
    }

    private class Builder {
        private final Class<?> entityClass;
        private final String tableName;
        private final FieldToColumnMapper fieldToColumnMapper;

        private Builder(Class<?> entityClass, String tableName, ColumnNamingStrategy columnNamingStrategy, CaseType caseType) {
            this.entityClass = entityClass;
            this.tableName = tableName;
            this.fieldToColumnMapper = new FieldToColumnMapper(columnNamingStrategy, caseType);
        }

        public EntityInfo build() {
            List<ColumnInfo> columns = Stream.of(this.entityClass.getRecordComponents()).map(this::buildColunm).toList();
            String entityName = this.tableName == null ? this.entityClass.getSimpleName().toLowerCase() : this.tableName;
            return new EntityInfo(this.entityClass, entityName, columns);
        }

        private ColumnInfo buildColunm(RecordComponent c) {
            String name = this.fieldToColumnMapper.getColumnName(c);
            EntityFieldType componentFieldType = Builder.getComponentFieldType(c);
            Function<Object, Object> accessor = Reflection.recordAccessor(this.entityClass, c);
            return new ColumnInfo(name, componentFieldType, accessor);
        }

        private static EntityFieldType getComponentFieldType(RecordComponent rc) {
            Class<?> javaType = rc.getType();
            EntityFieldType.FieldTypeEnum fieldType = Builder.getFieldType(javaType);
            if (fieldType == null && javaType.isEnum()) {
                fieldType = Builder.getTypeEnum(rc);
            }
            if (fieldType == null) {
                throw new JFleetRecordException(rc.getName() + " of type " + javaType.getName() + " is not a supported JFleet Record type");
            }
            boolean notNull = javaType.isPrimitive() || NotNullField.isNotNull(rc);
            return new EntityFieldType(fieldType, notNull);
        }

        private static EntityFieldType.FieldTypeEnum getFieldType(Class<?> javaType) {
            EntityFieldType.FieldTypeEnum value = null;
            if (Long.class.equals(javaType) || Long.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.LONG;
            } else if (Boolean.class.equals(javaType) || Boolean.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.BOOLEAN;
            } else if (Byte.class.equals(javaType) || Byte.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.BYTE;
            } else if (Character.class.equals(javaType) || Character.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.CHAR;
            } else if (Double.class.equals(javaType) || Double.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.DOUBLE;
            } else if (Float.class.equals(javaType) || Float.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.FLOAT;
            } else if (Integer.class.equals(javaType) || Integer.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.INT;
            } else if (Short.class.equals(javaType) || Short.TYPE.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.SHORT;
            } else if (String.class.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.STRING;
            } else if (Timestamp.class.isAssignableFrom(javaType)) {
                value = EntityFieldType.FieldTypeEnum.TIMESTAMP;
            } else if (Time.class.isAssignableFrom(javaType)) {
                value = EntityFieldType.FieldTypeEnum.TIME;
            } else if (Date.class.isAssignableFrom(javaType)) {
                value = EntityFieldType.FieldTypeEnum.DATE;
            } else if (java.util.Date.class.isAssignableFrom(javaType)) {
                value = EntityFieldType.FieldTypeEnum.DATE;
            } else if (BigDecimal.class.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.BIGDECIMAL;
            } else if (BigInteger.class.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.BIGINTEGER;
            } else if (LocalDate.class.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.LOCALDATE;
            } else if (LocalTime.class.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.LOCALTIME;
            } else if (LocalDateTime.class.equals(javaType)) {
                value = EntityFieldType.FieldTypeEnum.LOCALDATETIME;
            }
            return value;
        }

        private static EntityFieldType.FieldTypeEnum getTypeEnum(RecordComponent recordComponent) {
            Ordinal annotation = recordComponent.getAnnotation(Ordinal.class);
            if (annotation != null) {
                return EntityFieldType.FieldTypeEnum.ENUMORDINAL;
            }
            return EntityFieldType.FieldTypeEnum.ENUMSTRING;
        }
    }
}

