/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.fx.interaction;

import java.awt.geom.Point2D;
import javafx.scene.input.MouseEvent;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.fx.ChartCanvas;
import org.jfree.chart.fx.interaction.AbstractMouseHandlerFX;
import org.jfree.chart.fx.interaction.ChartMouseEventFX;
import org.jfree.chart.fx.interaction.ChartMouseListenerFX;

public class DispatchHandlerFX
extends AbstractMouseHandlerFX {
    private Point2D mousePressedPoint;

    public DispatchHandlerFX(String id) {
        super(id, false, false, false, false);
    }

    @Override
    public void handleMousePressed(ChartCanvas canvas, MouseEvent e) {
        this.mousePressedPoint = new Point2D.Double(e.getX(), e.getY());
    }

    @Override
    public void handleMouseMoved(ChartCanvas canvas, MouseEvent e) {
        double x = e.getX();
        double y = e.getY();
        ChartEntity entity = canvas.getRenderingInfo().getEntityCollection().getEntity(x, y);
        ChartMouseEventFX event = new ChartMouseEventFX(canvas.getChart(), e, entity);
        for (ChartMouseListenerFX listener : canvas.getChartMouseListeners()) {
            listener.chartMouseMoved(event);
        }
    }

    @Override
    public void handleMouseClicked(ChartCanvas canvas, MouseEvent e) {
        if (this.mousePressedPoint == null) {
            return;
        }
        double x = e.getX();
        double y = e.getY();
        ChartEntity entity = canvas.getRenderingInfo().getEntityCollection().getEntity(x, y);
        ChartMouseEventFX event = new ChartMouseEventFX(canvas.getChart(), e, entity);
        for (ChartMouseListenerFX listener : canvas.getChartMouseListeners()) {
            listener.chartMouseClicked(event);
        }
    }
}

