/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.graphics2d.canvas;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CanvasUtils {
    private CanvasUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToHTML(File f, String title, String canvasID, int width, int height, String canvasScript) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f));
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<head>\n");
            writer.write("<title>" + title + "</title>\n");
            writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            writer.write("<script>\n");
            writer.write("window.onload = function() {\n");
            writer.write("var canvas = document.getElementById(\"" + canvasID + "\");\n");
            writer.write("var ctx = canvas.getContext(\"2d\");\n");
            writer.write("if (!ctx.setLineDash) {\n");
            writer.write("ctx.setLineDash = function() {};\n");
            writer.write("}\n");
            writer.write(canvasScript + "\n");
            writer.write("}\n");
            writer.write("</script>\n");
            writer.write("</head>\n");
            writer.write("<body>\n");
            writer.write("<canvas id=\"" + canvasID + "\" width=\"" + width + "\" height=\"" + height + "\"></canvas>");
            writer.write("</body>\n");
            writer.write("</html>\n");
            writer.flush();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CanvasUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

