/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.graphics2d.svg;

import java.awt.RenderingHints;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class SVGHints {
    public static final Key KEY_IMAGE_HANDLING = new Key(0);
    public static final Object VALUE_IMAGE_HANDLING_EMBED = "VALUE_IMAGE_HANDLING_EMBED";
    public static final Object VALUE_IMAGE_HANDLING_REFERENCE = "VALUE_IMAGE_HANDLING_REFERENCE";
    public static final Key KEY_TEXT_RENDERING = new Key(1);
    public static final String VALUE_TEXT_RENDERING_AUTO = "auto";
    public static final String VALUE_TEXT_RENDERING_SPEED = "optimizeSpeed";
    public static final String VALUE_TEXT_RENDERING_LEGIBILITY = "optimizeLegibility";
    public static final String VALUE_TEXT_RENDERING_PRECISION = "geometricPrecision";
    public static final String VALUE_TEXT_RENDERING_INHERIT = "inherit";
    public static final Key KEY_IMAGE_HREF = new Key(2);
    public static final Key KEY_ELEMENT_ID = new Key(3);
    public static final Key KEY_BEGIN_GROUP = new Key(4);
    public static final Key KEY_END_GROUP = new Key(5);
    public static final Key KEY_ELEMENT_TITLE = new Key(6);
    public static final Key KEY_DRAW_STRING_TYPE = new Key(7);
    public static final Object VALUE_DRAW_STRING_TYPE_STANDARD = "VALUE_DRAW_STRING_TYPE_STANDARD";
    public static final Object VALUE_DRAW_STRING_TYPE_VECTOR = "VALUE_DRAW_STRING_TYPE_VECTOR";
    private static final List<RenderingHints.Key> beginGroupKeys = new ArrayList<RenderingHints.Key>();
    private static final List<RenderingHints.Key> endGroupKeys = new ArrayList<RenderingHints.Key>();
    private static final List<RenderingHints.Key> elementTitleKeys = new ArrayList<RenderingHints.Key>();

    private SVGHints() {
    }

    public static List<RenderingHints.Key> getBeginGroupKeys() {
        return new ArrayList<RenderingHints.Key>(beginGroupKeys);
    }

    public static void addBeginGroupKey(RenderingHints.Key key) {
        beginGroupKeys.add(key);
    }

    public static void removeBeginGroupKey(RenderingHints.Key key) {
        beginGroupKeys.remove(key);
    }

    public static void clearBeginGroupKeys() {
        beginGroupKeys.clear();
    }

    public static boolean isBeginGroupKey(RenderingHints.Key key) {
        return KEY_BEGIN_GROUP.equals(key) || beginGroupKeys.contains(key);
    }

    public static List<RenderingHints.Key> getEndGroupKeys() {
        return new ArrayList<RenderingHints.Key>(endGroupKeys);
    }

    public static void addEndGroupKey(RenderingHints.Key key) {
        endGroupKeys.add(key);
    }

    public static void removeEndGroupKey(RenderingHints.Key key) {
        endGroupKeys.remove(key);
    }

    public static void clearEndGroupKeys() {
        endGroupKeys.clear();
    }

    public static boolean isEndGroupKey(RenderingHints.Key key) {
        return KEY_END_GROUP.equals(key) || endGroupKeys.contains(key);
    }

    public static List<RenderingHints.Key> getElementTitleKeys() {
        return new ArrayList<RenderingHints.Key>(elementTitleKeys);
    }

    public static void addElementTitleKey(RenderingHints.Key key) {
        elementTitleKeys.add(key);
    }

    public static void removeElementTitleKey(RenderingHints.Key key) {
        elementTitleKeys.remove(key);
    }

    public static void clearElementTitleKeys() {
        elementTitleKeys.clear();
    }

    public static boolean isElementTitleKey(RenderingHints.Key key) {
        return KEY_ELEMENT_TITLE.equals(key) || elementTitleKeys.contains(key);
    }

    private static boolean isOrsonChartsOnClasspath() {
        return SVGHints.getOrsonChartsBeginElementKey() != null;
    }

    private static boolean isJFreeChartOnClasspath() {
        return SVGHints.getJFreeChartBeginElementKey() != null;
    }

    private static RenderingHints.Key fetchKey(String className, String fieldName) {
        try {
            Class<?> hintsClass = Class.forName(className);
            Field f = hintsClass.getDeclaredField(fieldName);
            return (RenderingHints.Key)f.get(null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    private static RenderingHints.Key getOrsonChartsBeginElementKey() {
        return SVGHints.fetchKey("com.orsoncharts.Chart3DHints", "KEY_BEGIN_ELEMENT");
    }

    private static RenderingHints.Key getOrsonChartsEndElementKey() {
        return SVGHints.fetchKey("com.orsoncharts.Chart3DHints", "KEY_END_ELEMENT");
    }

    private static RenderingHints.Key getOrsonChartsElementTitleKey() {
        return SVGHints.fetchKey("com.orsoncharts.Chart3DHints", "KEY_ELEMENT_TITLE");
    }

    private static RenderingHints.Key getJFreeChartBeginElementKey() {
        return SVGHints.fetchKey("org.jfree.chart.ChartHints", "KEY_BEGIN_ELEMENT");
    }

    private static RenderingHints.Key getJFreeChartEndElementKey() {
        return SVGHints.fetchKey("org.jfree.chart.ChartHints", "KEY_END_ELEMENT");
    }

    static {
        if (SVGHints.isOrsonChartsOnClasspath()) {
            beginGroupKeys.add(SVGHints.getOrsonChartsBeginElementKey());
            endGroupKeys.add(SVGHints.getOrsonChartsEndElementKey());
            elementTitleKeys.add(SVGHints.getOrsonChartsElementTitleKey());
        }
        if (SVGHints.isJFreeChartOnClasspath()) {
            beginGroupKeys.add(SVGHints.getJFreeChartBeginElementKey());
            endGroupKeys.add(SVGHints.getJFreeChartEndElementKey());
        }
    }

    public static class Key
    extends RenderingHints.Key {
        public Key(int privateKey) {
            super(privateKey);
        }

        @Override
        public boolean isCompatibleValue(Object val) {
            switch (this.intKey()) {
                case 0: {
                    return VALUE_IMAGE_HANDLING_EMBED.equals(val) || VALUE_IMAGE_HANDLING_REFERENCE.equals(val);
                }
                case 1: {
                    return SVGHints.VALUE_TEXT_RENDERING_AUTO.equals(val) || SVGHints.VALUE_TEXT_RENDERING_INHERIT.equals(val) || SVGHints.VALUE_TEXT_RENDERING_LEGIBILITY.equals(val) || SVGHints.VALUE_TEXT_RENDERING_PRECISION.equals(val) || SVGHints.VALUE_TEXT_RENDERING_SPEED.equals(val);
                }
                case 2: {
                    return val == null || val instanceof String;
                }
                case 3: {
                    return val == null || val instanceof String;
                }
                case 4: {
                    return val == null || val instanceof String;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return val instanceof String;
                }
                case 7: {
                    return val == null || VALUE_DRAW_STRING_TYPE_STANDARD.equals(val) || VALUE_DRAW_STRING_TYPE_VECTOR.equals(val);
                }
            }
            throw new RuntimeException("Not possible!");
        }
    }
}

