/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.fx;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import org.jfree.chart3d.Chart3D;
import org.jfree.chart3d.export.ExportFormats;
import org.jfree.chart3d.export.ExportUtils;
import org.jfree.chart3d.fx.Chart3DCanvas;
import org.jfree.chart3d.fx.interaction.FXChart3DMouseEvent;
import org.jfree.chart3d.graphics3d.Drawable3D;
import org.jfree.chart3d.graphics3d.RenderedElement;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.graphics3d.ViewPoint3D;

public class Chart3DViewer
extends Region {
    private static final int DEFAULT_MIN_WIDTH = 50;
    private static final int DEFAULT_MIN_HEIGHT = 50;
    private final Chart3DCanvas canvas;
    private final ContextMenu contextMenu;
    private double zoomMultiplier = 0.95;

    public Chart3DViewer(Chart3D chart) {
        this(chart, true);
    }

    public Chart3DViewer(Chart3D chart, boolean contextMenuEnabled) {
        Objects.requireNonNull(chart, "chart");
        this.setMinSize(50.0, 50.0);
        this.setPrefSize(50.0, 50.0);
        this.canvas = new Chart3DCanvas(chart);
        this.canvas.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            RenderingInfo info = this.canvas.getRenderingInfo();
            RenderedElement element = info.findElementAt(event.getX(), event.getY());
            Chart3DViewer viewer = this;
            viewer.fireEvent(new FXChart3DMouseEvent((Object)viewer, (EventType<? extends Event>)FXChart3DMouseEvent.MOUSE_CLICKED, element, (MouseEvent)event));
        });
        this.canvas.setTooltipEnabled(true);
        this.setFocusTraversable(true);
        this.getChildren().add((Object)this.canvas);
        this.contextMenu = this.createContextMenu();
        this.setOnContextMenuRequested(event -> this.contextMenu.show(this.getScene().getWindow(), event.getScreenX(), event.getScreenY()));
        this.contextMenu.setOnShowing(event -> {
            Chart3DViewer viewer = this;
            viewer.canvas.setRotateViewEnabled(false);
            viewer.canvas.setTooltipEnabled(false);
        });
        this.contextMenu.setOnHiding(event -> {
            Chart3DViewer viewer = this;
            viewer.canvas.setRotateViewEnabled(true);
            viewer.canvas.setTooltipEnabled(true);
        });
    }

    public Chart3D getChart() {
        return this.canvas.getChart();
    }

    public void setChart(Chart3D chart) {
        Objects.requireNonNull(chart, "chart");
        this.canvas.setChart(chart);
    }

    public Chart3DCanvas getCanvas() {
        return this.canvas;
    }

    public double getZoomMultiplier() {
        return this.zoomMultiplier;
    }

    public void setZoomMultiplier(double multiplier) {
        this.zoomMultiplier = multiplier;
    }

    private ContextMenu createContextMenu() {
        ContextMenu menu = new ContextMenu();
        MenuItem zoomIn = new MenuItem("Zoom In");
        zoomIn.setOnAction(e -> this.handleZoom(this.zoomMultiplier));
        MenuItem zoomOut = new MenuItem("Zoom Out");
        zoomOut.setOnAction(e -> this.handleZoom(1.0 / this.zoomMultiplier));
        MenuItem zoomToFit = new MenuItem("Zoom To Fit");
        zoomToFit.setOnAction(e -> this.handleZoomToFit());
        SeparatorMenuItem separator = new SeparatorMenuItem();
        Menu export = new Menu("Export As");
        MenuItem pngItem = new MenuItem("PNG...");
        pngItem.setOnAction(e -> this.handleExportToPNG());
        export.getItems().add((Object)pngItem);
        MenuItem jpegItem = new MenuItem("JPEG...");
        jpegItem.setOnAction(e -> this.handleExportToJPEG());
        export.getItems().add((Object)jpegItem);
        if (ExportFormats.isJFreePDFAvailable()) {
            MenuItem pdfItem = new MenuItem("PDF...");
            pdfItem.setOnAction(e -> this.handleExportToPDF());
            export.getItems().add((Object)pdfItem);
        }
        if (ExportFormats.isJFreeSVGAvailable()) {
            MenuItem svgItem = new MenuItem("SVG...");
            svgItem.setOnAction(e -> this.handleExportToSVG());
            export.getItems().add((Object)svgItem);
        }
        menu.getItems().addAll((Object[])new MenuItem[]{zoomIn, zoomOut, zoomToFit, separator, export});
        return menu;
    }

    private void handleZoom(double multiplier) {
        ViewPoint3D viewPt = this.getChart().getViewPoint();
        double minDistance = this.canvas.getMinViewingDistance();
        double maxDistance = minDistance * this.canvas.getMaxViewingDistanceMultiplier();
        double valRho = Math.max(minDistance, Math.min(maxDistance, viewPt.getRho() * multiplier));
        viewPt.setRho(valRho);
        this.canvas.draw();
    }

    private void handleZoomToFit() {
        this.canvas.zoomToFit(this.canvas.getWidth(), this.canvas.getHeight());
    }

    private void handleExportToPDF() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Portable Document Format (PDF)", new String[]{"pdf"}));
        fileChooser.setTitle("Export to PDF");
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ExportUtils.writeAsPDF((Drawable3D)this.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
        }
    }

    private void handleExportToSVG() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export to SVG");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Scalable Vector Graphics (SVG)", new String[]{"svg"}));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ExportUtils.writeAsSVG((Drawable3D)this.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
        }
    }

    private void handleExportToPNG() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export to PNG");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Portable Network Graphics (PNG)", new String[]{"png"}));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                ExportUtils.writeAsPNG((Drawable3D)this.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleExportToJPEG() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export to JPEG");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("JPEG", new String[]{"jpg"}));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                ExportUtils.writeAsJPEG((Drawable3D)this.getChart(), (int)((int)this.getWidth()), (int)((int)this.getHeight()), (File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.canvas.setLayoutX(0.0);
        this.canvas.setLayoutY(0.0);
        this.canvas.setWidth(this.getWidth());
        this.canvas.setHeight(this.getHeight());
    }
}

