/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.skija;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jetbrains.skija.BlendMode;
import org.jetbrains.skija.Canvas;
import org.jetbrains.skija.ColorAlphaType;
import org.jetbrains.skija.ColorType;
import org.jetbrains.skija.FilterTileMode;
import org.jetbrains.skija.FontStyle;
import org.jetbrains.skija.GradientStyle;
import org.jetbrains.skija.Image;
import org.jetbrains.skija.ImageInfo;
import org.jetbrains.skija.Matrix33;
import org.jetbrains.skija.PaintMode;
import org.jetbrains.skija.PaintStrokeCap;
import org.jetbrains.skija.PaintStrokeJoin;
import org.jetbrains.skija.Path;
import org.jetbrains.skija.PathEffect;
import org.jetbrains.skija.PathFillMode;
import org.jetbrains.skija.Rect;
import org.jetbrains.skija.Shader;
import org.jetbrains.skija.Surface;
import org.jetbrains.skija.Typeface;
import org.jfree.skija.SkijaGraphicsConfiguration;
import org.jfree.skija.TypefaceKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkijaGraphics2D
extends Graphics2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkijaGraphics2D.class);
    private static final double MIN_LINE_WIDTH = 0.1;
    private final RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    private Surface surface;
    private int width;
    private int height;
    private Canvas canvas;
    private org.jetbrains.skija.Paint skijaPaint;
    private int restoreCount;
    private Paint awtPaint;
    private Color color = Color.BLACK;
    private Stroke stroke = new BasicStroke(1.0f);
    private Font awtFont = new Font("SansSerif", 0, 12);
    private Typeface typeface;
    private org.jetbrains.skija.Font skijaFont;
    private Color background = Color.BLACK;
    private AffineTransform transform = new AffineTransform();
    private Composite composite = AlphaComposite.getInstance(3, 1.0f);
    private Shape clip;
    private final Map<TypefaceKey, Typeface> typefaceMap = new HashMap<TypefaceKey, Typeface>();
    private BufferedImage fmImage;
    private Graphics2D fmImageG2D;
    private final FontRenderContext fontRenderContext = new FontRenderContext(null, false, true);
    private Line2D line;
    Rectangle2D rect;
    private RoundRectangle2D roundRect;
    private Ellipse2D oval;
    private Arc2D arc;
    private GraphicsConfiguration deviceConfiguration;
    private final double[] coords = new double[6];

    private static void nullNotPermitted(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException("Null '" + name + "' argument.");
        }
    }

    public SkijaGraphics2D(int width, int height) {
        LOGGER.debug("SkijaGraphics2D({}, {})", (Object)width, (Object)height);
        this.width = width;
        this.height = height;
        this.surface = Surface.makeRasterN32Premul((int)width, (int)height);
        this.init(this.surface.getCanvas());
    }

    public SkijaGraphics2D(Canvas canvas) {
        LOGGER.debug("SkijaGraphics2D(Canvas).");
        this.init(canvas);
    }

    private void init(Canvas canvas) {
        SkijaGraphics2D.nullNotPermitted(canvas, "canvas");
        this.canvas = canvas;
        this.skijaPaint = new org.jetbrains.skija.Paint().setColor(-16777216);
        this.typeface = Typeface.makeFromName((String)this.awtFont.getFontName(), (FontStyle)FontStyle.NORMAL);
        this.skijaFont = new org.jetbrains.skija.Font(this.typeface, 12.0f);
        this.restoreCount = this.canvas.save();
        LOGGER.debug("restoreCount updated to {}", (Object)this.restoreCount);
    }

    public Surface getSurface() {
        return this.surface;
    }

    private Path path(Shape shape) {
        Path p = new Path();
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(this.coords);
            switch (segType) {
                case 0: {
                    LOGGER.debug("SEG_MOVETO: " + this.coords[0] + ", " + this.coords[1]);
                    p.moveTo((float)this.coords[0], (float)this.coords[1]);
                    break;
                }
                case 1: {
                    LOGGER.debug("SEG_LINETO: " + this.coords[0] + ", " + this.coords[1]);
                    p.lineTo((float)this.coords[0], (float)this.coords[1]);
                    break;
                }
                case 2: {
                    LOGGER.debug("SEG_QUADTO: " + this.coords[0] + ", " + this.coords[1] + ", " + this.coords[2] + ", " + this.coords[3]);
                    p.quadTo((float)this.coords[0], (float)this.coords[1], (float)this.coords[2], (float)this.coords[3]);
                    break;
                }
                case 3: {
                    LOGGER.debug("SEG_CUBICTO: " + this.coords[0] + ", " + this.coords[1] + ", " + this.coords[2] + ", " + this.coords[3] + ", " + this.coords[4] + ", " + this.coords[5]);
                    p.cubicTo((float)this.coords[0], (float)this.coords[1], (float)this.coords[2], (float)this.coords[3], (float)this.coords[4], (float)this.coords[5]);
                    break;
                }
                case 4: {
                    LOGGER.debug("SEG_CLOSE: ");
                    p.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognised segment type " + segType);
                }
            }
            iterator.next();
        }
        return p;
    }

    @Override
    public void draw(Shape s) {
        LOGGER.debug("draw(Shape) : " + s);
        this.skijaPaint.setMode(PaintMode.STROKE);
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            this.canvas.drawLine((float)l.getX1(), (float)l.getY1(), (float)l.getX2(), (float)l.getY2(), this.skijaPaint);
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (r.getWidth() < 0.0 || r.getHeight() < 0.0) {
                return;
            }
            this.canvas.drawRect(Rect.makeXYWH((float)((float)r.getX()), (float)((float)r.getY()), (float)((float)r.getWidth()), (float)((float)r.getHeight())), this.skijaPaint);
        } else {
            this.canvas.drawPath(this.path(s), this.skijaPaint);
        }
    }

    @Override
    public boolean drawImage(java.awt.Image img, AffineTransform xform, ImageObserver obs) {
        LOGGER.debug("drawImage(Image, AffineTransform, ImageObserver)");
        AffineTransform savedTransform = this.getTransform();
        if (xform != null) {
            this.transform(xform);
        }
        boolean result = this.drawImage(img, 0, 0, obs);
        if (xform != null) {
            this.setTransform(savedTransform);
        }
        return result;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        LOGGER.debug("drawImage(BufferedImage, BufferedImageOp, {}, {})", (Object)x, (Object)y);
        BufferedImage imageToDraw = img;
        if (op != null) {
            imageToDraw = op.filter(img, null);
        }
        this.drawImage(imageToDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        LOGGER.debug("drawRenderedImage(RenderedImage, AffineTransform)");
        if (img == null) {
            return;
        }
        BufferedImage bi = SkijaGraphics2D.convertRenderedImage(img);
        this.drawImage(bi, xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        LOGGER.debug("drawRenderableImage(RenderableImage, AffineTransform xform)");
        RenderedImage ri = img.createDefaultRendering();
        this.drawRenderedImage(ri, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        LOGGER.debug("drawString({}, {}, {}", new Object[]{str, x, y});
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        LOGGER.debug("drawString({}, {}, {})", new Object[]{str, Float.valueOf(x), Float.valueOf(y)});
        this.skijaPaint.setMode(PaintMode.FILL);
        this.canvas.drawString(str, x, y, this.skijaFont, this.skijaPaint);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        LOGGER.debug("drawString(AttributedCharacterIterator, {}, {}", (Object)x, (Object)y);
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        LOGGER.debug("drawString(AttributedCharacterIterator, {}, {}", (Object)Float.valueOf(x), (Object)Float.valueOf(y));
        Set<AttributedCharacterIterator.Attribute> s = iterator.getAllAttributeKeys();
        if (!s.isEmpty()) {
            TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
            layout.draw(this, x, y);
        } else {
            StringBuilder strb = new StringBuilder();
            iterator.first();
            for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
                strb.append(iterator.current());
                iterator.next();
            }
            this.drawString(strb.toString(), x, y);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        LOGGER.debug("drawGlyphVector(GlyphVector, {}, {})", (Object)Float.valueOf(x), (Object)Float.valueOf(y));
        this.fill(g.getOutline(x, y));
    }

    @Override
    public void fill(Shape s) {
        LOGGER.debug("fill({})", (Object)s);
        this.skijaPaint.setMode(PaintMode.FILL);
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (r.getWidth() < 0.0 || r.getHeight() < 0.0) {
                return;
            }
            this.canvas.drawRect(Rect.makeXYWH((float)((float)r.getX()), (float)((float)r.getY()), (float)((float)r.getWidth()), (float)((float)r.getHeight())), this.skijaPaint);
        } else if (s instanceof Path2D) {
            Path2D p = (Path2D)s;
            Path path = this.path(s);
            if (p.getWindingRule() == 0) {
                path.setFillMode(PathFillMode.EVEN_ODD);
            } else {
                path.setFillMode(PathFillMode.WINDING);
            }
            this.canvas.drawPath(path, this.skijaPaint);
        } else {
            this.canvas.drawPath(this.path(s), this.skijaPaint);
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        LOGGER.debug("hit(Rectangle, Shape, boolean)");
        Shape ts = onStroke ? this.transform.createTransformedShape(this.stroke.createStrokedShape(s)) : this.transform.createTransformedShape(s);
        if (!rect.getBounds2D().intersects(ts.getBounds2D())) {
            return false;
        }
        Area a1 = new Area(rect);
        Area a2 = new Area(ts);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.deviceConfiguration == null) {
            int width = this.width;
            int height = this.height;
            this.deviceConfiguration = new SkijaGraphicsConfiguration(width, height);
        }
        return this.deviceConfiguration;
    }

    @Override
    public void setComposite(Composite comp) {
        LOGGER.debug("setComposite({})", (Object)comp);
        if (comp == null) {
            throw new IllegalArgumentException("Null 'comp' argument.");
        }
        this.composite = comp;
        if (comp instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)comp;
            this.skijaPaint.setAlphaf(ac.getAlpha());
            switch (ac.getRule()) {
                case 1: {
                    this.skijaPaint.setBlendMode(BlendMode.CLEAR);
                    break;
                }
                case 2: {
                    this.skijaPaint.setBlendMode(BlendMode.SRC);
                    break;
                }
                case 3: {
                    this.skijaPaint.setBlendMode(BlendMode.SRC_OVER);
                    break;
                }
                case 4: {
                    this.skijaPaint.setBlendMode(BlendMode.DST_OVER);
                    break;
                }
                case 5: {
                    this.skijaPaint.setBlendMode(BlendMode.SRC_IN);
                    break;
                }
                case 6: {
                    this.skijaPaint.setBlendMode(BlendMode.DST_IN);
                    break;
                }
                case 7: {
                    this.skijaPaint.setBlendMode(BlendMode.SRC_OUT);
                    break;
                }
                case 8: {
                    this.skijaPaint.setBlendMode(BlendMode.DST_OUT);
                    break;
                }
                case 9: {
                    this.skijaPaint.setBlendMode(BlendMode.DST);
                    break;
                }
                case 10: {
                    this.skijaPaint.setBlendMode(BlendMode.SRC_ATOP);
                    break;
                }
                case 11: {
                    this.skijaPaint.setBlendMode(BlendMode.DST_ATOP);
                }
            }
        }
    }

    @Override
    public void setPaint(Paint paint) {
        LOGGER.debug("setPaint({})", (Object)paint);
        if (paint == null) {
            return;
        }
        if (SkijaGraphics2D.paintsAreEqual(paint, this.awtPaint)) {
            return;
        }
        this.awtPaint = paint;
        if (paint instanceof Color) {
            Color c;
            this.color = c = (Color)paint;
            this.skijaPaint.setShader(Shader.makeColor((int)c.getRGB()));
        } else if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint lgp = (LinearGradientPaint)paint;
            float x0 = (float)lgp.getStartPoint().getX();
            float y0 = (float)lgp.getStartPoint().getY();
            float x1 = (float)lgp.getEndPoint().getX();
            float y1 = (float)lgp.getEndPoint().getY();
            int[] colors = new int[lgp.getColors().length];
            for (int i = 0; i < lgp.getColors().length; ++i) {
                colors[i] = lgp.getColors()[i].getRGB();
            }
            float[] fractions = lgp.getFractions();
            GradientStyle gs = GradientStyle.DEFAULT.withTileMode(this.awtCycleMethodToSkijaFilterTileMode(lgp.getCycleMethod()));
            Shader shader = Shader.makeLinearGradient((float)x0, (float)y0, (float)x1, (float)y1, (int[])colors, (float[])fractions, (GradientStyle)gs);
            this.skijaPaint.setShader(shader);
        } else if (paint instanceof RadialGradientPaint) {
            RadialGradientPaint rgp = (RadialGradientPaint)paint;
            float x = (float)rgp.getCenterPoint().getX();
            float y = (float)rgp.getCenterPoint().getY();
            int[] colors = new int[rgp.getColors().length];
            for (int i = 0; i < rgp.getColors().length; ++i) {
                colors[i] = rgp.getColors()[i].getRGB();
            }
            GradientStyle gs = GradientStyle.DEFAULT.withTileMode(this.awtCycleMethodToSkijaFilterTileMode(rgp.getCycleMethod()));
            Shader shader = Shader.makeRadialGradient((float)x, (float)y, (float)rgp.getRadius(), (int[])colors, (float[])rgp.getFractions(), (GradientStyle)gs);
            this.skijaPaint.setShader(shader);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            float x1 = (float)gp.getPoint1().getX();
            float y1 = (float)gp.getPoint1().getY();
            float x2 = (float)gp.getPoint2().getX();
            float y2 = (float)gp.getPoint2().getY();
            int[] colors = new int[]{gp.getColor1().getRGB(), gp.getColor2().getRGB()};
            GradientStyle gs = GradientStyle.DEFAULT;
            if (gp.isCyclic()) {
                gs = GradientStyle.DEFAULT.withTileMode(FilterTileMode.MIRROR);
            }
            Shader shader = Shader.makeLinearGradient((float)x1, (float)y1, (float)x2, (float)y2, (int[])colors, (float[])null, (GradientStyle)gs);
            this.skijaPaint.setShader(shader);
        }
    }

    @Override
    public void setStroke(Stroke s) {
        SkijaGraphics2D.nullNotPermitted(s, "s");
        LOGGER.debug("setStroke({})", (Object)this.stroke);
        if (s == this.stroke) {
            return;
        }
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            if (bs.equals(this.stroke)) {
                return;
            }
            double lineWidth = bs.getLineWidth();
            this.skijaPaint.setStrokeWidth((float)Math.max(lineWidth, 0.1));
            this.skijaPaint.setStrokeCap(this.awtToSkijaLineCap(bs.getEndCap()));
            this.skijaPaint.setStrokeJoin(this.awtToSkijaLineJoin(bs.getLineJoin()));
            this.skijaPaint.setStrokeMiter(bs.getMiterLimit());
            if (bs.getDashArray() != null) {
                this.skijaPaint.setPathEffect(PathEffect.makeDash((float[])bs.getDashArray(), (float)bs.getDashPhase()));
            } else {
                this.skijaPaint.setPathEffect(null);
            }
        }
        this.stroke = s;
    }

    private PaintStrokeCap awtToSkijaLineCap(int c) {
        if (c == 0) {
            return PaintStrokeCap.BUTT;
        }
        if (c == 1) {
            return PaintStrokeCap.ROUND;
        }
        if (c == 2) {
            return PaintStrokeCap.SQUARE;
        }
        throw new IllegalArgumentException("Unrecognised cap code: " + c);
    }

    private PaintStrokeJoin awtToSkijaLineJoin(int j) {
        if (j == 2) {
            return PaintStrokeJoin.BEVEL;
        }
        if (j == 0) {
            return PaintStrokeJoin.MITER;
        }
        if (j == 1) {
            return PaintStrokeJoin.ROUND;
        }
        throw new IllegalArgumentException("Unrecognised join code: " + j);
    }

    private FilterTileMode awtCycleMethodToSkijaFilterTileMode(MultipleGradientPaint.CycleMethod method) {
        switch (method) {
            case NO_CYCLE: {
                return FilterTileMode.CLAMP;
            }
            case REPEAT: {
                return FilterTileMode.REPEAT;
            }
            case REFLECT: {
                return FilterTileMode.MIRROR;
            }
        }
        return FilterTileMode.CLAMP;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        LOGGER.debug("getRenderingHint({})", (Object)hintKey);
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        LOGGER.debug("setRenderingHint({}, {})", (Object)hintKey, hintValue);
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        LOGGER.debug("setRenderingHints(Map<?, ?>)");
        this.hints.clear();
        this.hints.putAll(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        LOGGER.debug("addRenderingHints(Map<?, ?>)");
        this.hints.putAll(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        LOGGER.debug("getRenderingHints()");
        return (RenderingHints)this.hints.clone();
    }

    @Override
    public void translate(int tx, int ty) {
        LOGGER.debug("translate({}, {})", (Object)tx, (Object)ty);
        this.translate((double)tx, (double)ty);
    }

    @Override
    public void translate(double tx, double ty) {
        LOGGER.debug("translate({}, {})", (Object)tx, (Object)ty);
        this.transform.translate(tx, ty);
        this.canvas.translate((float)tx, (float)ty);
    }

    @Override
    public void rotate(double theta) {
        LOGGER.debug("rotate({})", (Object)theta);
        this.transform.rotate(theta);
        this.canvas.rotate((float)Math.toDegrees(theta));
    }

    @Override
    public void rotate(double theta, double x, double y) {
        LOGGER.debug("rotate({}, {}, {})", new Object[]{theta, x, y});
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        LOGGER.debug("scale({}, {})", (Object)sx, (Object)sy);
        this.transform.scale(sx, sy);
        this.canvas.scale((float)sx, (float)sy);
    }

    @Override
    public void shear(double shx, double shy) {
        LOGGER.debug("shear({}, {})", (Object)shx, (Object)shy);
        this.transform.shear(shx, shy);
        this.canvas.skew((float)shx, (float)shy);
    }

    @Override
    public void transform(AffineTransform t) {
        LOGGER.debug("transform(AffineTransform) : {}", (Object)t);
        AffineTransform tx = this.getTransform();
        tx.concatenate(t);
        this.setTransform(tx);
    }

    @Override
    public AffineTransform getTransform() {
        LOGGER.debug("getTransform()");
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setTransform(AffineTransform t) {
        LOGGER.debug("setTransform({})", (Object)t);
        if (t == null) {
            t = this.transform = new AffineTransform();
        } else {
            this.transform = new AffineTransform(t);
        }
        Matrix33 m33 = new Matrix33(new float[]{(float)t.getScaleX(), (float)t.getShearX(), (float)t.getTranslateX(), (float)t.getShearY(), (float)t.getScaleY(), (float)t.getTranslateY(), 0.0f, 0.0f, 1.0f});
        this.canvas.setMatrix(m33);
    }

    @Override
    public Paint getPaint() {
        return this.awtPaint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public Graphics create() {
        LOGGER.debug("create()");
        SkijaGraphics2D copy = new SkijaGraphics2D(this.canvas);
        copy.setRenderingHints(this.getRenderingHints());
        copy.setClip(this.getClip());
        copy.setPaint(this.getPaint());
        copy.setColor(this.getColor());
        copy.setComposite(this.getComposite());
        copy.setStroke(this.getStroke());
        copy.setFont(this.getFont());
        copy.setTransform(this.getTransform());
        copy.setBackground(this.getBackground());
        return copy;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        LOGGER.debug("create({}, {}, {}, {})", new Object[]{x, y, width, height});
        return super.create(x, y, width, height);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        LOGGER.debug("setColor(Color) : " + c);
        if (c == null || c.equals(this.color)) {
            return;
        }
        this.color = c;
        this.awtPaint = c;
        this.setPaint(c);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public Font getFont() {
        return this.awtFont;
    }

    private FontStyle awtFontStyleToSkijaFontStyle(int style) {
        if (style == 0) {
            return FontStyle.NORMAL;
        }
        if (style == 1) {
            return FontStyle.BOLD;
        }
        if (style == 2) {
            return FontStyle.ITALIC;
        }
        if (style == 3) {
            return FontStyle.BOLD_ITALIC;
        }
        return FontStyle.NORMAL;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.awtFont = font;
        FontStyle style = this.awtFontStyleToSkijaFontStyle(font.getStyle());
        TypefaceKey key = new TypefaceKey(font.getName(), style);
        this.typeface = this.typefaceMap.get(key);
        if (this.typeface == null) {
            this.typeface = Typeface.makeFromName((String)font.getName(), (FontStyle)this.awtFontStyleToSkijaFontStyle(font.getStyle()));
            this.typefaceMap.put(key, this.typeface);
        }
        this.skijaFont = new org.jetbrains.skija.Font(this.typeface, (float)font.getSize());
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        if (this.fmImage == null) {
            this.fmImage = new BufferedImage(10, 10, 1);
            this.fmImageG2D = this.fmImage.createGraphics();
            this.fmImageG2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return this.fmImageG2D.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Shape getClip() {
        LOGGER.debug("getClip()");
        if (this.clip == null) {
            return null;
        }
        try {
            AffineTransform inv = this.transform.createInverse();
            return inv.createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    @Override
    public void setClip(Shape shape) {
        LOGGER.debug("setClip({})", (Object)shape);
        this.clip = this.transform.createTransformedShape(shape);
        this.canvas.restoreToCount(this.restoreCount);
        this.restoreCount = this.canvas.save();
        this.setTransform(this.getTransform());
        if (shape != null) {
            this.canvas.clipPath(this.path(shape));
        }
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        LOGGER.debug("clipRect({}, {}, {}, {})", new Object[]{x, y, width, height});
        this.clip(this.rect(x, y, width, height));
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        LOGGER.debug("setClip({}, {}, {}, {})", new Object[]{x, y, width, height});
        this.setClip(this.rect(x, y, width, height));
    }

    @Override
    public void clip(Shape s) {
        LOGGER.debug("clip({})", (Object)s);
        if (s instanceof Line2D) {
            s = s.getBounds2D();
        }
        if (this.clip == null) {
            this.setClip(s);
            return;
        }
        Shape ts = this.transform.createTransformedShape(s);
        if (!ts.intersects(this.clip.getBounds2D())) {
            this.setClip(new Rectangle2D.Double());
        } else {
            Area a1 = new Area(ts);
            Area a2 = new Area(this.clip);
            a1.intersect(a2);
            this.clip = new Path2D.Double(a1);
            this.canvas.clipPath(this.path(ts));
        }
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        LOGGER.debug("copyArea({}, {}, {}, {}, {}, {}) - NOT IMPLEMENTED", new Object[]{x, y, width, height, dx, dy});
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        LOGGER.debug("drawLine()");
        if (this.line == null) {
            this.line = new Line2D.Double(x1, y1, x2, y2);
        } else {
            this.line.setLine(x1, y1, x2, y2);
        }
        this.draw(this.line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        LOGGER.debug("fillRect({}, {}, {}, {})", new Object[]{x, y, width, height});
        this.fill(this.rect(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        LOGGER.debug("clearRect({}, {}, {}, {})", new Object[]{x, y, width, height});
        if (this.getBackground() == null) {
            return;
        }
        Paint saved = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
    }

    private Rectangle2D rect(int x, int y, int width, int height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double(x, y, width, height);
        } else {
            this.rect.setRect(x, y, width, height);
        }
        return this.rect;
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LOGGER.debug("drawRoundRect({}, {}, {}, {}, {}, {})", new Object[]{x, y, width, height, arcWidth, arcHeight});
        this.draw(this.roundRect(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LOGGER.debug("fillRoundRect({}, {}, {}, {}, {}, {})", new Object[]{x, y, width, height, arcWidth, arcHeight});
        this.fill(this.roundRect(x, y, width, height, arcWidth, arcHeight));
    }

    private RoundRectangle2D roundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        } else {
            this.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
        return this.roundRect;
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        LOGGER.debug("drawOval({}, {}, {}, {})", new Object[]{x, y, width, height});
        this.draw(this.oval(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        LOGGER.debug("fillOval({}, {}, {}, {})", new Object[]{x, y, width, height});
        this.fill(this.oval(x, y, width, height));
    }

    private Ellipse2D oval(int x, int y, int width, int height) {
        if (this.oval == null) {
            this.oval = new Ellipse2D.Double(x, y, width, height);
        } else {
            this.oval.setFrame(x, y, width, height);
        }
        return this.oval;
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        LOGGER.debug("drawArc({}, {}, {}, {}, {}, {})", new Object[]{x, y, width, height, startAngle, arcAngle});
        this.draw(this.arc(x, y, width, height, startAngle, arcAngle));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        LOGGER.debug("fillArc({}, {}, {}, {}, {}, {})", new Object[]{x, y, width, height, startAngle, arcAngle});
        this.fill(this.arc(x, y, width, height, startAngle, arcAngle));
    }

    private Arc2D arc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.arc == null) {
            this.arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        } else {
            this.arc.setArc(x, y, width, height, startAngle, arcAngle, 0);
        }
        return this.arc;
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        LOGGER.debug("drawPolyline(int[], int[], int)");
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, false);
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        LOGGER.debug("drawPolygon(int[], int[], int)");
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        LOGGER.debug("fillPolygon(int[], int[], int)");
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill(p);
    }

    public GeneralPath createPolygon(int[] xPoints, int[] yPoints, int nPoints, boolean close) {
        LOGGER.debug("createPolygon(int[], int[], int, boolean)");
        GeneralPath p = new GeneralPath();
        p.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo(xPoints[i], yPoints[i]);
        }
        if (close) {
            p.closePath();
        }
        return p;
    }

    @Override
    public boolean drawImage(java.awt.Image img, int x, int y, ImageObserver observer) {
        LOGGER.debug("drawImage(Image, {}, {}, ImageObserver)", (Object)x, (Object)y);
        if (img == null) {
            return true;
        }
        int w = img.getWidth(observer);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(observer);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(java.awt.Image img, int x, int y, int width, int height, ImageObserver observer) {
        BufferedImage buffered;
        LOGGER.debug("drawImage(Image, {}, {}, {}, {}, ImageObserver)", new Object[]{x, y, width, height});
        if (img instanceof BufferedImage) {
            buffered = (BufferedImage)img;
        } else {
            buffered = new BufferedImage(width, height, 2);
            Graphics2D g2 = buffered.createGraphics();
            g2.drawImage(img, 0, 0, width, height, null);
            g2.dispose();
        }
        Image skijaImage = SkijaGraphics2D.convertToSkijaImage(buffered);
        this.canvas.drawImageRect(skijaImage, new Rect((float)x, (float)y, (float)(x + width), (float)(y + height)));
        return true;
    }

    @Override
    public boolean drawImage(java.awt.Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        LOGGER.debug("drawImage(Image, {}, {}, Color, ImageObserver)", (Object)x, (Object)y);
        if (img == null) {
            return true;
        }
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, bgcolor, observer);
    }

    @Override
    public boolean drawImage(java.awt.Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        LOGGER.debug("drawImage(Image, {}, {}, {}, {}, Color, ImageObserver)", new Object[]{x, y, width, height});
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
        return this.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(java.awt.Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        LOGGER.debug("drawImage(Image, {}, {}, {}, {}, {}, {}, {}, {}, ImageObserver)", new Object[]{dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2});
        int w = dx2 - dx1;
        int h = dy2 - dy1;
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics2D g2 = img2.createGraphics();
        g2.drawImage(img, 0, 0, w, h, sx1, sy1, sx2, sy2, null);
        return this.drawImage((java.awt.Image)img2, dx1, dy1, null);
    }

    @Override
    public boolean drawImage(java.awt.Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        LOGGER.debug("drawImage(Image, {}, {}, {}, {}, {}, {}, {}, {}, Color, ImageObserver)", new Object[]{dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2});
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.setPaint(saved);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void dispose() {
        LOGGER.debug("dispose()");
        this.canvas.restoreToCount(this.restoreCount);
    }

    private static boolean paintsAreEqual(Paint p1, Paint p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1 instanceof Color && p2 instanceof Color) {
            return p1.equals(p2);
        }
        if (p1 instanceof GradientPaint && p2 instanceof GradientPaint) {
            GradientPaint gp1 = (GradientPaint)p1;
            GradientPaint gp2 = (GradientPaint)p2;
            return gp1.getColor1().equals(gp2.getColor1()) && gp1.getColor2().equals(gp2.getColor2()) && gp1.getPoint1().equals(gp2.getPoint1()) && gp1.getPoint2().equals(gp2.getPoint2()) && gp1.isCyclic() == gp2.isCyclic() && gp1.getTransparency() == gp1.getTransparency();
        }
        if (p1 instanceof LinearGradientPaint && p2 instanceof LinearGradientPaint) {
            LinearGradientPaint lgp1 = (LinearGradientPaint)p1;
            LinearGradientPaint lgp2 = (LinearGradientPaint)p2;
            return lgp1.getStartPoint().equals(lgp2.getStartPoint()) && lgp1.getEndPoint().equals(lgp2.getEndPoint()) && Arrays.equals(lgp1.getFractions(), lgp2.getFractions()) && Arrays.equals(lgp1.getColors(), lgp2.getColors()) && lgp1.getCycleMethod() == lgp2.getCycleMethod() && lgp1.getColorSpace() == lgp2.getColorSpace() && lgp1.getTransform().equals(lgp2.getTransform());
        }
        if (p1 instanceof RadialGradientPaint && p2 instanceof RadialGradientPaint) {
            RadialGradientPaint rgp1 = (RadialGradientPaint)p1;
            RadialGradientPaint rgp2 = (RadialGradientPaint)p2;
            return rgp1.getCenterPoint().equals(rgp2.getCenterPoint()) && rgp1.getRadius() == rgp2.getRadius() && rgp1.getFocusPoint().equals(rgp2.getFocusPoint()) && Arrays.equals(rgp1.getFractions(), rgp2.getFractions()) && Arrays.equals(rgp1.getColors(), rgp2.getColors()) && rgp1.getCycleMethod() == rgp2.getCycleMethod() && rgp1.getColorSpace() == rgp2.getColorSpace() && rgp1.getTransform().equals(rgp2.getTransform());
        }
        return p1.equals(p2);
    }

    private static BufferedImage convertRenderedImage(RenderedImage img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        ColorModel cm = img.getColorModel();
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = img.getPropertyNames();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], img.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        img.copyData(raster);
        return result;
    }

    private static Image convertToSkijaImage(java.awt.Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2 = img.createGraphics();
        g2.drawImage(image, 0, 0, null);
        DataBufferInt db = (DataBufferInt)img.getRaster().getDataBuffer();
        int[] pixels = db.getData();
        byte[] bytes = new byte[pixels.length * 4];
        for (int i = 0; i < pixels.length; ++i) {
            int p = pixels[i];
            bytes[i * 4 + 3] = (byte)((p & 0xFF000000) >> 24);
            bytes[i * 4 + 2] = (byte)((p & 0xFF0000) >> 16);
            bytes[i * 4 + 1] = (byte)((p & 0xFF00) >> 8);
            bytes[i * 4] = (byte)(p & 0xFF);
        }
        ImageInfo imageInfo = new ImageInfo(w, h, ColorType.BGRA_8888, ColorAlphaType.PREMUL);
        return Image.makeRaster((ImageInfo)imageInfo, (byte[])bytes, (long)(image.getWidth(null) * 4));
    }
}

