/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.skija;

import io.github.humbleui.skija.Font;
import io.github.humbleui.skija.FontMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkijaFontMetrics
extends java.awt.FontMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkijaFontMetrics.class);
    private Font skijaFont;
    private FontMetrics metrics;

    public SkijaFontMetrics(Font skijaFont, java.awt.Font awtFont) {
        super(awtFont);
        this.metrics = skijaFont.getMetrics();
        this.skijaFont = skijaFont;
    }

    @Override
    public int getLeading() {
        int result = (int)this.metrics.getLeading();
        LOGGER.debug("getLeading() -> {}", (Object)result);
        return result;
    }

    @Override
    public int getAscent() {
        int result = (int)(-this.metrics.getAscent());
        LOGGER.debug("getAscent() -> {}", (Object)result);
        return result;
    }

    @Override
    public int getDescent() {
        int result = (int)this.metrics.getDescent();
        LOGGER.debug("getDescent() -> {}", (Object)result);
        return result;
    }

    @Override
    public int charWidth(char ch) {
        int result = (int)this.skijaFont.measureTextWidth(Character.toString(ch));
        LOGGER.debug("charWidth({}) -> {}", (Object)Character.valueOf(ch), (Object)result);
        return result;
    }

    @Override
    public int charsWidth(char[] data, int off, int len) {
        int result = (int)this.skijaFont.measureTextWidth(new String(data, off, len));
        LOGGER.debug("charsWidth({}, {}, {}) -> {}", new Object[]{data, off, len, result});
        return result;
    }
}

