/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport.commons;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.transport.commons.ExtendedHttpConnection;

public class ConnectionPool {
    private static Log logger = LogFactory.getLog(ConnectionPool.class);
    private long idleTime = 120000L;
    private HashMap freeConnections = new HashMap();

    public void setIdleTime(long time) {
        this.idleTime = time;
    }

    public synchronized ExtendedHttpConnection getPooledConnection() {
        if (this.freeConnections.isEmpty()) {
            return null;
        }
        long idleTimeout = System.currentTimeMillis() - this.idleTime;
        Iterator iter = this.freeConnections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            iter.remove();
            ConnectionEntry connectionEntry = (ConnectionEntry)entry.getValue();
            ExtendedHttpConnection connection = connectionEntry.getConnection();
            if (connectionEntry.getTimeAdded() <= idleTimeout) {
                connection.close();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("closed idle connection: " + (Object)((Object)connection)));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("got connection from pool: " + (Object)((Object)connection)));
            }
            return connection;
        }
        return null;
    }

    public synchronized void releaseConnection(HttpConnection conn) {
        ExtendedHttpConnection extConn = (ExtendedHttpConnection)conn;
        this.freeConnections.put(conn, new ConnectionEntry(extConn));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returned connection to pool: " + conn));
        }
    }

    public synchronized void closeIdleConnections() {
        long idleTimeout = System.currentTimeMillis() - this.idleTime;
        Iterator iter = this.freeConnections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ConnectionEntry connectionEntry = (ConnectionEntry)entry.getValue();
            if (connectionEntry.getTimeAdded() > idleTimeout) continue;
            iter.remove();
            connectionEntry.getConnection().close();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("closed idle connection: " + (Object)((Object)connectionEntry.getConnection())));
        }
    }

    public synchronized void shutdown() {
        for (Map.Entry entry : this.freeConnections.entrySet()) {
            ConnectionEntry connectionEntry = (ConnectionEntry)entry.getValue();
            connectionEntry.getConnection().close();
        }
        this.freeConnections.clear();
    }

    private static class ConnectionEntry {
        ExtendedHttpConnection connection;
        long timeAdded;

        public ConnectionEntry(ExtendedHttpConnection conn) {
            this.connection = conn;
            this.timeAdded = System.currentTimeMillis();
        }

        public ExtendedHttpConnection getConnection() {
            return this.connection;
        }

        public long getTimeAdded() {
            return this.timeAdded;
        }
    }
}

