/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport;

import java.net.Socket;
import org.apache.axis.MessageContext;
import org.globus.axis.util.Util;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostOrSelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SSLContextHelper {
    private String host;
    private int port;
    private Authorization myAuth;
    private ExtendedGSSContext myContext;

    public SSLContextHelper(MessageContext msgContext, String host, int port) throws GSSException {
        Authorization auth = (Authorization)Util.getProperty(msgContext, "org.globus.gsi.authorization");
        Boolean anonymous = (Boolean)Util.getProperty(msgContext, "org.globus.gsi.anonymous");
        GSSCredential cred = (GSSCredential)Util.getProperty(msgContext, "org.globus.gsi.credentials");
        Integer protection = (Integer)Util.getProperty(msgContext, "org.globus.security.transport.type");
        TrustedCertificates trustedCerts = (TrustedCertificates)Util.getProperty(msgContext, "org.globus.security.trustedCertifictes");
        this.init(host, port, auth, anonymous, cred, protection, trustedCerts);
    }

    public SSLContextHelper(String host, int port, Authorization auth, Boolean anonymous, GSSCredential cred, Integer protection, TrustedCertificates trustedCerts) throws GSSException {
        this.init(host, port, auth, anonymous, cred, protection, trustedCerts);
    }

    protected void init(String host, int port, Authorization auth, Boolean anonymous, GSSCredential cred, Integer protection, TrustedCertificates trustedCerts) throws GSSException {
        this.host = host;
        this.port = port;
        if (auth == null) {
            auth = HostOrSelfAuthorization.getInstance();
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        boolean anon = false;
        if (anonymous != null && anonymous.equals(Boolean.TRUE)) {
            anon = true;
        }
        if (anon) {
            GSSName name = manager.createName((String)null, (Oid)null);
            cred = manager.createCredential(name, 0, (Oid)null, 1);
        }
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
        if (anon) {
            context.requestAnonymity(true);
        }
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_SSL);
        if (GSIConstants.ENCRYPTION.equals(protection)) {
            context.requestConf(true);
        } else {
            context.requestConf(false);
        }
        if (trustedCerts != null) {
            context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trustedCerts);
        }
        this.myContext = context;
        this.myAuth = auth;
    }

    public GssSocket wrapSocket(Socket socket) {
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket gsiSocket = (GssSocket)factory.createSocket(socket, this.host, this.port, (GSSContext)this.myContext);
        gsiSocket.setAuthorization(this.myAuth);
        return gsiSocket;
    }
}

