/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapes.webconlet.logviewer;

import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.LogRecord;
import org.jgrapes.core.Channel;
import org.jgrapes.core.Event;
import org.jgrapes.core.annotation.Handler;
import org.jgrapes.webconlet.logviewer.LogViewerHandler;
import org.jgrapes.webconsole.base.Conlet;
import org.jgrapes.webconsole.base.ConsoleConnection;
import org.jgrapes.webconsole.base.WebConsoleUtils;
import org.jgrapes.webconsole.base.events.AddConletType;
import org.jgrapes.webconsole.base.events.AddPageResources;
import org.jgrapes.webconsole.base.events.ConsoleReady;
import org.jgrapes.webconsole.base.events.NotifyConletModel;
import org.jgrapes.webconsole.base.events.NotifyConletView;
import org.jgrapes.webconsole.base.events.RenderConlet;
import org.jgrapes.webconsole.base.events.RenderConletRequestBase;
import org.jgrapes.webconsole.base.events.SetLocale;
import org.jgrapes.webconsole.base.freemarker.FreeMarkerConlet;

public class LogViewerConlet
extends FreeMarkerConlet<Serializable> {
    private static final Set<Conlet.RenderMode> MODES = Conlet.RenderMode.asSet((Conlet.RenderMode[])new Conlet.RenderMode[]{Conlet.RenderMode.View});

    public LogViewerConlet(Channel componentChannel) {
        super(componentChannel);
    }

    @Handler
    public void onConsoleReady(ConsoleReady event, ConsoleConnection channel) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        channel.respond((Event)new AddConletType(this.type()).setDisplayNames(this.localizations(channel.supportedLocales(), "conletName")).addRenderMode(Conlet.RenderMode.View).addScript(new AddPageResources.ScriptResource().setScriptType("module").setScriptUri(event.renderSupport().conletResource(this.type(), "LogViewer-functions.ftl.js"))).addCss(event.renderSupport(), WebConsoleUtils.uriFromPath((String)"LogViewer-style.css")));
    }

    protected Set<Conlet.RenderMode> doRenderConlet(RenderConletRequestBase<?> event, ConsoleConnection channel, String conletId, Serializable conletState) throws Exception {
        HashSet<Conlet.RenderMode> renderedAs = new HashSet<Conlet.RenderMode>();
        if (event.renderAs().contains(Conlet.RenderMode.View)) {
            Template tpl = this.freemarkerConfig().getTemplate("LogViewer-view.ftl.html");
            channel.respond((Event)new RenderConlet(this.type(), conletId, this.processTemplate(event, tpl, this.fmModel(event, channel, conletId, conletState))).setRenderAs(Conlet.RenderMode.View.addModifiers(event.renderAs())).setSupportedModes(MODES));
            this.sendAllEntries(channel, conletId);
            renderedAs.add(Conlet.RenderMode.View);
        }
        return renderedAs;
    }

    private void sendAllEntries(ConsoleConnection channel, String conletId) {
        channel.respond((Event)new NotifyConletView(this.type(), conletId, "entries", new Object[]{LogViewerHandler.setConlet(this).stream().map(entry -> this.logEntryAsMap((LogRecord)entry)).toArray()}));
    }

    void addEntry(LogRecord entry) {
        for (ConsoleConnection connection : this.trackedConnections()) {
            for (String conletId : this.conletIds(connection)) {
                connection.respond(new NotifyConletView(this.type(), conletId, "addEntry", new Object[]{this.logEntryAsMap(entry)}).disableTracking());
            }
        }
    }

    private Map<String, Object> logEntryAsMap(LogRecord record) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("exception", Optional.ofNullable(record.getThrown()).map(exc -> exc.getMessage()).orElse(""));
        result.put("stacktrace", Optional.ofNullable(record.getThrown()).map(exc -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(out);
            exc.printStackTrace(printWriter);
            printWriter.close();
            return out.toString();
        }).orElse(""));
        result.put("loggerName", record.getLoggerName());
        result.put("source", record.getSourceClassName() + "::" + record.getSourceMethodName());
        result.put("logLevel", record.getLevel().toString());
        result.put("message", record.getMessage());
        result.put("time", record.getInstant().toEpochMilli());
        result.put("sequence", record.getSequenceNumber());
        return result;
    }

    protected void doUpdateConletState(NotifyConletModel event, ConsoleConnection channel, Serializable conletState) throws Exception {
        event.stop();
        switch (event.method()) {
            case "resync": {
                this.sendAllEntries(channel, event.conletId());
            }
        }
    }

    protected boolean doSetLocale(SetLocale event, ConsoleConnection channel, String conletId) throws Exception {
        return true;
    }
}

