/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.aws;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.aws.s3.NATIVE_S3_PING;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

public class S3_PING
extends FILE_PING {
    protected static final short JGROUPS_PROTOCOL_DEFAULT_MAGIC_NUMBER = 789;
    protected static final int SERIALIZATION_BUFFER_SIZE = 4096;
    protected static final String SERIALIZED_CONTENT_TYPE = "text/plain";
    protected static final String MAGIC_NUMBER_SYSTEM_PROPERTY = "s3ping.magic_number";
    @Property(description="Forces the AWS S3 client to use path-style addressing for buckets (default: false).", systemProperty={"jgroups.aws.s3.path_style_access_enabled", "JGROUPS_AWS_S3_PATH_STYLE_ACCESS_ENABLED"}, writable=false)
    protected boolean path_style_access_enabled;
    @Property(description="The AWS endpoint with which to communicate (optional).", systemProperty={"jgroups.aws.s3.endpoint", "JGROUPS_AWS_S3_ENDPOINT"}, writable=false)
    protected String endpoint;
    @Property(description="The AWS region with which to communicate (required).", systemProperty={"jgroups.aws.s3.region_name", "JGROUPS_AWS_S3_REGION_NAME"}, writable=false)
    protected String region_name;
    @Property(description="The AWS S3 bucket name to use (required).", systemProperty={"jgroups.aws.s3.bucket_name", "JGROUPS_AWS_S3_BUCKET_NAME"}, writable=false)
    protected String bucket_name;
    @Property(description="The prefix to prefix all AWS S3 paths with, e.g. 'jgroups/' (optional).", systemProperty={"jgroups.aws.s3.bucket_prefix", "JGROUPS_AWS_S3_BUCKET_PREFIX"}, writable=false)
    protected String bucket_prefix;
    @Property(description="Whether to check if the bucket exists in AWS S3 and create a new one if it does not exist yet (default: true).", systemProperty={"jgroups.aws.s3.check_if_bucket_exists", "JGROUPS_AWS_S3_CHECK_IF_BUCKET_EXISTS"}, writable=false)
    protected boolean check_if_bucket_exists = true;
    @Property(description="Whether to grant the bucket owner full control over the bucket on each update. This is useful in multi-region deployments where each region exists in its own AWS account (default: false).", systemProperty={"jgroups.aws.s3.acl_grant_bucket_owner_full_control", "JGROUPS_AWS_S3_ACL_GRANT_BUCKET_OWNER_FULL_CONTROL"}, writable=false)
    protected boolean acl_grant_bucket_owner_full_control;
    @Property(description="KMS key to use for enabling KMS server-side encryption (SSE-KMS) for AWS S3 (optional).", systemProperty={"jgroups.aws.s3.kms_key_id", "JGROUPS_AWS_S3_KMS_KEY_ID"}, exposeAsManagedAttribute=false)
    protected String kms_key_id;
    protected S3Client s3Client;

    public void init() throws Exception {
        boolean bucket_exists;
        super.init();
        if (this.bucket_prefix == null || this.bucket_prefix.equals("/")) {
            this.bucket_prefix = "";
        } else if (!this.bucket_prefix.endsWith("/") && !this.bucket_prefix.isEmpty()) {
            this.bucket_prefix = this.bucket_prefix + "/";
        }
        S3ClientBuilder builder = S3Client.builder();
        builder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        builder.forcePathStyle(Boolean.valueOf(this.path_style_access_enabled));
        Region region = Region.of((String)this.region_name);
        builder.region(region);
        if (S3_PING.isDefined(this.endpoint)) {
            builder.endpointOverride(new URI(this.endpoint));
            this.log.info("Overriding AWS endpoint to '%s'.", new Object[]{this.endpoint});
        }
        this.s3Client = (S3Client)builder.build();
        this.log.info("Using AWS S3 ping in region '%s' with bucket '%s' and prefix '%s'.", new Object[]{region, this.bucket_name, this.bucket_prefix});
        if (!this.check_if_bucket_exists) {
            return;
        }
        HeadBucketRequest headBucketRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucket_name).build();
        try {
            this.s3Client.headBucket(headBucketRequest);
            bucket_exists = true;
        }
        catch (NoSuchBucketException ignore) {
            bucket_exists = false;
        }
        if (!bucket_exists) {
            this.log.info("Bucket '%s' does not exist, creating it.", new Object[]{this.bucket_name});
            CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucket_name).build();
            try {
                this.s3Client.createBucket(createBucketRequest);
            }
            catch (BucketAlreadyExistsException | BucketAlreadyOwnedByYouException exception) {
                this.log.info("Attempted to create bucket '%s' but it already exists.", new Object[]{this.bucket_name});
                return;
            }
            this.log.info("Created bucket '%s'.", new Object[]{this.bucket_name});
        } else {
            this.log.info("Found bucket '%s'.", new Object[]{this.bucket_name});
        }
    }

    protected void createRootDir() {
    }

    protected String getClusterPrefix(String clusterName) {
        return this.bucket_prefix + clusterName + "/";
    }

    protected void readAll(List<Address> members, String clustername, Responses responses) {
        if (clustername == null) {
            return;
        }
        String clusterPrefix = this.getClusterPrefix(clustername);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Getting entries for cluster '%s'.", new Object[]{clusterPrefix});
        }
        try {
            ListObjectsRequest listObjectsRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucket_name).prefix(clusterPrefix).build();
            ListObjectsResponse objects = this.s3Client.listObjects(listObjectsRequest);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Got object listing, %d entries for cluster '%s'.", new Object[]{objects.contents().size(), clusterPrefix});
            }
            for (S3Object s3Object : objects.contents()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Fetching data for object '%s'.", new Object[]{s3Object.key()});
                }
                if (s3Object.size() > 0L) {
                    List data;
                    GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket_name).key(s3Object.key()).build();
                    ResponseBytes objectAsBytes = this.s3Client.getObjectAsBytes(getObjectRequest);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Parsing data for object '%s': '%s'.", new Object[]{s3Object.key(), objectAsBytes.toString()});
                    }
                    if ((data = this.read(objectAsBytes.asInputStream())) == null) {
                        this.log.debug("Fetched update for cluster '%s' member list in AWS S3 is empty.", new Object[]{clusterPrefix});
                        break;
                    }
                    for (PingData pingData : data) {
                        if (members == null || members.contains(pingData.getAddress())) {
                            responses.addResponse(pingData, pingData.isCoord());
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Added member '%s', members '%s'.", new Object[]{pingData, members != null});
                            }
                        }
                        if (this.local_addr != null && !this.local_addr.equals(pingData.getAddress())) {
                            this.addDiscoveryResponseToCaches(pingData.getAddress(), pingData.getLogicalName(), pingData.getPhysicalAddr());
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Added possible member '%s' with local address '%s'.", new Object[]{pingData, this.local_addr});
                            }
                        }
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace("Processed entry in AWS S3: '%s' -> '%s'.", new Object[]{s3Object.key(), pingData});
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Skipping empty object '%s'.", new Object[]{s3Object.key()});
            }
            this.log.debug("Fetched update for member list in AWS S3 for cluster '%s'.", new Object[]{clusterPrefix});
        }
        catch (Exception e) {
            this.log.error(String.format("Failed getting member list from AWS S3 for cluster '%s'.", clusterPrefix), (Throwable)e);
        }
    }

    protected void write(List<PingData> list, String clustername) {
        String filename = S3_PING.addressToFilename((Address)this.local_addr);
        String key = this.getClusterPrefix(clustername) + filename;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
            this.write(list, outStream);
            byte[] data = outStream.toByteArray();
            if (this.log.isTraceEnabled()) {
                this.log.trace("New AWS S3 file content (%d bytes): %s", new Object[]{data.length, new String(data)});
            }
            PutObjectRequest.Builder putRequestBuilder = PutObjectRequest.builder().bucket(this.bucket_name).key(key).contentType(SERIALIZED_CONTENT_TYPE);
            if (this.acl_grant_bucket_owner_full_control) {
                putRequestBuilder.acl(ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL);
            }
            if (S3_PING.isDefined(this.kms_key_id)) {
                putRequestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS);
                putRequestBuilder.ssekmsKeyId(this.kms_key_id);
            }
            RequestBody requestBody = RequestBody.fromBytes((byte[])data);
            this.s3Client.putObject((PutObjectRequest)putRequestBuilder.build(), requestBody);
            this.log.debug("Wrote member list to AWS S3: '%s' -> '%s'.", new Object[]{key, list});
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to update member list in AWS S3 in '%s'.", key), (Throwable)e);
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        String filename = S3_PING.addressToFilename((Address)addr);
        String key = this.getClusterPrefix(clustername) + filename;
        try {
            DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket_name).key(key).build();
            this.s3Client.deleteObject(deleteObjectRequest);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Removing key '%s'.", new Object[]{key});
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage((String)"FailureRemovingData"), (Throwable)e);
        }
    }

    protected void removeAll(String clustername) {
        if (clustername == null) {
            return;
        }
        String clusterPrefix = this.getClusterPrefix(clustername);
        try {
            ListObjectsRequest listRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucket_name).prefix(clusterPrefix).build();
            ListObjectsResponse objects = this.s3Client.listObjects(listRequest);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Got object listing, '%d' entries for cluster '%s'.", new Object[]{objects.contents().size(), clusterPrefix});
            }
            for (S3Object object : objects.contents()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Fetching data for object '%s'.", new Object[]{object.key()});
                }
                try {
                    DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucket_name).key(object.key()).build();
                    this.s3Client.deleteObject(deleteObjectRequest);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Removing '%s'.", new Object[]{object.key()});
                }
                catch (Throwable t) {
                    this.log.error("Failed deleting object '%s': %s", new Object[]{object.key(), t});
                }
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage((String)"FailedDeletingAllObjects"), (Throwable)ex);
        }
    }

    private static boolean isDefined(String s) {
        return s != null && !s.trim().isEmpty();
    }

    static {
        short magicNumber = 789;
        if (S3_PING.isDefined(System.getProperty(MAGIC_NUMBER_SYSTEM_PROPERTY))) {
            try {
                magicNumber = Short.parseShort(System.getProperty(MAGIC_NUMBER_SYSTEM_PROPERTY));
            }
            catch (NumberFormatException e) {
                LogFactory.getLog(S3_PING.class).warn("Could not convert provided property '%s' to short. Using default magic number: %d.", new Object[]{System.getProperty(MAGIC_NUMBER_SYSTEM_PROPERTY), (short)789});
            }
        }
        ClassConfigurator.addProtocol((short)magicNumber, NATIVE_S3_PING.class);
        magicNumber = (short)(magicNumber + 1);
        ClassConfigurator.addProtocol((short)magicNumber, S3_PING.class);
    }
}

