/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.aws.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class NATIVE_S3_PING
extends FILE_PING {
    protected static final short JGROUPS_PROTOCOL_DEFAULT_MAGIC_NUMBER = 789;
    protected static final int SERIALIZATION_BUFFER_SIZE = 4096;
    protected static final String SERIALIZED_CONTENT_TYPE = "text/plain";
    protected static final String MAGIC_NUMBER_SYSTEM_PROPERTY = "s3ping.magic_number";
    @Property(description="The S3 endpoint to use (optional).", exposeAsManagedAttribute=false)
    protected String endpoint;
    @Property(description="The S3 region to use.", exposeAsManagedAttribute=false)
    protected String regionName;
    @Property(description="The S3 bucket to use.", exposeAsManagedAttribute=false)
    protected String bucketName;
    @Property(description="The S3 bucket prefix to use (optional e.g. 'jgroups/').", exposeAsManagedAttribute=false)
    protected String bucketPrefix;
    protected AmazonS3 s3;

    public void init() throws Exception {
        super.init();
        if (this.bucketPrefix == null || this.bucketPrefix.equals("/")) {
            this.bucketPrefix = "";
        } else if (!this.bucketPrefix.endsWith("/") && !this.bucketPrefix.isEmpty()) {
            this.bucketPrefix = this.bucketPrefix + "/";
        }
        DefaultAWSCredentialsProviderChain creds = DefaultAWSCredentialsProviderChain.getInstance();
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)creds)).withRegion(this.regionName);
        if (this.endpoint != null) {
            builder = (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.regionName));
            this.log.info("set Amazon S3 endpoint to %s", new Object[]{this.endpoint});
        }
        this.s3 = (AmazonS3)builder.build();
        this.log.info("using Amazon S3 ping in region %s with bucket '%s' and prefix '%s'", new Object[]{this.regionName, this.bucketName, this.bucketPrefix});
    }

    protected void createRootDir() {
    }

    protected String getClusterPrefix(String clusterName) {
        return this.bucketPrefix + clusterName + "/";
    }

    protected void readAll(List<Address> members, String clustername, Responses responses) {
        if (clustername == null) {
            return;
        }
        String clusterPrefix = this.getClusterPrefix(clustername);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getting entries for %s ...", new Object[]{clusterPrefix});
        }
        try {
            ObjectListing objectListing = this.s3.listObjects(new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(clusterPrefix));
            if (this.log.isTraceEnabled()) {
                this.log.trace("got object listing, %d entries [%s]", new Object[]{objectListing.getObjectSummaries().size(), clusterPrefix});
            }
            for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("fetching data for object %s ...", new Object[]{summary.getKey()});
                }
                if (summary.getSize() > 0L) {
                    List data;
                    S3Object object = this.s3.getObject(new GetObjectRequest(summary.getBucketName(), summary.getKey()));
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("parsing data for object %s (%s, %d bytes)...", new Object[]{summary.getKey(), object.getObjectMetadata().getContentType(), object.getObjectMetadata().getContentLength()});
                    }
                    if ((data = this.read((InputStream)object.getObjectContent())) == null) {
                        this.log.debug("fetched update for member list in Amazon S3 is empty [%s]", new Object[]{clusterPrefix});
                        break;
                    }
                    for (PingData pingData : data) {
                        if (members == null || members.contains(pingData.getAddress())) {
                            responses.addResponse(pingData, pingData.isCoord());
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("added member %s [members: %s]", new Object[]{pingData, members != null});
                            }
                        }
                        if (this.local_addr != null && !this.local_addr.equals(pingData.getAddress())) {
                            this.addDiscoveryResponseToCaches(pingData.getAddress(), pingData.getLogicalName(), pingData.getPhysicalAddr());
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("added possible member %s [local address: %s]", new Object[]{pingData, this.local_addr});
                            }
                        }
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace("processed entry in Amazon S3 [%s -> %s]", new Object[]{summary.getKey(), pingData});
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("skipping object %s as it is empty", new Object[]{summary.getKey()});
            }
            this.log.debug("fetched update for member list in Amazon S3 [%s]", new Object[]{clusterPrefix});
        }
        catch (Exception e) {
            this.log.error(String.format("failed getting member list from Amazon S3 [%s]", clusterPrefix), (Throwable)e);
        }
    }

    protected void write(List<PingData> list, String clustername) {
        String filename = NATIVE_S3_PING.addressToFilename((Address)this.local_addr);
        String key = this.getClusterPrefix(clustername) + filename;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(4096);
            this.write(list, outStream);
            byte[] data = outStream.toByteArray();
            ByteArrayInputStream inStream = new ByteArrayInputStream(data);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(SERIALIZED_CONTENT_TYPE);
            objectMetadata.setContentLength((long)data.length);
            if (this.log.isTraceEnabled()) {
                this.log.trace("new S3 file content (%d bytes): %s", new Object[]{data.length, new String(data)});
            }
            this.s3.putObject(new PutObjectRequest(this.bucketName, key, (InputStream)inStream, objectMetadata));
            this.log.debug("wrote member list to Amazon S3 [%s -> %s]", new Object[]{key, list});
        }
        catch (Exception e) {
            this.log.error(String.format("failed to update member list in Amazon S3 [%s]", key), (Throwable)e);
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        String filename = NATIVE_S3_PING.addressToFilename((Address)addr);
        String key = this.getClusterPrefix(clustername) + filename;
        try {
            this.s3.deleteObject(new DeleteObjectRequest(this.bucketName, key));
            if (this.log.isTraceEnabled()) {
                this.log.trace("removing " + key);
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage((String)"FailureRemovingData"), (Throwable)e);
        }
    }

    protected void removeAll(String clustername) {
        if (clustername == null) {
            return;
        }
        String clusterPrefix = this.getClusterPrefix(clustername);
        try {
            ObjectListing objectListing = this.s3.listObjects(new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(clusterPrefix));
            if (this.log.isTraceEnabled()) {
                this.log.trace("got object listing, %d entries [%s]", new Object[]{objectListing.getObjectSummaries().size(), clusterPrefix});
            }
            for (S3ObjectSummary summary : objectListing.getObjectSummaries()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("fetching data for object %s ...", new Object[]{summary.getKey()});
                }
                try {
                    this.s3.deleteObject(new DeleteObjectRequest(this.bucketName, summary.getKey()));
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("removing %s/%s", new Object[]{summary.getKey()});
                }
                catch (Throwable t) {
                    this.log.error("failed deleting object %s/%s: %s", new Object[]{summary.getKey(), t});
                }
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage((String)"FailedDeletingAllObjects"), (Throwable)ex);
        }
    }

    public static void registerProtocolWithJGroups(short magicNumber) {
        ClassConfigurator.addProtocol((short)magicNumber, NATIVE_S3_PING.class);
    }

    static {
        short magicNumber = 789;
        if (!StringUtils.isNullOrEmpty((String)System.getProperty(MAGIC_NUMBER_SYSTEM_PROPERTY))) {
            try {
                magicNumber = Short.parseShort(System.getProperty(MAGIC_NUMBER_SYSTEM_PROPERTY));
            }
            catch (NumberFormatException e) {
                LogFactory.getLog(NATIVE_S3_PING.class).warn("Could not convert " + System.getProperty(MAGIC_NUMBER_SYSTEM_PROPERTY) + " to short. Using default magic number " + 789);
            }
        }
        NATIVE_S3_PING.registerProtocolWithJGroups(magicNumber);
    }
}

