/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;

public class AZURE_PING
extends FILE_PING {
    private static final Log log = LogFactory.getLog(AZURE_PING.class);
    @Property(description="The name of the storage account.")
    protected String storage_account_name;
    @Property(description="The secret account access key.", exposeAsManagedAttribute=false)
    protected String storage_access_key;
    @Property(description="Container to store ping information in. Must be valid DNS name.")
    protected String container;
    @Property(description="Whether or not to use HTTPS to connect to Azure.")
    protected boolean use_https = true;
    public static final int STREAM_BUFFER_SIZE = 4096;
    private CloudBlobContainer containerReference;

    public void init() throws Exception {
        super.init();
        this.validateConfiguration();
        try {
            StorageCredentialsAccountAndKey credentials = new StorageCredentialsAccountAndKey(this.storage_account_name, this.storage_access_key);
            CloudStorageAccount storageAccount = new CloudStorageAccount((StorageCredentials)credentials, this.use_https);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            this.containerReference = blobClient.getContainerReference(this.container);
            boolean created = this.containerReference.createIfNotExists();
            if (created) {
                log.info("Created container named '" + this.container + "'.");
            } else {
                log.debug("Using existing container named '" + this.container + "'.");
            }
        }
        catch (Exception ex) {
            log.error("Error creating a storage client! Check your configuration.");
            throw ex;
        }
    }

    public void validateConfiguration() throws IllegalArgumentException {
        if (this.container == null || !this.container.toLowerCase().equals(this.container) || this.container.contains("--") || this.container.startsWith("-") || this.container.length() < 3 || this.container.length() > 63) {
            throw new IllegalArgumentException("Container name must be configured and must meet Azure requirements (must be a valid DNS name).");
        }
        if (this.storage_account_name == null || this.storage_access_key == null) {
            throw new IllegalArgumentException("Account name and key must be configured.");
        }
        if (!this.use_https) {
            log.info("Configuration is using HTTP, consider switching to HTTPS instead.");
        }
    }

    protected void createRootDir() {
    }

    protected List<PingData> readAll(String clustername) {
        if (clustername == null) {
            return null;
        }
        LinkedList<PingData> pingData = new LinkedList<PingData>();
        String prefix = AZURE_PING.sanitize(clustername);
        Iterable listBlobItems = this.containerReference.listBlobs(prefix);
        for (ListBlobItem blobItem : listBlobItems) {
            try {
                if (!(blobItem instanceof CloudBlob)) continue;
                CloudBlob blob = (CloudBlob)blobItem;
                ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
                blob.download((OutputStream)os);
                byte[] pingBytes = os.toByteArray();
                pingData.add(AZURE_PING.parsePingData(pingBytes));
            }
            catch (Exception t) {
                log.error("Error fetching ping data.");
            }
        }
        return pingData;
    }

    private static PingData parsePingData(byte[] pingBytes) throws Exception {
        if (pingBytes == null || pingBytes.length <= 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(pingBytes);
        DataInputStream di = new DataInputStream(bis);
        PingData tmp = new PingData();
        tmp.readFrom((DataInput)di);
        return tmp;
    }

    protected synchronized void writeToFile(PingData data, String clustername) {
        if (data == null || clustername == null) {
            return;
        }
        String filename = AZURE_PING.addressToFilename(clustername, this.local_addr);
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        DataOutputStream dataOut = new DataOutputStream(out);
        try {
            data.writeTo((DataOutput)dataOut);
            byte[] uploadData = out.toByteArray();
            CloudBlockBlob blob = this.containerReference.getBlockBlobReference(filename);
            blob.upload((InputStream)new ByteArrayInputStream(uploadData), (long)uploadData.length);
        }
        catch (Exception ex) {
            log.error("Error marshalling and uploading ping data.", (Throwable)ex);
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        String filename = AZURE_PING.addressToFilename(clustername, addr);
        try {
            CloudBlockBlob blob = this.containerReference.getBlockBlobReference(filename);
            boolean deleted = blob.deleteIfExists();
            if (deleted) {
                log.debug("Tried to delete file '" + filename + "' but it was already deleted.");
            } else {
                log.trace("Deleted file '" + filename + "'.");
            }
        }
        catch (Exception ex) {
            log.error("Error deleting files.", (Throwable)ex);
        }
    }

    protected static String addressToFilename(String clustername, Address address) {
        return AZURE_PING.sanitize(clustername) + "-" + AZURE_PING.addressAsString((Address)address);
    }

    protected static String sanitize(String name) {
        return name.replace('/', '-').replace('\\', '-');
    }

    static {
        ClassConfigurator.addProtocol((short)530, AZURE_PING.class);
    }
}

