/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Address;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.util.Util;

public class HeartbeatRequest
extends RaftHeader {
    protected Address leader;

    public HeartbeatRequest() {
    }

    public HeartbeatRequest(int term, Address leader) {
        super(term);
        this.leader = leader;
    }

    @Override
    public int size() {
        return super.size() + Util.size((Address)this.leader);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Util.writeAddress((Address)this.leader, (DataOutput)out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.leader = Util.readAddress((DataInput)in);
    }

    @Override
    public String toString() {
        return super.toString() + ", leader=" + this.leader;
    }
}

