/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ObjIntConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;

public class InMemoryLog
implements Log {
    protected String name;
    protected int current_term;
    protected Address voted_for;
    protected int first_applied;
    protected int last_applied;
    protected int commit_index;
    protected LogEntry[] entries;
    public static final Map<String, Log> logs = new ConcurrentHashMap<String, Log>();
    protected static final int INCR = 16;

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        this.name = log_name;
        InMemoryLog existing = (InMemoryLog)logs.putIfAbsent(this.name, this);
        if (existing != null) {
            this.current_term = existing.current_term;
            this.voted_for = existing.voted_for;
            this.first_applied = existing.first_applied;
            this.last_applied = existing.last_applied;
            this.commit_index = existing.commit_index;
            this.entries = existing.entries;
        } else {
            this.current_term = 0;
            this.voted_for = null;
            this.first_applied = 0;
            this.last_applied = 0;
            this.commit_index = 0;
            this.entries = new LogEntry[16];
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        logs.remove(this.name);
    }

    @Override
    public int currentTerm() {
        return this.current_term;
    }

    @Override
    public synchronized Log currentTerm(int new_term) {
        this.current_term = new_term;
        return this;
    }

    @Override
    public Address votedFor() {
        return this.voted_for;
    }

    @Override
    public synchronized Log votedFor(Address member) {
        this.voted_for = member;
        return this;
    }

    @Override
    public int commitIndex() {
        return this.commit_index;
    }

    @Override
    public synchronized Log commitIndex(int new_index) {
        this.commit_index = new_index;
        return this;
    }

    @Override
    public int firstApplied() {
        return this.first_applied;
    }

    @Override
    public int lastApplied() {
        return this.last_applied;
    }

    @Override
    public synchronized void append(int index, boolean overwrite, LogEntry ... new_entries) {
        int available_space;
        int space_required = new_entries != null ? new_entries.length : 0;
        if (space_required > (available_space = this.entries.length - this.last_applied)) {
            this.expand(space_required - available_space + 1);
        }
        for (LogEntry entry : new_entries) {
            int idx = index - this.first_applied;
            if (!overwrite && this.entries[idx] != null) {
                throw new IllegalStateException("Index " + index + " already contains a log entry: " + this.entries[idx]);
            }
            this.entries[idx] = entry;
            this.last_applied = Math.max(this.last_applied, index);
            ++index;
            if (entry.term <= this.current_term) continue;
            this.current_term = entry.term;
        }
    }

    @Override
    public synchronized LogEntry get(int index) {
        int real_index = index - this.first_applied;
        return real_index < 0 || real_index >= this.entries.length ? null : this.entries[real_index];
    }

    @Override
    public synchronized void truncate(int index) {
        if (index > this.commit_index) {
            index = this.commit_index;
        }
        LogEntry[] tmp = new LogEntry[this.entries.length];
        int idx = index - this.first_applied;
        System.arraycopy(this.entries, idx, tmp, 0, this.entries.length - idx);
        this.entries = tmp;
        this.first_applied = index;
    }

    @Override
    public synchronized void deleteAllEntriesStartingFrom(int start_index) {
        int idx = start_index - this.first_applied;
        if (idx < 0 || idx >= this.entries.length) {
            return;
        }
        for (int index = idx; index <= this.last_applied; ++index) {
            this.entries[index] = null;
        }
        LogEntry last = this.get(start_index - 1);
        this.current_term = last != null ? last.term : 0;
        this.last_applied = start_index - 1;
        if (this.commit_index > this.last_applied) {
            this.commit_index = this.last_applied;
        }
    }

    @Override
    public synchronized void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
        if (start_index < this.first_applied) {
            start_index = this.first_applied;
        }
        if (end_index > this.last_applied) {
            end_index = this.last_applied;
        }
        int start = Math.max(1, start_index) - this.first_applied;
        int end = end_index - this.first_applied;
        for (int i = start; i <= end; ++i) {
            LogEntry entry = this.entries[i];
            function.accept(entry, start_index);
            ++start_index;
        }
    }

    @Override
    public synchronized void forEach(ObjIntConsumer<LogEntry> function) {
        this.forEach(function, Math.max(1, this.first_applied), this.last_applied);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("first_applied=").append(this.first_applied).append(", last_applied=").append(this.last_applied).append(", commit_index=").append(this.commit_index).append(", current_term=").append(this.current_term);
        return sb.toString();
    }

    protected void expand(int min_size_needed) {
        LogEntry[] new_entries = new LogEntry[Math.max(this.entries.length + 16, this.entries.length + min_size_needed)];
        System.arraycopy(this.entries, 0, new_entries, 0, this.entries.length);
        this.entries = new_entries;
    }
}

