/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import org.apache.commons.io.FileUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.jgroups.Address;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.util.IntegerHelper;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class LevelDBLog
implements Log {
    protected final org.jgroups.logging.Log log = LogFactory.getLog(this.getClass());
    private static final byte[] FIRSTAPPLIED = "FA".getBytes();
    private static final byte[] LASTAPPLIED = "LA".getBytes();
    private static final byte[] CURRENTTERM = "CT".getBytes();
    private static final byte[] COMMITINDEX = "CX".getBytes();
    private static final byte[] VOTEDFOR = "VF".getBytes();
    private DB db;
    private File dbFileName;
    private Integer currentTerm = 0;
    private Address votedFor = null;
    private Integer commitIndex = 0;
    private Integer lastApplied = 0;
    private Integer firstApplied = 0;

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        Options options = new Options();
        options.createIfMissing(true);
        this.dbFileName = new File(log_name);
        this.db = JniDBFactory.factory.open(this.dbFileName, options);
        this.log.trace("opened %s", new Object[]{this.db});
        if (this.isANewRAFTLog()) {
            this.log.trace("log %s is new, must be initialized", new Object[]{this.dbFileName});
            this.initLogWithMetadata();
        } else {
            this.log.trace("log %s exists, does not have to be initialized", new Object[]{this.dbFileName});
            this.readMetadataFromLog();
        }
        this.checkForConsistency();
    }

    @Override
    public void close() {
        try {
            this.log.trace("closing DB: %s", new Object[]{this.db});
            if (this.db != null) {
                this.db.close();
            }
            this.currentTerm = 0;
            this.votedFor = null;
            this.commitIndex = 0;
            this.lastApplied = 0;
            this.firstApplied = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delete() {
        this.close();
        try {
            this.log.trace("deleting DB directory: %s", new Object[]{this.dbFileName});
            FileUtils.deleteDirectory((File)this.dbFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int currentTerm() {
        return this.currentTerm;
    }

    @Override
    public Log currentTerm(int new_term) {
        this.currentTerm = new_term;
        this.log.trace("Updating current term: %d", new Object[]{this.currentTerm});
        this.db.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(this.currentTerm));
        return this;
    }

    @Override
    public Address votedFor() {
        return this.votedFor;
    }

    @Override
    public Log votedFor(Address member) {
        this.votedFor = member;
        try {
            this.log.debug("Updating Voted for: %s", new Object[]{this.votedFor});
            this.db.put(VOTEDFOR, Util.objectToByteBuffer((Object)member));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public int firstApplied() {
        return this.firstApplied;
    }

    @Override
    public int commitIndex() {
        return this.commitIndex;
    }

    @Override
    public Log commitIndex(int new_index) {
        this.commitIndex = new_index;
        this.log.trace("Updating commit index: %d", new Object[]{this.commitIndex});
        this.db.put(COMMITINDEX, IntegerHelper.fromIntToByteArray(this.commitIndex));
        return this;
    }

    @Override
    public int lastApplied() {
        return this.lastApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(int index, boolean overwrite, LogEntry ... entries) {
        WriteBatch batch = this.db.createWriteBatch();
        this.log.trace("Appending %d entries", new Object[]{entries.length});
        try {
            for (LogEntry entry : entries) {
                if (overwrite) {
                    this.appendEntry(index, entry, batch);
                } else {
                    this.appendEntryIfAbsent(index, entry, batch);
                }
                this.updateLastApplied(index, batch);
                this.updateCurrentTerm(entry.term, batch);
                this.log.trace("Flushing batch to DB: %s", new Object[]{batch});
                this.db.write(batch);
                ++index;
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                this.log.trace("Closing batch: %s", new Object[]{batch});
                Util.close((Closeable)batch);
                throw throwable;
            }
            this.log.trace("Closing batch: %s", new Object[]{batch});
            Util.close((Closeable)batch);
        }
        this.log.trace("Closing batch: %s", new Object[]{batch});
        Util.close((Closeable)batch);
    }

    @Override
    public LogEntry get(int index) {
        return this.getLogEntry(index);
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
        start_index = Math.max(start_index, Math.max(this.firstApplied, 1));
        end_index = Math.min(end_index, this.lastApplied);
        for (int i = start_index; i <= end_index; ++i) {
            LogEntry entry = this.getLogEntry(i);
            function.accept(entry, i);
        }
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function) {
        this.forEach(function, Math.max(1, this.firstApplied), this.lastApplied);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(int upto_index) {
        if (upto_index < this.firstApplied || upto_index > this.lastApplied) {
            return;
        }
        WriteBatch batch = null;
        try {
            batch = this.db.createWriteBatch();
            for (int index = this.firstApplied.intValue(); index < upto_index; ++index) {
                batch.delete(IntegerHelper.fromIntToByteArray(index));
            }
            this.firstApplied = upto_index;
            batch.put(FIRSTAPPLIED, IntegerHelper.fromIntToByteArray(upto_index));
            this.db.write(batch);
        }
        finally {
            Util.close((Closeable)batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllEntriesStartingFrom(int start_index) {
        if (start_index < this.firstApplied || start_index > this.lastApplied) {
            return;
        }
        WriteBatch batch = null;
        try {
            batch = this.db.createWriteBatch();
            for (int index = start_index; index <= this.lastApplied; ++index) {
                batch.delete(IntegerHelper.fromIntToByteArray(index));
            }
            LogEntry last = this.getLogEntry(start_index - 1);
            if (last == null) {
                this.updateCurrentTerm(0, batch);
            } else {
                this.updateCurrentTerm(last.term, batch);
            }
            this.updateLastApplied(start_index - 1, batch);
            if (this.commitIndex > this.lastApplied) {
                this.commitIndex(this.lastApplied);
            }
            this.db.write(batch);
        }
        finally {
            Util.close((Closeable)batch);
        }
    }

    public byte[] print(byte[] bytes) {
        return this.db.get(bytes);
    }

    public void printMetadata() throws Exception {
        this.log.info("-----------------");
        this.log.info("RAFT Log Metadata");
        this.log.info("-----------------");
        byte[] firstAppliedBytes = this.db.get(FIRSTAPPLIED);
        this.log.info("First Applied: " + IntegerHelper.fromByteArrayToInt(firstAppliedBytes));
        byte[] lastAppliedBytes = this.db.get(LASTAPPLIED);
        this.log.info("Last Applied: " + IntegerHelper.fromByteArrayToInt(lastAppliedBytes));
        byte[] currentTermBytes = this.db.get(CURRENTTERM);
        this.log.info("Current Term: " + IntegerHelper.fromByteArrayToInt(currentTermBytes));
        byte[] commitIndexBytes = this.db.get(COMMITINDEX);
        this.log.info("Commit Index: " + IntegerHelper.fromByteArrayToInt(commitIndexBytes));
        Address votedFor = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.info("Voted for: " + votedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("firstApplied=").append(this.firstApplied).append(", lastApplied=").append(this.lastApplied).append(", commitIndex=").append(this.commitIndex).append(", currentTerm=").append(this.currentTerm);
        return sb.toString();
    }

    private boolean checkIfPreviousEntryHasDifferentTerm(int prev_index, int prev_term) {
        this.log.trace("Checking term (%d) of previous entry (%d)", new Object[]{prev_term, prev_index});
        if (prev_index == 0) {
            return false;
        }
        LogEntry prev_entry = this.getLogEntry(prev_index);
        return prev_entry == null || prev_entry.term != prev_term;
    }

    private int findIndexWithTerm(int start_index, int prev_term) {
        LogEntry prev_entry = this.getLogEntry(start_index);
        while ((prev_entry == null || prev_entry.term != prev_term) && start_index != this.firstApplied) {
            prev_entry = this.getLogEntry(--start_index);
        }
        return start_index;
    }

    private LogEntry getLogEntry(int index) {
        byte[] entryBytes = this.db.get(IntegerHelper.fromIntToByteArray(index));
        LogEntry entry = null;
        try {
            if (entryBytes != null) {
                entry = (LogEntry)Util.streamableFromByteBuffer(LogEntry.class, (byte[])entryBytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entry;
    }

    private void appendEntryIfAbsent(int index, LogEntry entry, WriteBatch batch) throws Exception {
        if (this.db.get(IntegerHelper.fromIntToByteArray(index)) != null) {
            this.log.trace("Entry %d: %s can't be appended, index already present", new Object[]{index, entry});
            throw new IllegalStateException("Entry at index " + index + " already exists");
        }
        this.appendEntry(index, entry, batch);
    }

    private void appendEntry(int index, LogEntry entry, WriteBatch batch) throws Exception {
        this.log.trace("Appending entry %d: %s", new Object[]{index, entry});
        batch.put(IntegerHelper.fromIntToByteArray(index), Util.streamableToByteBuffer((Streamable)entry));
    }

    private void updateCurrentTerm(int index, WriteBatch batch) {
        this.currentTerm = index;
        this.log.trace("Updating currentTerm: %d", new Object[]{index});
        batch.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(this.currentTerm));
    }

    private void updateLastApplied(int index, WriteBatch batch) {
        this.lastApplied = index;
        this.log.trace("Updating lastApplied: %d", new Object[]{index});
        batch.put(LASTAPPLIED, IntegerHelper.fromIntToByteArray(this.lastApplied));
    }

    private boolean isANewRAFTLog() {
        return this.db.get(FIRSTAPPLIED) == null;
    }

    private void initLogWithMetadata() {
        this.log.debug("Initializing log with empty Metadata");
        WriteBatch batch = this.db.createWriteBatch();
        try {
            batch.put(FIRSTAPPLIED, IntegerHelper.fromIntToByteArray(0));
            batch.put(LASTAPPLIED, IntegerHelper.fromIntToByteArray(0));
            batch.put(CURRENTTERM, IntegerHelper.fromIntToByteArray(0));
            batch.put(COMMITINDEX, IntegerHelper.fromIntToByteArray(0));
            this.db.write(batch);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                batch.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readMetadataFromLog() throws Exception {
        this.firstApplied = IntegerHelper.fromByteArrayToInt(this.db.get(FIRSTAPPLIED));
        this.lastApplied = IntegerHelper.fromByteArrayToInt(this.db.get(LASTAPPLIED));
        this.currentTerm = IntegerHelper.fromByteArrayToInt(this.db.get(CURRENTTERM));
        this.commitIndex = IntegerHelper.fromByteArrayToInt(this.db.get(COMMITINDEX));
        this.votedFor = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.debug("read metadata from log: firstApplied=%d, lastApplied=%d, currentTerm=%d, commitIndex=%d, votedFor=%s", new Object[]{this.firstApplied, this.lastApplied, this.currentTerm, this.commitIndex, this.votedFor});
    }

    private void checkForConsistency() throws Exception {
        int loggedFirstApplied = IntegerHelper.fromByteArrayToInt(this.db.get(FIRSTAPPLIED));
        this.log.trace("FirstApplied in DB is: %d", new Object[]{loggedFirstApplied});
        int loggedLastApplied = IntegerHelper.fromByteArrayToInt(this.db.get(LASTAPPLIED));
        this.log.trace("LastApplied in DB is: %d", new Object[]{loggedLastApplied});
        int loggedCurrentTerm = IntegerHelper.fromByteArrayToInt(this.db.get(CURRENTTERM));
        this.log.trace("CurrentTerm in DB is: %d", new Object[]{loggedCurrentTerm});
        int loggedCommitIndex = IntegerHelper.fromByteArrayToInt(this.db.get(COMMITINDEX));
        this.log.trace("CommitIndex in DB is: %d", new Object[]{loggedCommitIndex});
        Address loggedVotedForAddress = (Address)Util.objectFromByteBuffer((byte[])this.db.get(VOTEDFOR));
        this.log.trace("VotedFor in DB is: %s", new Object[]{loggedVotedForAddress});
        assert (this.firstApplied == loggedFirstApplied);
        assert (this.lastApplied == loggedLastApplied);
        assert (this.currentTerm == loggedCurrentTerm);
        assert (this.commitIndex == loggedCommitIndex);
        if (this.votedFor != null) assert (this.votedFor.equals(loggedVotedForAddress));
        LogEntry lastAppendedEntry = this.getLogEntry(this.lastApplied);
        assert (lastAppendedEntry == null || lastAppendedEntry.term == this.currentTerm);
    }
}

