/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;

public class MapDBLog
implements Log {
    protected DB db;
    protected String filename;
    protected Atomic.Integer current_term;
    protected Atomic.Integer last_applied;
    protected Atomic.Integer commit_index;
    protected Atomic.Var<Address> voted_for;
    protected BTreeMap<Integer, LogEntry> log_entries;
    protected static final String CURRENT_TERM = "current_term";
    protected static final String LAST_APPLIED = "last_applied";
    protected static final String COMMIT_INDEX = "commit_index";
    protected static final String VOTED_FOR = "voted_for";
    protected static final String LOG_ENTRIES = "log_entries";

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        String dir = Util.checkForMac() ? File.separator + "tmp" : System.getProperty("java.io.tmpdir", File.separator + "tmp");
        this.filename = dir + File.separator + log_name;
        this.db = DBMaker.newFileDB((File)new File(this.filename)).closeOnJvmShutdown().make();
        this.current_term = this.db.getAtomicInteger(CURRENT_TERM);
        this.last_applied = this.db.getAtomicInteger(LAST_APPLIED);
        this.commit_index = this.db.getAtomicInteger(COMMIT_INDEX);
        this.voted_for = this.db.exists(VOTED_FOR) ? this.db.getAtomicVar(VOTED_FOR) : this.db.createAtomicVar(VOTED_FOR, null, new StreamableSerializer<Address>(Address.class));
        this.log_entries = this.db.exists(LOG_ENTRIES) ? this.db.getTreeMap(LOG_ENTRIES) : this.db.createTreeMap(LOG_ENTRIES).valueSerializer(new StreamableSerializer<LogEntry>(LogEntry.class)).make();
    }

    @Override
    public void close() {
        this.db.close();
    }

    @Override
    public void delete() {
        this.db.getCatalog().clear();
        this.db.commit();
    }

    @Override
    public int currentTerm() {
        return this.current_term.get();
    }

    @Override
    public Log currentTerm(int new_term) {
        this.current_term.set(new_term);
        this.db.commit();
        return this;
    }

    @Override
    public Address votedFor() {
        return (Address)this.voted_for.get();
    }

    @Override
    public Log votedFor(Address member) {
        this.voted_for.set((Object)member);
        this.db.commit();
        return this;
    }

    @Override
    public int firstApplied() {
        return 0;
    }

    @Override
    public int commitIndex() {
        return this.commit_index.get();
    }

    @Override
    public Log commitIndex(int new_index) {
        this.commit_index.set(new_index);
        return this;
    }

    @Override
    public int lastApplied() {
        return this.last_applied.get();
    }

    @Override
    public void append(int index, boolean overwrite, LogEntry ... entries) {
        if (!overwrite && this.log_entries.containsKey((Object)index)) {
            throw new IllegalStateException("entry at index " + index + " already exists");
        }
        for (LogEntry entry : entries) {
            this.log_entries.put((Object)index, (Object)entry);
        }
        this.last_applied.set(index);
        this.db.commit();
    }

    @Override
    public LogEntry get(int index) {
        return null;
    }

    @Override
    public void truncate(int index) {
    }

    @Override
    public void deleteAllEntriesStartingFrom(int start_index) {
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function, int start_index, int end_index) {
    }

    @Override
    public void forEach(ObjIntConsumer<LogEntry> function) {
    }

    protected static class StreamableSerializer<T>
    implements Serializer<T>,
    Serializable {
        private static final long serialVersionUID = 7230936820893354049L;
        protected final Class<T> clazz;

        public StreamableSerializer(Class<T> clazz) {
            this.clazz = clazz;
            if (clazz.isAssignableFrom(Streamable.class)) {
                throw new IllegalArgumentException("argument (" + clazz.getSimpleName() + ") has to be Streamable");
            }
        }

        public void serialize(DataOutput out, T value) throws IOException {
            try {
                Util.writeStreamable((Streamable)((Streamable)value), (DataOutput)out);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        public T deserialize(DataInput in, int available) throws IOException {
            try {
                return (T)Util.readStreamable(this.clazz, (DataInput)in);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        public int fixedSize() {
            return -1;
        }
    }
}

