/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.util.Arrays;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

@MBean(description="Rejects views with duplicate members (identical raft-ids)")
public class NO_DUPES
extends Protocol {
    protected static final short gms_id = ClassConfigurator.getProtocolId(GMS.class);
    protected volatile View view;

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.view = (View)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        Message msg;
        GMS.GmsHeader hdr;
        if (evt.getType() == 1 && (hdr = (GMS.GmsHeader)(msg = (Message)evt.getArg()).getHeader(gms_id)) != null && !this.handleGmsHeader(hdr, msg.src())) {
            return null;
        }
        return this.up_prot.up(evt);
    }

    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(gms_id);
            if (hdr == null || this.handleGmsHeader(hdr, msg.src())) continue;
            batch.remove(msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected boolean handleGmsHeader(GMS.GmsHeader hdr, Address sender) {
        switch (hdr.getType()) {
            case 1: 
            case 11: {
                Address joiner = hdr.getMember();
                if (!(joiner instanceof ExtendedUUID)) {
                    this.log.error("joiner needs to have an ExtendedUUID but has a " + joiner.getClass().getSimpleName());
                    break;
                }
                View v = this.view;
                if (!NO_DUPES.contains(v, (ExtendedUUID)joiner)) break;
                String msg = String.format("join of %s rejected as it would create a view with duplicate members (current view: %s)", joiner, v);
                this.log.warn(msg);
                this.sendJoinRejectedMessageTo(sender, msg);
                return false;
            }
        }
        return true;
    }

    protected static boolean contains(View v, ExtendedUUID joiner) {
        byte[] raft_id = joiner.get(RAFT.raft_id_key);
        for (Address addr : v) {
            ExtendedUUID uuid;
            byte[] tmp;
            if (!(addr instanceof ExtendedUUID) || !Arrays.equals(raft_id, tmp = (uuid = (ExtendedUUID)addr).get(RAFT.raft_id_key))) continue;
            return true;
        }
        return false;
    }

    protected void sendJoinRejectedMessageTo(Address joiner, String reject_message) {
        try {
            Buffer buffer = Util.streamableToBuffer((Streamable)new JoinRsp(reject_message));
            Message msg = new Message(joiner).setBuffer(buffer).putHeader(gms_id, (Header)new GMS.GmsHeader(2));
            this.down_prot.down(new Event(1, (Object)msg));
        }
        catch (Exception ex) {
            this.log.error("failed sending JoinRsp to %s: %s", new Object[]{joiner, ex});
        }
    }
}

