/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.protocols.raft.AppendEntriesResponse;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;

public abstract class RaftImpl {
    protected RAFT raft;

    public RaftImpl(RAFT raft) {
        this.raft = raft;
    }

    public RAFT raft() {
        return this.raft;
    }

    public RaftImpl raft(RAFT r) {
        this.raft = r;
        return this;
    }

    public void init() {
    }

    public void destroy() {
    }

    protected AppendResult handleAppendEntriesRequest(byte[] data, int offset, int length, Address leader, int prev_log_index, int prev_log_term, int entry_term, int leader_commit, boolean internal) {
        this.raft.leader(leader);
        if (data == null || length == 0) {
            this.handleCommitRequest(leader, leader_commit);
            return null;
        }
        LogEntry prev = this.raft.log_impl.get(prev_log_index);
        int curr_index = prev_log_index + 1;
        if (prev == null && prev_log_index > 0) {
            return new AppendResult(false, this.raft.lastApplied());
        }
        if (prev_log_index == 0 || prev.term == prev_log_term) {
            LogEntry existing = this.raft.log_impl.get(curr_index);
            if (existing != null && existing.term != entry_term) {
                this.raft.deleteAllLogEntriesStartingFrom(curr_index);
            }
            this.raft.append(entry_term, curr_index, data, offset, length, internal).commitLogTo(leader_commit);
            if (internal) {
                this.raft.executeInternalCommand(null, data, offset, length);
            }
            return new AppendResult(true, curr_index).commitIndex(this.raft.commitIndex());
        }
        return new AppendResult(false, this.getFirstIndexOfConflictingTerm(prev_log_index, prev.term), prev.term);
    }

    protected void handleAppendEntriesResponse(Address sender, int term, AppendResult result) {
    }

    protected void handleInstallSnapshotRequest(Message msg, int term, Address leader, int last_included_index, int last_included_term) {
    }

    protected int getFirstIndexOfConflictingTerm(int start_index, int conflicting_term) {
        LogEntry entry;
        int retval;
        Log log = this.raft.log_impl;
        int first = Math.max(1, log.firstApplied());
        int last = log.lastApplied();
        int i = retval = Math.min(start_index, last);
        while (i >= first && (entry = log.get(i)) != null && entry.term == conflicting_term) {
            retval = i--;
        }
        return retval;
    }

    protected void handleCommitRequest(Address sender, int leader_commit) {
        this.raft.commitLogTo(leader_commit);
        AppendResult result = new AppendResult(true, this.raft.lastApplied()).commitIndex(this.raft.commitIndex());
        Message msg = new Message(sender).putHeader(this.raft.getId(), (Header)new AppendEntriesResponse(this.raft.currentTerm(), result));
        this.raft.getDownProtocol().down(new Event(1, (Object)msg));
    }
}

