/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.InternalCommand;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.RaftHandle;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class ReplicatedStateMachine<K, V>
implements StateMachine {
    protected JChannel ch;
    protected RaftHandle raft;
    protected long repl_timeout = 20000L;
    protected final List<Notification> listeners = new ArrayList<Notification>();
    protected final Map<K, V> map = new HashMap();
    protected static final byte PUT = 1;
    protected static final byte REMOVE = 2;

    public ReplicatedStateMachine(JChannel ch) {
        this.ch = ch;
        this.raft = new RaftHandle((Channel)this.ch, this);
    }

    public ReplicatedStateMachine timeout(long timeout) {
        this.repl_timeout = timeout;
        return this;
    }

    public void addRoleChangeListener(RAFT.RoleChange listener) {
        this.raft.addRoleListener(listener);
    }

    public void addNotificationListener(Notification n) {
        if (n != null) {
            this.listeners.add(n);
        }
    }

    public void removeNotificationListener(Notification n) {
        this.listeners.remove(n);
    }

    public void removeRoleChangeListener(RAFT.RoleChange listener) {
        this.raft.removeRoleListener(listener);
    }

    public int lastApplied() {
        return this.raft.lastApplied();
    }

    public int commitIndex() {
        return this.raft.commitIndex();
    }

    public JChannel channel() {
        return this.ch;
    }

    public void snapshot() throws Exception {
        if (this.raft != null) {
            this.raft.snapshot();
        }
    }

    public int logSize() {
        return this.raft != null ? this.raft.logSizeInBytes() : 0;
    }

    public String raftId() {
        return this.raft.raftId();
    }

    public ReplicatedStateMachine<K, V> raftId(String id) {
        this.raft.raftId(id);
        return this;
    }

    public void dumpLog() {
        this.raft.logEntries((entry, index) -> {
            StringBuilder sb = new StringBuilder().append(index).append(" (").append(entry.term()).append("): ");
            if (entry.command() == null) {
                sb.append("<marker record>");
                System.out.println(sb);
                return;
            }
            if (entry.internal()) {
                try {
                    InternalCommand cmd = (InternalCommand)Util.streamableFromByteBuffer(InternalCommand.class, (byte[])entry.command(), (int)entry.offset(), (int)entry.length());
                    sb.append("[internal] ").append(cmd).append("\n");
                }
                catch (Exception ex) {
                    sb.append("[failure reading internal cmd] ").append(ex).append("\n");
                }
                System.out.println(sb);
                return;
            }
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(entry.command(), entry.offset(), entry.length());
            try {
                byte type = in.readByte();
                switch (type) {
                    case 1: {
                        Object key = Util.objectFromStream((DataInput)in);
                        Object val = Util.objectFromStream((DataInput)in);
                        sb.append("put(").append(key).append(", ").append(val).append(")");
                        break;
                    }
                    case 2: {
                        Object key = Util.objectFromStream((DataInput)in);
                        sb.append("remove(").append(key).append(")");
                        break;
                    }
                    default: {
                        sb.append("type " + type + " is unknown");
                        break;
                    }
                }
            }
            catch (Throwable t) {
                sb.append(t);
            }
            System.out.println(sb);
        });
    }

    public boolean equals(Object obj) {
        return this.map.equals(((ReplicatedStateMachine)obj).map);
    }

    public V put(K key, V val) throws Exception {
        return this.invoke((byte)1, key, val, false);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public V remove(K key) throws Exception {
        return this.invoke((byte)2, key, null, true);
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public byte[] apply(byte[] data, int offset, int length) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, offset, length);
        byte command = in.readByte();
        switch (command) {
            case 1: {
                Object key = Util.objectFromStream((DataInput)in);
                Object val = Util.objectFromStream((DataInput)in);
                Object old_val = this.map.put(key, val);
                this.notifyPut(key, val, old_val);
                return old_val == null ? null : Util.objectToByteBuffer((Object)old_val);
            }
            case 2: {
                Object key = Util.objectFromStream((DataInput)in);
                V old_val = this.map.remove(key);
                this.notifyRemove(key, old_val);
                return old_val == null ? null : Util.objectToByteBuffer(old_val);
            }
        }
        throw new IllegalArgumentException("command " + command + " is unknown");
    }

    @Override
    public void readContentFrom(DataInput in) throws Exception {
        int size = Bits.readInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            Object key = Util.objectFromStream((DataInput)in);
            Object val = Util.objectFromStream((DataInput)in);
            this.map.put(key, val);
        }
    }

    @Override
    public void writeContentTo(DataOutput out) throws Exception {
        int size = this.map.size();
        Bits.writeInt((int)size, (DataOutput)out);
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            Util.objectToStream(entry.getKey(), (DataOutput)out);
            Util.objectToStream(entry.getValue(), (DataOutput)out);
        }
    }

    public String toString() {
        return this.map.toString();
    }

    protected V invoke(byte command, K key, V val, boolean ignore_return_value) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(256);
        try {
            out.writeByte((int)command);
            Util.objectToStream(key, (DataOutput)out);
            if (val != null) {
                Util.objectToStream(val, (DataOutput)out);
            }
        }
        catch (Exception ex) {
            throw new Exception("serialization failure (key=" + key + ", val=" + val + ")", ex);
        }
        byte[] buf = out.buffer();
        byte[] rsp = this.raft.set(buf, 0, out.position(), this.repl_timeout, TimeUnit.MILLISECONDS);
        return (V)(ignore_return_value ? null : Util.objectFromByteBuffer((byte[])rsp));
    }

    protected void notifyPut(K key, V val, V old_val) {
        for (Notification n : this.listeners) {
            try {
                n.put(key, val, old_val);
            }
            catch (Throwable t) {}
        }
    }

    protected void notifyRemove(K key, V old_val) {
        for (Notification n : this.listeners) {
            try {
                n.remove(key, old_val);
            }
            catch (Throwable t) {}
        }
    }

    public static interface Notification<K, V> {
        public void put(K var1, V var2, V var3);

        public void remove(K var1, V var2);
    }
}

