/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;
import org.testng.IConfigurationListener2;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class JUnitXMLReporter
implements ITestListener,
IConfigurationListener2 {
    protected String output_dir = null;
    protected static final String XML_DEF = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    protected static final String CDATA = "![CDATA[";
    protected static final String LT = "&lt;";
    protected static final String GT = "&gt;";
    protected static final String SYSTEM_OUT = "system-out";
    protected static final String SYSTEM_ERR = "system-err";
    protected static final String TESTS = "tests.data";
    protected static final String STDOUT = "stdout.txt";
    protected static final String STDERR = "stderr.txt";
    protected PrintStream old_stdout = System.out;
    protected PrintStream old_stderr = System.err;
    protected final ConcurrentMap<Class<?>, DataOutputStream> tests = new ConcurrentHashMap(100);
    public static final InheritableThreadLocal<PrintStream> stdout = new InheritableThreadLocal();
    public static final InheritableThreadLocal<PrintStream> stderr = new InheritableThreadLocal();

    public void onStart(ITestContext context) {
        this.output_dir = context.getOutputDirectory();
        File dir = new File(this.output_dir);
        if (dir.exists()) {
            JUnitXMLReporter.deleteContents(dir);
        }
        try {
            System.setOut(new MyOutput(1));
            System.setErr(new MyOutput(2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ITestContext context) {
        try {
            for (DataOutputStream out : this.tests.values()) {
                Util.close((Closeable)out);
            }
            this.tests.clear();
            this.generateReports();
        }
        catch (IOException e) {
            this.error(e.toString());
        }
        finally {
            System.setOut(this.old_stdout);
            System.setErr(this.old_stderr);
        }
    }

    public void onTestStart(ITestResult result) {
        this.setupStreams(result, true);
    }

    public void onTestSuccess(ITestResult tr) {
        this.onTestCompleted(tr, "OK:   ", this.old_stdout);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.onTestCompleted(tr, "OK:   ", this.old_stdout);
    }

    public void onTestFailure(ITestResult tr) {
        this.onTestCompleted(tr, "FAIL: ", this.old_stderr);
    }

    public void onTestSkipped(ITestResult tr) {
        this.onTestCompleted(tr, "SKIP: ", this.old_stderr);
    }

    public void beforeConfiguration(ITestResult tr) {
        this.setupStreams(tr, false);
    }

    public void onConfigurationSuccess(ITestResult tr) {
        JUnitXMLReporter.closeStreams();
    }

    public void onConfigurationFailure(ITestResult tr) {
        this.error("failed config: " + tr.getThrowable());
        this.onTestCompleted(tr, "FAIL: ", this.old_stderr);
    }

    public void onConfigurationSkip(ITestResult tr) {
        JUnitXMLReporter.closeStreams();
    }

    protected void onTestCompleted(ITestResult tr, String message, PrintStream out) {
        Class real_class = tr.getTestClass().getRealClass();
        this.addTest(real_class, tr);
        JUnitXMLReporter.print(out, message, real_class.getName(), JUnitXMLReporter.getMethodName(tr));
        JUnitXMLReporter.closeStreams();
    }

    protected void setupStreams(ITestResult result, boolean printMethodName) {
        String test_name = result.getTestClass().getName();
        File dir = new File(this.output_dir + File.separator + test_name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File _tests = new File(dir, TESTS);
        File _stdout = new File(dir, STDOUT);
        File _stderr = new File(dir, STDERR);
        try {
            DataOutputStream output;
            DataOutputStream tmp;
            Class clazz = result.getTestClass().getRealClass();
            if (!this.tests.containsKey(clazz) && (tmp = this.tests.putIfAbsent(clazz, output = new DataOutputStream(new FileOutputStream(_tests, true)))) != null) {
                Util.close((Closeable)output);
                output = tmp;
            }
            if (stdout.get() == null) {
                stdout.set(new PrintStream(new FileOutputStream(_stdout, true)));
            }
            if (stderr.get() == null) {
                stderr.set(new PrintStream(new FileOutputStream(_stderr, true)));
            }
            if (printMethodName) {
                ((PrintStream)stdout.get()).println("\n\n------------- " + JUnitXMLReporter.getMethodName(result) + " -----------");
            }
        }
        catch (IOException e) {
            this.error(e.toString());
        }
    }

    protected static void closeStreams() {
        Util.close((Closeable)((Closeable)stdout.get()));
        stdout.set(null);
        Util.close((Closeable)((Closeable)stderr.get()));
        stderr.set(null);
    }

    protected static void print(PrintStream out, String msg, String classname, String method_name) {
        out.println(msg + "[" + Thread.currentThread().getId() + "] " + classname + "." + method_name + "()");
    }

    protected void error(String msg) {
        this.old_stderr.println(msg);
    }

    protected void println(String msg) {
        this.old_stdout.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTest(Class<?> clazz, ITestResult result) {
        try {
            TestCase test_case = new TestCase(result.getStatus(), clazz.getName(), JUnitXMLReporter.getMethodName(result), result.getStartMillis(), result.getEndMillis());
            switch (result.getStatus()) {
                case 2: 
                case 3: {
                    Throwable ex = result.getThrowable();
                    if (ex != null) {
                        String failure_type = ex.getClass().getName();
                        String failure_msg = ex.getMessage();
                        String stack_trace = JUnitXMLReporter.printException(ex);
                        test_case.setFailure(failure_type, failure_msg, stack_trace);
                        break;
                    }
                    test_case.setFailure("exception", "SKIPPED", null);
                }
            }
            JUnitXMLReporter jUnitXMLReporter = this;
            synchronized (jUnitXMLReporter) {
                DataOutputStream output = (DataOutputStream)this.tests.get(clazz);
                test_case.writeTo(output);
            }
        }
        catch (Exception e) {
            this.error(e.toString());
        }
    }

    protected static String getMethodName(ITestResult tr) {
        String method_name = tr.getName();
        Object[] params = tr.getParameters();
        if (params != null && params.length > 0) {
            String tmp = null;
            if (params[0] instanceof Class) {
                tmp = ((Class)params[0]).getSimpleName();
            } else if (params[0] != null) {
                tmp = params[0].getClass().getSimpleName();
            }
            if (tmp != null) {
                method_name = method_name + "-" + tmp;
            }
        }
        return method_name;
    }

    protected void generateReports() throws IOException {
        File root_dir = new File(this.output_dir);
        if (!root_dir.exists()) {
            throw new IOException(root_dir + " not found");
        }
        File[] subdirs = root_dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (subdirs != null) {
            for (File dir : subdirs) {
                try {
                    JUnitXMLReporter.process(dir);
                }
                catch (Throwable e) {
                    this.error(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected static void process(File dir) throws IOException {
        file = new File(dir, "tests.data");
        if (!file.exists()) {
            throw new IOException(file + " not found");
        }
        test_cases = new ArrayList<TestCase>();
        input = new DataInputStream(new FileInputStream(file));
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                test_case = new TestCase();
                try {
                    test_case.readFrom(input);
                    test_cases.add(test_case);
                    continue;
                }
                catch (Exception e) {
                    Util.close((Closeable)input);
                }
                break;
            }
        }
        catch (Throwable var6_7) {
            Util.close((Closeable)input);
            throw var6_7;
        }
        {
            ** while (true)
        }
        if (test_cases.isEmpty()) {
            return;
        }
        stdout_reader = null;
        stderr_reader = null;
        tmp = new File(dir, "stdout.txt");
        if (tmp.exists() && tmp.length() > 0L) {
            stdout_reader = new FileReader(tmp);
        }
        if ((tmp = new File(dir, "stderr.txt")).exists() && tmp.length() > 0L) {
            stderr_reader = new FileReader(tmp);
        }
        parent = dir.getParentFile();
        xml_file = new File(parent, "TESTS-" + dir.getName() + "-" + parent.getName() + ".xml");
        out = new FileWriter(xml_file);
        classname = dir.getName();
        suffix = parent.getName();
        if (suffix != null && !suffix.isEmpty()) {
            classname = classname + "-" + suffix;
        }
        try {
            JUnitXMLReporter.generateReport(out, classname, test_cases, stdout_reader, stderr_reader);
        }
        finally {
            out.close();
            if (stdout_reader != null) {
                stdout_reader.close();
            }
            if (stderr_reader != null) {
                stderr_reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void generateReport(Writer out, String classname, List<TestCase> results, Reader stdout, Reader stderr) throws IOException {
        int num_failures = JUnitXMLReporter.getFailures(results);
        int num_skips = JUnitXMLReporter.getSkips(results);
        int num_errors = JUnitXMLReporter.getErrors(results);
        long total_time = JUnitXMLReporter.getTotalTime(results);
        try {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            out.write("\n<testsuite name=\"" + classname + "\" " + "tests=\"" + results.size() + "\" " + "failures=\"" + num_failures + "\" " + "errors=\"" + num_errors + "\" " + "skips=\"" + num_skips + "\" " + "time=\"" + (double)total_time / 1000.0 + "\">");
            out.write("\n<properties>");
            Properties props = System.getProperties();
            for (Map.Entry<Object, Object> tmp : props.entrySet()) {
                out.write("\n    <property name=\"" + tmp.getKey() + "\"" + " value=\"" + tmp.getValue() + "\"/>");
            }
            out.write("\n</properties>\n");
            for (TestCase result : results) {
                if (result == null) continue;
                try {
                    JUnitXMLReporter.writeTestCase(out, result);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (stdout != null) {
                JUnitXMLReporter.writeOutput(1, stdout, out);
            }
            if (stderr != null) {
                JUnitXMLReporter.writeOutput(2, stderr, out);
            }
        }
        finally {
            out.write("\n</testsuite>\n");
        }
    }

    protected static void writeTestCase(Writer out, TestCase result) throws IOException {
        long time = result.stop_time - result.start_time;
        out.write("\n    <testcase classname=\"" + result.classname);
        out.write("\"  name=\"" + result.name + "\" time=\"" + (double)time / 1000.0 + "\">");
        switch (result.status) {
            case 2: {
                String failure = JUnitXMLReporter.writeFailure("failure", result.failure_type, result.failure_msg, result.stack_trace);
                if (failure == null) break;
                out.write(failure);
                break;
            }
            case 3: {
                String failure = JUnitXMLReporter.writeFailure("error", result.failure_type, result.failure_msg, result.stack_trace);
                if (failure == null) break;
                out.write(failure);
            }
        }
        out.write("\n    </testcase>\n");
    }

    protected static void writeOutput(int type, Reader in, Writer out) throws IOException {
        out.write("\n<" + (type == 2 ? SYSTEM_ERR : SYSTEM_OUT) + "><" + CDATA + "\n");
        JUnitXMLReporter.copy(in, out);
        out.write("\n]]>");
        out.write("\n</" + (type == 2 ? SYSTEM_ERR : SYSTEM_OUT) + ">");
    }

    protected static String getStatus(TestCase tr) {
        switch (tr.status) {
            case 1: 
            case 4: {
                return "OK";
            }
            case 2: {
                return "FAIL";
            }
            case 3: {
                return "SKIP";
            }
        }
        return "UNKNOWN";
    }

    protected static String writeFailure(String type, String failure_type, String failure_msg, String stack_trace) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n        <" + type + " type=\"").append(failure_type);
        sb.append("\" message=\"" + JUnitXMLReporter.escape(failure_msg) + "\">");
        if (stack_trace != null) {
            sb.append(stack_trace);
        }
        sb.append("\n        </" + type + ">");
        return sb.toString();
    }

    protected static String printException(Throwable ex) throws IOException {
        if (ex == null) {
            return null;
        }
        StackTraceElement[] stack_trace = ex.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append("\n<![CDATA[\n");
        sb.append(ex.getClass().getName() + " \n");
        for (int i = 0; i < stack_trace.length; ++i) {
            StackTraceElement frame = stack_trace[i];
            sb.append("at " + frame.toString() + " \n");
        }
        sb.append("\n]]>");
        return sb.toString();
    }

    protected static String escape(String message) {
        return message != null ? message.replaceAll("<", LT).replaceAll(">", GT) : message;
    }

    public static long getTotalTime(Collection<TestCase> results) {
        long start = 0L;
        long stop = 0L;
        for (TestCase result : results) {
            if (result == null) continue;
            long tmp_start = result.start_time;
            long tmp_stop = result.stop_time;
            start = start == 0L ? tmp_start : Math.min(start, tmp_start);
            if (stop == 0L) {
                stop = tmp_stop;
                continue;
            }
            stop = Math.max(stop, tmp_stop);
        }
        return stop - start;
    }

    public static int getFailures(Collection<TestCase> results) {
        int retval = 0;
        for (TestCase result : results) {
            if (result == null || result.status != 2) continue;
            ++retval;
        }
        return retval;
    }

    public static int getErrors(Collection<TestCase> results) {
        int retval = 0;
        for (TestCase result : results) {
            if (result == null || result.status == 1 || result.status == 4 || result.status == 2) continue;
            ++retval;
        }
        return retval;
    }

    public static int getSkips(Collection<TestCase> results) {
        int retval = 0;
        for (TestCase result : results) {
            if (result == null || result.status != 3) continue;
            ++retval;
        }
        return retval;
    }

    protected static void deleteContents(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                if (file.isDirectory()) {
                    JUnitXMLReporter.deleteContents(file);
                    file.delete();
                    continue;
                }
                file.delete();
            }
        }
    }

    protected static int copy(Reader in, Writer out) {
        int count = 0;
        char[] buf = new char[1024];
        try {
            int num;
            while ((num = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, num);
                count += num;
            }
        }
        catch (IOException e) {
        }
        return count;
    }

    public static void main(String[] args) throws IOException {
        JUnitXMLReporter reporter = new JUnitXMLReporter();
        reporter.output_dir = "/home/bela/JGroups/tmp/test-results/xml/udp";
        reporter.generateReports();
    }

    public static class TestCase
    implements Streamable {
        protected int status;
        protected String classname;
        protected String name;
        protected long start_time;
        protected long stop_time;
        protected String failure_type;
        protected String failure_msg;
        protected String stack_trace;

        public TestCase() {
        }

        public TestCase(int status, String classname, String name, long start_time, long stop_time) {
            this.status = status;
            this.classname = classname;
            this.name = name;
            this.start_time = start_time;
            this.stop_time = stop_time;
        }

        public void setFailure(String failure_type, String failure_msg, String stack_trace) {
            this.failure_type = failure_type;
            this.failure_msg = failure_msg;
            this.stack_trace = stack_trace;
        }

        public long getTime() {
            return this.stop_time - this.start_time;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(TestCase.statusToString(this.status)).append(" ").append(this.classname).append(".").append(this.name).append(" in ").append(this.getTime()).append(" ms");
            if (this.failure_type != null) {
                sb.append("\n" + this.failure_type).append(" msg=" + this.failure_msg).append("\n").append(this.stack_trace);
            }
            return sb.toString();
        }

        protected static String statusToString(int status) {
            switch (status) {
                case 1: 
                case 4: {
                    return "OK";
                }
                case 2: {
                    return "FAIL";
                }
                case 3: {
                    return "SKIP";
                }
            }
            return "N/A";
        }

        public void writeTo(DataOutput out) throws Exception {
            out.writeInt(this.status);
            Bits.writeString((String)this.classname, (DataOutput)out);
            Bits.writeString((String)this.name, (DataOutput)out);
            out.writeLong(this.start_time);
            out.writeLong(this.stop_time);
            Bits.writeString((String)this.failure_type, (DataOutput)out);
            Bits.writeString((String)this.failure_msg, (DataOutput)out);
            Bits.writeString((String)this.stack_trace, (DataOutput)out);
        }

        public void readFrom(DataInput in) throws Exception {
            this.status = in.readInt();
            this.classname = Bits.readString((DataInput)in);
            this.name = Bits.readString((DataInput)in);
            this.start_time = in.readLong();
            this.stop_time = in.readLong();
            this.failure_type = Bits.readString((DataInput)in);
            this.failure_msg = Bits.readString((DataInput)in);
            this.stack_trace = Bits.readString((DataInput)in);
        }
    }

    protected static class MyOutput
    extends PrintStream {
        private static final String TMPFILE_NAME = Util.checkForWindows() ? System.getProperty("java.io.tmpdir") + "\\" + "tmp.txt" : System.getProperty("java.io.tmpdir") + "/" + "tmp.txt";
        final int type;

        public MyOutput(int type) throws FileNotFoundException {
            super(TMPFILE_NAME);
            this.type = type;
            if (type != 1 && type != 2) {
                throw new IllegalArgumentException("index has to be 1 or 2");
            }
        }

        @Override
        public void write(byte[] b) {
            String s = new String(b);
            this.append(s.trim(), false);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            String s = new String(b, off, len);
            this.append(s.trim(), false);
        }

        @Override
        public void write(int b) {
            this.append(String.valueOf(b), false);
        }

        @Override
        public void flush() {
            this.append("", true);
        }

        @Override
        public void println(String s) {
            this.append(s, true);
        }

        @Override
        public void print(String s) {
            this.append(s, false);
        }

        @Override
        public void print(Object obj) {
            if (obj != null) {
                this.append(obj.toString(), false);
            } else {
                this.append("null", false);
            }
        }

        @Override
        public void println(Object obj) {
            if (obj != null) {
                this.append(obj.toString(), true);
            } else {
                this.append("null", true);
            }
        }

        protected synchronized void append(String x, boolean newline) {
            PrintStream tmp;
            PrintStream printStream = tmp = this.type == 1 ? (PrintStream)stdout.get() : (PrintStream)stderr.get();
            if (tmp == null) {
                return;
            }
            if (newline) {
                tmp.println(x);
            } else {
                tmp.print(x);
            }
        }
    }
}

