/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class RequestTable<T> {
    protected final Map<Integer, Entry<T>> requests = new HashMap<Integer, Entry<T>>();

    public synchronized void create(int index, T vote, CompletableFuture<byte[]> future) {
        Entry<T> entry = new Entry<T>(future, vote);
        this.requests.put(index, entry);
    }

    public synchronized boolean add(int index, T sender, int majority) {
        Entry<T> entry = this.requests.get(index);
        return entry != null && entry.add(sender, majority);
    }

    public synchronized boolean isCommitted(int index) {
        Entry<T> entry = this.requests.get(index);
        return entry != null && entry.committed;
    }

    public synchronized void notifyAndRemove(int index, byte[] response, int offset, int length) {
        Entry<T> entry = this.requests.get(index);
        if (entry != null) {
            byte[] value = response;
            if (response != null && offset > 0) {
                value = new byte[length];
                System.arraycopy(response, offset, value, 0, length);
            }
            if (entry.client_future != null) {
                entry.client_future.complete(value);
            }
            this.requests.remove(index);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Entry<T>> entry : this.requests.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    protected static class Entry<T> {
        protected final CompletableFuture<byte[]> client_future;
        protected final Set<T> votes = new HashSet<T>();
        protected boolean committed;

        public Entry(CompletableFuture<byte[]> client_future, T vote) {
            this.client_future = client_future;
            this.votes.add(vote);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean add(T vote, int majority) {
            if (!this.votes.add(vote)) return false;
            if (this.votes.size() < majority) return false;
            boolean bl = true;
            boolean reached_majority = bl;
            if (!reached_majority) return false;
            if (this.committed) return false;
            this.committed = true;
            if (!true) return false;
            return true;
        }

        public String toString() {
            return "committed=" + this.committed + ", votes=" + this.votes;
        }
    }
}

