/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.AppendResult;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.REDIRECT;
import org.jgroups.protocols.raft.RaftImpl;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.raft.blocks.ReplicatedStateMachine;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true)
public class AppendEntriesTest {
    protected JChannel a;
    protected JChannel b;
    protected JChannel c;
    protected ReplicatedStateMachine<Integer, Integer> as;
    protected ReplicatedStateMachine<Integer, Integer> bs;
    protected ReplicatedStateMachine<Integer, Integer> cs;
    protected static final Method handleAppendEntriesRequest;
    protected static final String CLUSTER = "AppendEntriesTest";
    protected static final List<String> members;

    @AfterMethod
    protected void destroy() {
        this.close(true, true, this.c, this.b, this.a);
    }

    public void testNormalOperation() throws Exception {
        this.init(true);
        for (int i = 1; i <= 10; ++i) {
            this.as.put(i, i);
        }
        this.assertSame(this.as, this.bs, this.cs);
        this.bs.remove(5);
        this.cs.put(11, 11);
        this.cs.remove(1);
        this.as.put(1, 1);
        this.assertSame(this.as, this.bs, this.cs);
    }

    public void testRedirect() throws Exception {
        this.init(true);
        this.cs.put(5, 5);
        this.assertSame(this.as, this.bs, this.cs);
    }

    public void testPutWithoutLeader() throws Exception {
        this.a = this.create("A", false);
        this.as = new ReplicatedStateMachine(this.a);
        this.a.connect(CLUSTER);
        assert (!this.isLeader(this.a));
        try {
            this.as.put(1, 1);
            assert (false) : "put() should fail as we don't have a leader";
        }
        catch (Throwable t) {
            System.out.println("received exception as expected: " + t);
        }
    }

    public void testNonCommitWithoutMajority() throws Exception {
        this.init(true);
        this.close(true, true, this.b, this.c);
        this.as.timeout(500L);
        for (int i = 1; i <= 3; ++i) {
            try {
                this.as.put(i, i);
            }
            catch (TimeoutException ex) {
                System.out.println("received " + ex.getClass().getSimpleName() + " as expected; cache size is " + this.as.size());
            }
            assert (this.as.size() == 0);
        }
    }

    public void testCatchingUp() throws Exception {
        int i;
        this.init(true);
        for (i = 1; i <= 2; ++i) {
            this.as.put(i, i);
        }
        this.assertSame(this.as, this.bs, this.cs);
        this.close(true, true, this.c);
        for (i = 3; i <= 5; ++i) {
            this.as.put(i, i);
        }
        this.assertSame(this.as, this.bs);
        this.c = this.create("C", true);
        this.cs = new ReplicatedStateMachine(this.c);
        this.c.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b, this.c});
        this.assertSame(this.as, this.bs, this.cs);
    }

    public void testCatchingUpFirstEntry() throws Exception {
        this.init(false);
        this.close(true, true, this.b, this.c);
        this.as.timeout(500L);
        try {
            this.as.put(1, 1);
            assert (false) : "should have gotten a TimeoutException";
        }
        catch (TimeoutException ex) {
            System.out.println("The first put() timed out as expected as there's no majority to commit it");
        }
        RAFT raft = (RAFT)this.a.getProtocolStack().findProtocol(RAFT.class);
        System.out.printf("A: last-applied=%d, commit-index=%d\n", raft.lastApplied(), raft.commitIndex());
        assert (raft.lastApplied() == 1);
        assert (raft.commitIndex() == 0);
        this.b = this.create("B", true);
        this.bs = new ReplicatedStateMachine(this.b);
        this.b.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b});
        this.assertCommitIndex(10000L, 500L, raft.lastApplied(), raft.lastApplied(), this.a, this.b);
        for (JChannel ch : Arrays.asList(this.a, this.b)) {
            raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
            System.out.printf("%s: last-applied=%d, commit-index=%d\n", ch.getAddress(), raft.lastApplied(), raft.commitIndex());
            assert (raft.lastApplied() == 1);
            assert (raft.commitIndex() == 1);
        }
        this.assertSame(this.as, this.bs);
    }

    public void testLeaderRestart() throws Exception {
        this.a = this.create("A", false);
        AppendEntriesTest.raft(this.a).stateMachine(new DummyStateMachine());
        this.b = this.create("B", true);
        AppendEntriesTest.raft(this.b).stateMachine(new DummyStateMachine());
        this.a.connect(CLUSTER);
        this.b.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b});
        this.assertLeader(this.a, 10000L, 500L);
        assert (!AppendEntriesTest.raft(this.b).isLeader());
        System.out.println("--> disconnecting B");
        this.b.disconnect();
        try {
            AppendEntriesTest.raft(this.a).set(new byte[]{98, 101, 108, 97}, 0, 4, 500L, TimeUnit.MILLISECONDS);
            assert (false) : "set() should have thrown a timeout as we cannot commit the change";
        }
        catch (TimeoutException ex) {
            System.out.printf("got exception as expected: %s\n", ex);
        }
        this.assertCommitIndex(10000L, 500L, 0, 1, this.a);
        System.out.println("--> restarting B");
        this.b = this.create("B", true);
        AppendEntriesTest.raft(this.b).stateMachine(new DummyStateMachine());
        this.b.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b});
        this.assertCommitIndex(10000L, 500L, 1, 1, this.a, this.b);
    }

    public void testInstallSnapshotInC() throws Exception {
        this.init(true);
        this.close(true, true, this.c);
        for (int i = 1; i <= 5; ++i) {
            this.as.put(i, i);
        }
        this.assertSame(this.as, this.bs);
        this.as.snapshot();
        this.c = this.create("C", true);
        this.cs = new ReplicatedStateMachine(this.c);
        this.c.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b, this.c});
        this.assertSame(this.as, this.bs, this.cs);
    }

    public void testInitialAppends() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        AppendResult result = this.append(impl, 1, 0, new LogEntry(4, buf), leader, 1);
        assert (result.success());
        Assert.assertEquals((int)result.index(), (int)1);
        Assert.assertEquals((int)result.commitIndex(), (int)1);
        this.assertLogIndices(log, 1, 1, 4);
        result = this.append(impl, 2, 4, new LogEntry(4, buf), leader, 1);
        assert (result.success());
        Assert.assertEquals((int)result.index(), (int)2);
        Assert.assertEquals((int)result.commitIndex(), (int)1);
        this.assertLogIndices(log, 2, 1, 4);
    }

    public void testIncorrectAppend() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        AppendResult result = this.append(impl, 1, 0, new LogEntry(4, buf), leader, 1);
        assert (result.success());
        Assert.assertEquals((int)result.index(), (int)1);
        this.assertLogIndices(log, 1, 1, 4);
        result = this.append(impl, 3, 4, new LogEntry(4, buf), leader, 1);
        assert (!result.success());
        Assert.assertEquals((int)result.index(), (int)1);
        this.assertLogIndices(log, 1, 1, 4);
        result = this.append(impl, 2, 3, new LogEntry(4, buf), leader, 1);
        assert (!result.success());
        Assert.assertEquals((int)result.index(), (int)1);
        this.assertLogIndices(log, 1, 1, 4);
    }

    public void testAppendWithConflictingTerm() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 1);
        this.append(impl, 5, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 6, 4, new LogEntry(5, buf), leader, 1);
        this.append(impl, 7, 5, new LogEntry(5, buf), leader, 1);
        this.append(impl, 8, 5, new LogEntry(6, buf), leader, 1);
        this.append(impl, 9, 6, new LogEntry(6, buf), leader, 1);
        this.append(impl, 10, 6, new LogEntry(6, buf), leader, 1);
        AppendResult result = this.append(impl, 11, 7, new LogEntry(6, buf), leader, 1);
        assert (!result.success());
        Assert.assertEquals((int)result.index(), (int)8);
        Assert.assertEquals((int)result.nonMatchingTerm(), (int)6);
        this.assertLogIndices(log, 10, 1, 6);
    }

    public void testRAFTPaperAppendOnLeader() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 1);
        this.append(impl, 5, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 6, 4, new LogEntry(5, buf), leader, 1);
        this.append(impl, 7, 5, new LogEntry(5, buf), leader, 1);
        this.append(impl, 8, 5, new LogEntry(6, buf), leader, 1);
        this.append(impl, 9, 6, new LogEntry(6, buf), leader, 1);
        this.append(impl, 10, 6, new LogEntry(6, buf), leader, 10);
        AppendResult result = this.append(impl, 11, 6, new LogEntry(6, buf), leader, 1);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)11);
        this.assertLogIndices(log, 11, 10, 6);
    }

    public void testRAFTPaperScenarioA() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 1);
        this.append(impl, 5, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 6, 4, new LogEntry(5, buf), leader, 1);
        this.append(impl, 7, 5, new LogEntry(5, buf), leader, 1);
        this.append(impl, 8, 5, new LogEntry(6, buf), leader, 1);
        this.append(impl, 9, 6, new LogEntry(6, buf), leader, 9);
        AppendResult result = this.append(impl, 11, 6, new LogEntry(6, buf), leader, 9);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)9);
        this.assertLogIndices(log, 9, 9, 6);
    }

    public void testRAFTPaperScenarioB() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 4);
        AppendResult result = this.append(impl, 11, 6, new LogEntry(6, buf), leader, 4);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)4);
        this.assertLogIndices(log, 4, 4, 4);
    }

    public void testRAFTPaperScenarioC() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 1);
        this.append(impl, 5, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 6, 4, new LogEntry(5, buf), leader, 1);
        this.append(impl, 7, 5, new LogEntry(5, buf), leader, 1);
        this.append(impl, 8, 5, new LogEntry(6, buf), leader, 1);
        this.append(impl, 9, 6, new LogEntry(6, buf), leader, 1);
        this.append(impl, 10, 6, new LogEntry(6, buf), leader, 1);
        this.append(impl, 11, 6, new LogEntry(6, buf), leader, 11);
        AppendResult result = this.append(impl, 11, 6, new LogEntry(6, buf), leader, 11);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)11);
        this.assertLogIndices(log, 11, 11, 6);
    }

    public void testRAFTPaperScenarioD() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 1);
        this.append(impl, 5, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 6, 4, new LogEntry(5, buf), leader, 1);
        this.append(impl, 7, 5, new LogEntry(5, buf), leader, 1);
        this.append(impl, 8, 5, new LogEntry(6, buf), leader, 1);
        this.append(impl, 9, 6, new LogEntry(6, buf), leader, 1);
        this.append(impl, 10, 6, new LogEntry(6, buf), leader, 1);
        this.append(impl, 11, 6, new LogEntry(7, buf), leader, 1);
        this.append(impl, 12, 7, new LogEntry(7, buf), leader, 12);
        AppendResult result = this.append(impl, buf, leader, 10, 6, 8, 12);
        Assert.assertTrue((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)11);
        this.assertLogIndices(log, 11, 11, 8);
    }

    public void testRAFTPaperScenarioE() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(4, buf), leader, 1);
        this.append(impl, 5, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 6, 4, new LogEntry(4, buf), leader, 1);
        this.append(impl, 7, 4, new LogEntry(4, buf), leader, 7);
        AppendResult result = this.append(impl, 11, 6, new LogEntry(6, buf), leader, 7);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)7);
        this.assertLogIndices(log, 7, 7, 4);
    }

    public void testRAFTPaperScenarioF() throws Exception {
        Address leader = Util.createRandomAddress((String)"A");
        this.initB();
        RaftImpl impl = this.getImpl(this.b);
        Log log = impl.raft().log();
        byte[] buf = new byte[10];
        this.append(impl, 1, 0, new LogEntry(1, buf), leader, 1);
        this.append(impl, 2, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 3, 1, new LogEntry(1, buf), leader, 1);
        this.append(impl, 4, 1, new LogEntry(2, buf), leader, 1);
        this.append(impl, 5, 2, new LogEntry(2, buf), leader, 1);
        this.append(impl, 6, 2, new LogEntry(2, buf), leader, 1);
        this.append(impl, 7, 2, new LogEntry(3, buf), leader, 1);
        this.append(impl, 8, 3, new LogEntry(3, buf), leader, 1);
        this.append(impl, 9, 3, new LogEntry(3, buf), leader, 1);
        this.append(impl, 10, 3, new LogEntry(3, buf), leader, 1);
        this.append(impl, 11, 3, new LogEntry(3, buf), leader, 11);
        AppendResult result = this.append(impl, 11, 6, new LogEntry(6, buf), leader, 11);
        Assert.assertFalse((boolean)result.isSuccess());
        Assert.assertEquals((int)result.getIndex(), (int)7);
        this.assertLogIndices(log, 11, 11, 3);
    }

    protected JChannel create(String name, boolean follower) throws Exception {
        ELECTION election = new ELECTION().noElections(follower);
        RAFT raft = new RAFT().members(members).raftId(name).logClass("org.jgroups.protocols.raft.InMemoryLog").logName(name + "-" + CLUSTER);
        return new JChannel(Util.getTestStack((Protocol[])new Protocol[]{election, raft, new REDIRECT()})).name(name);
    }

    protected void close(boolean remove_log, boolean remove_snapshot, JChannel ... channels) {
        for (JChannel ch : channels) {
            if (ch == null) continue;
            RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
            if (remove_log) {
                raft.log().delete();
            }
            if (remove_snapshot) {
                raft.deleteSnapshot();
            }
            Util.close((Closeable)ch);
        }
    }

    protected void init(boolean verbose) throws Exception {
        this.c = this.create("C", true);
        this.cs = new ReplicatedStateMachine(this.c);
        this.b = this.create("B", true);
        this.bs = new ReplicatedStateMachine(this.b);
        this.a = this.create("A", false);
        this.as = new ReplicatedStateMachine(this.a);
        this.c.connect(CLUSTER);
        this.b.connect(CLUSTER);
        this.a.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b, this.c});
        for (int i = 0; i < 20 && (!this.isLeader(this.a) || this.isLeader(this.b) || this.isLeader(this.c)); ++i) {
            Util.sleep((long)500L);
        }
        if (verbose) {
            System.out.println("A: is leader? -> " + this.isLeader(this.a));
            System.out.println("B: is leader? -> " + this.isLeader(this.b));
            System.out.println("C: is leader? -> " + this.isLeader(this.c));
        }
        assert (this.isLeader(this.a));
        assert (!this.isLeader(this.b));
        assert (!this.isLeader(this.c));
    }

    protected void initB() throws Exception {
        this.b = this.create("B", true);
        AppendEntriesTest.raft(this.b).stateMachine(new DummyStateMachine());
        this.b.connect(CLUSTER);
    }

    protected boolean isLeader(JChannel ch) {
        RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
        return ch.getAddress().equals(raft.leader());
    }

    protected RaftImpl getImpl(JChannel ch) {
        RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
        Field impl = Util.getField(RAFT.class, (String)"impl");
        return (RaftImpl)Util.getField((Field)impl, (Object)raft);
    }

    protected void assertLeader(JChannel ch, long timeout, long interval) {
        RAFT raft = AppendEntriesTest.raft(ch);
        long stop_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < stop_time && !raft.isLeader()) {
            Util.sleep((long)interval);
        }
        assert (raft.isLeader());
    }

    protected void assertPresent(int key, int value, ReplicatedStateMachine<Integer, Integer> ... rsms) {
        if (rsms == null || rsms.length == 0) {
            rsms = new ReplicatedStateMachine[]{this.as, this.bs, this.cs};
        }
        for (int i = 0; i < 10; ++i) {
            boolean found = true;
            for (ReplicatedStateMachine<Integer, Integer> rsm : rsms) {
                Integer val = rsm.get(key);
                if (val != null && val.equals(value)) continue;
                found = false;
                break;
            }
            if (found) break;
            Util.sleep((long)500L);
        }
        for (ReplicatedStateMachine<Integer, Integer> rsm : rsms) {
            Integer val = rsm.get(key);
            assert (val != null && val.equals(value));
            System.out.println("rsm = " + rsm);
        }
    }

    protected void assertSame(ReplicatedStateMachine<Integer, Integer> ... rsms) {
        ReplicatedStateMachine<Integer, Integer> first = rsms[0];
        for (int i = 0; i < 10; ++i) {
            int same = 1;
            for (int j = 1; j < rsms.length; ++j) {
                ReplicatedStateMachine<Integer, Integer> rsm = rsms[j];
                if (rsm.equals(first)) continue;
                same = 0;
                break;
            }
            if (same != 0) break;
            Util.sleep((long)500L);
        }
        for (ReplicatedStateMachine<Integer, Integer> rsm : rsms) {
            System.out.println(rsm.channel().getName() + ": " + rsm);
        }
        for (int j = 1; j < rsms.length; ++j) {
            ReplicatedStateMachine<Integer, Integer> rsm = rsms[j];
            assert (rsm.equals(first)) : String.format("commit-table of A: %s", ((RAFT)this.a.getProtocolStack().findProtocol(RAFT.class)).dumpCommitTable());
        }
    }

    protected void assertLogIndices(Log log, int last_applied, int commit_index, int term) {
        Assert.assertEquals((int)log.lastApplied(), (int)last_applied);
        Assert.assertEquals((int)log.commitIndex(), (int)commit_index);
        Assert.assertEquals((int)log.currentTerm(), (int)term);
    }

    protected void assertCommitIndex(long timeout, long interval, int expected_commit, int expected_applied, JChannel ... channels) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            boolean all_ok = true;
            JChannel[] jChannelArray = channels;
            int n = jChannelArray.length;
            for (int i = 0; i < n; ++i) {
                JChannel ch = jChannelArray[i];
                RAFT raft = AppendEntriesTest.raft(ch);
                if (expected_commit == raft.commitIndex() && expected_applied == raft.lastApplied()) continue;
                all_ok = false;
            }
            if (all_ok) break;
            Util.sleep((long)interval);
        }
        for (JChannel ch : channels) {
            RAFT raft = AppendEntriesTest.raft(ch);
            System.out.printf("%s: last-applied=%d, commit-index=%d\n", ch.getAddress(), raft.lastApplied(), raft.commitIndex());
            assert (raft.commitIndex() == expected_commit && raft.lastApplied() == expected_applied) : String.format("%s: last-applied=%d, commit-index=%d", ch.getAddress(), raft.lastApplied(), raft.commitIndex());
        }
    }

    protected static RAFT raft(JChannel ch) {
        return (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
    }

    protected AppendResult append(RaftImpl impl, int index, int prev_term, LogEntry entry, Address leader, int leader_commit) throws Exception {
        return this.append(impl, entry.command(), leader, Math.max(0, index - 1), prev_term, entry.term(), leader_commit);
    }

    protected AppendResult append(RaftImpl impl, byte[] data, Address leader, int prev_log_index, int prev_log_term, int entry_term, int leader_commit) throws Exception {
        return (AppendResult)handleAppendEntriesRequest.invoke((Object)impl, data, 0, data.length, leader, prev_log_index, prev_log_term, entry_term, leader_commit, false);
    }

    static {
        members = Arrays.asList("A", "B", "C");
        try {
            handleAppendEntriesRequest = RaftImpl.class.getDeclaredMethod("handleAppendEntriesRequest", byte[].class, Integer.TYPE, Integer.TYPE, Address.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            handleAppendEntriesRequest.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class DummyStateMachine
    implements StateMachine {
        protected DummyStateMachine() {
        }

        @Override
        public byte[] apply(byte[] data, int offset, int length) throws Exception {
            return new byte[0];
        }

        @Override
        public void readContentFrom(DataInput in) throws Exception {
        }

        @Override
        public void writeContentTo(DataOutput out) throws Exception {
        }
    }
}

