/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.raft.util.CommitTable;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CommitTableTest {
    protected static final Address a = Util.createRandomAddress((String)"A");
    protected static final Address b = Util.createRandomAddress((String)"B");
    protected static final Address c = Util.createRandomAddress((String)"C");
    protected static final Address d = Util.createRandomAddress((String)"D");
    protected static final Address e = Util.createRandomAddress((String)"E");

    public void testSnapshotInProgress() {
        CommitTable tab = new CommitTable(Arrays.asList(a, b), 5);
        boolean flag = tab.snapshotInProgress(a, true);
        assert (flag);
        flag = tab.snapshotInProgress(a, true);
        assert (!flag);
        flag = tab.snapshotInProgress(a, false);
        assert (flag);
        flag = tab.snapshotInProgress(a, false);
        assert (!flag);
    }

    public void testAddition() {
        CommitTable table = new CommitTable(Arrays.asList(a, b, c), 5);
        System.out.println("table = " + table);
        assert (table.keys().size() == 3);
        List<Address> mbrs = Arrays.asList(b, c, d, e);
        table.adjust(mbrs, 5);
        System.out.println("table = " + table);
        assert (table.keys().size() == 4);
        Set<Address> keys = table.keys();
        assert (keys.equals(new HashSet<Address>(mbrs)));
    }

    protected List<Address> generate(String ... members) {
        return Arrays.stream(members).map(Util::createRandomAddress).collect(Collectors.toList());
    }
}

