/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jgroups.util.Util;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true)
public class CompletableFutureTest {
    protected CompletableFuture<Integer> future;

    @BeforeMethod
    protected void setup() {
        this.future = new CompletableFuture();
    }

    public void testDone() {
        assert (!this.future.isDone());
        assert (!this.future.isCancelled());
        this.future.cancel(true);
        assert (this.future.isCancelled());
        assert (this.future.isDone());
    }

    public void testGet() throws Exception {
        boolean success = this.future.complete(1);
        assert (success);
        success = this.future.complete(2);
        assert (!success);
        int result = this.future.get();
        assert (result == 1);
        result = this.future.get(500L, TimeUnit.MILLISECONDS);
        assert (result == 1);
    }

    public void testGetWithException() throws Exception {
        block3: {
            this.future.completeExceptionally(new NullPointerException("booom"));
            try {
                this.future.get();
                assert (false) : "should have thrown an exception";
            }
            catch (ExecutionException ex) {
                System.out.println("received ExecutionException as expected: " + ex);
                if ($assertionsDisabled || ex.getCause() instanceof NullPointerException) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testGetWithTimeout() throws Exception {
        try {
            this.future.get(50L, TimeUnit.MILLISECONDS);
            assert (false) : "should have thrown a TimeoutException";
        }
        catch (TimeoutException ex) {
            System.out.println("received TimeoutException as expected: " + ex);
        }
    }

    public void testDelayedGet() throws Exception {
        Completer<Integer> completer = new Completer<Integer>(this.future, 5, null, 500L);
        completer.start();
        int result = this.future.get();
        System.out.println("result = " + result);
        assert (result == 5);
    }

    public void testCancel() throws Exception {
        new Thread(() -> {
            Util.sleep((long)500L);
            this.future.cancel(true);
        }).start();
        try {
            this.future.get();
            assert (false) : "should have thrown a CancellationException";
        }
        catch (CancellationException cex) {
            System.out.println("received CancellationException as expected: " + cex);
        }
        assert (this.future.isCancelled() && this.future.isDone());
    }

    public void testCompletionHandler() {
        MyCompletionHandler handler = new MyCompletionHandler();
        this.future = new CompletableFuture();
        this.future.whenComplete((BiConsumer)handler);
        new Completer<Integer>(this.future, 5, null, 500L).start();
        for (int i = 0; i < 20 && !this.future.isDone(); ++i) {
            Util.sleep((long)500L);
        }
        assert (handler.getException() == null);
        assert ((Integer)handler.getValue() == 5);
    }

    public void testCompletionHandlerWithException() {
        MyCompletionHandler handler = new MyCompletionHandler();
        this.future = new CompletableFuture();
        this.future.whenComplete((BiConsumer)handler);
        new Completer<Integer>(this.future, 0, new NullPointerException("booom"), 500L).start();
        for (int i = 0; i < 20 && !this.future.isDone(); ++i) {
            Util.sleep((long)500L);
        }
        Throwable ex = handler.getException();
        assert (ex != null && ex instanceof NullPointerException);
    }

    protected static class MyCompletionHandler<T>
    implements BiConsumer<T, Throwable> {
        protected T value;
        protected Throwable ex;

        protected MyCompletionHandler() {
        }

        public T getValue() {
            return this.value;
        }

        public Throwable getException() {
            return this.ex;
        }

        @Override
        public void accept(T t, Throwable ex) {
            if (t != null) {
                this.value = t;
            }
            if (ex != null) {
                this.ex = ex;
            }
        }
    }

    protected static class Completer<R>
    extends Thread {
        protected final CompletableFuture<R> future;
        protected final R result;
        protected final Throwable t;
        protected final long sleep;

        public Completer(CompletableFuture<R> future, R result, Throwable t, long sleep) {
            this.future = future;
            this.result = result;
            this.t = t;
            this.sleep = sleep;
        }

        @Override
        public void run() {
            Util.sleep((long)this.sleep);
            if (this.t != null) {
                this.future.completeExceptionally(this.t);
            } else {
                this.future.complete(this.result);
            }
        }
    }
}

