/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.REDIRECT;
import org.jgroups.protocols.raft.StateMachine;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true)
public class DynamicMembershipTest {
    protected JChannel[] channels;
    protected RAFT[] rafts;
    protected Address leader;
    protected static final String CLUSTER = DynamicMembershipTest.class.getSimpleName();
    protected static final List<String> mbrs = Arrays.asList("A", "B", "C");
    protected static final List<String> mbrs2 = Arrays.asList("A", "B", "C", "D");
    protected static final List<String> mbrs3 = Arrays.asList("A", "B", "C", "D", "E");

    @AfterMethod
    protected void destroy() {
        this.close(true, true, this.channels);
    }

    public void testStartOfNonMember() {
        Object non_member;
        block4: {
            non_member = null;
            try {
                this.init("X");
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"Starting a non-member should throw an exception");
            }
            catch (Exception e) {
                try {
                    System.out.println("received exception as expected: " + e.toString());
                }
                catch (Throwable throwable) {
                    this.close(true, true, non_member);
                    throw throwable;
                }
                this.close(true, true, non_member);
            }
        }
        this.close(true, true, non_member);
    }

    public void testMembershipChangeOnNonLeader() throws Exception {
        this.init("A");
        RAFT raft = DynamicMembershipTest.raft(this.channels[0]);
        try {
            raft.addServer("X");
            assert (false) : "Calling RAFT.addServer() on a non-leader must throw an exception";
        }
        catch (Exception ex) {
            System.out.println("received exception calling RAFT.addServer() on a non-leader (as expected): " + ex);
        }
    }

    public void testSimpleAddAndRemove() throws Exception {
        this.init("A", "B", "C");
        this.leader = DynamicMembershipTest.leader(10000L, 500L, this.channels);
        System.out.println("leader = " + this.leader);
        assert (this.leader != null);
        this.assertSameLeader(this.leader, this.channels);
        this.assertMembers(5000L, 500L, mbrs, 2, this.channels);
        System.out.println("\nAdding server D");
        RAFT raft = this.raft(this.leader);
        raft.addServer("D");
        this.assertMembers(10000L, 500L, mbrs2, 3, this.channels);
        System.out.println("\nAdding server E");
        raft = this.raft(this.leader);
        raft.addServer("E");
        this.assertMembers(10000L, 500L, mbrs3, 3, this.channels);
        System.out.println("\nRemoving server E");
        raft = this.raft(this.leader);
        raft.removeServer("E");
        this.assertMembers(10000L, 500L, mbrs2, 3, this.channels);
        System.out.println("\nRemoving server D");
        raft = this.raft(this.leader);
        raft.removeServer("D");
        this.assertMembers(10000L, 500L, mbrs, 2, this.channels);
    }

    public void testAddServerOnLeaderWhichCantCommit() throws Exception {
        this.init("A", "B");
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])this.channels);
        this.leader = DynamicMembershipTest.leader(10000L, 500L, this.channels);
        System.out.println("leader = " + this.leader);
        assert (this.leader != null);
        for (JChannel ch : this.channels) {
            if (ch.getAddress().equals(this.leader)) continue;
            this.close(true, true, ch);
        }
        RAFT raft = this.raft(this.leader);
        raft.addServer("D");
        this.assertMembers(5000L, 500L, mbrs2, 3, this.channels);
        try {
            raft.addServer("E");
            assert (false) : "Adding server E should fail as adding server D has not yet been committed";
        }
        catch (Exception ex) {
            System.out.println("Caught exception (as expected) trying to add another server: " + ex);
        }
        this.channels = Arrays.copyOf(this.channels, 3);
        this.channels[2] = this.create("C");
        for (int i = 0; i < this.channels.length; ++i) {
            if (!this.channels[i].isClosed()) continue;
            this.channels[i] = this.create(String.valueOf((char)(65 + i)));
        }
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])this.channels);
        this.assertMembers(10000L, 500L, mbrs2, 3, this.channels);
        this.assertCommitIndex(20000L, 500L, this.raft(this.leader).lastApplied(), this.channels);
        raft.addServer("E");
        this.assertMembers(10000L, 500L, mbrs3, 3, this.channels);
    }

    protected void init(String ... nodes) throws Exception {
        this.channels = new JChannel[nodes.length];
        this.rafts = new RAFT[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            this.channels[i] = this.create(nodes[i]);
            this.rafts[i] = DynamicMembershipTest.raft(this.channels[i]);
        }
    }

    protected JChannel create(String name) throws Exception {
        RAFT raft = new RAFT().members(mbrs).raftId(name).stateMachine(new DummyStateMachine()).logClass("org.jgroups.protocols.raft.InMemoryLog").logName(name + "-" + CLUSTER);
        JChannel ch = new JChannel(Util.getTestStack((Protocol[])new Protocol[]{new ELECTION(), raft, new REDIRECT()})).name(name);
        ch.connect(CLUSTER);
        return ch;
    }

    protected static Address leader(long timeout, long interval, JChannel ... channels) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            for (JChannel ch : channels) {
                if (!ch.isConnected() || DynamicMembershipTest.raft(ch).leader() == null) continue;
                return DynamicMembershipTest.raft(ch).leader();
            }
            Util.sleep((long)interval);
        }
        return null;
    }

    protected void assertSameLeader(Address leader, JChannel ... channels) {
        for (JChannel ch : channels) {
            assert (leader.equals(DynamicMembershipTest.raft(ch).leader()));
        }
    }

    protected void assertMembers(long timeout, long interval, List<String> members, int expected_majority, JChannel ... channels) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            boolean all_ok = true;
            JChannel[] jChannelArray = channels;
            int n = jChannelArray.length;
            for (int i = 0; i < n; ++i) {
                RAFT raft;
                JChannel ch = jChannelArray[i];
                if (!ch.isConnected() || new HashSet<String>((raft = DynamicMembershipTest.raft(ch)).members()).equals(new HashSet<String>(members))) continue;
                all_ok = false;
            }
            if (all_ok) break;
            Util.sleep((long)interval);
        }
        for (JChannel ch : channels) {
            if (!ch.isConnected()) continue;
            RAFT raft = DynamicMembershipTest.raft(ch);
            System.out.printf("%s: members=%s, majority=%d\n", ch.getAddress(), raft.members(), raft.majority());
            assert (new HashSet<String>(raft.members()).equals(new HashSet<String>(members))) : String.format("expected members=%s, actual members=%s", members, raft.members());
            assert (raft.majority() == expected_majority) : ch.getName() + ": expected majority=" + expected_majority + ", actual=" + raft.majority();
        }
    }

    protected void assertCommitIndex(long timeout, long interval, int expected_commit, JChannel ... channels) {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            boolean all_ok = true;
            JChannel[] jChannelArray = channels;
            int n = jChannelArray.length;
            for (int i = 0; i < n; ++i) {
                JChannel ch = jChannelArray[i];
                RAFT raft = DynamicMembershipTest.raft(ch);
                if (expected_commit == raft.commitIndex()) continue;
                all_ok = false;
            }
            if (all_ok) break;
            Util.sleep((long)interval);
        }
        for (JChannel ch : channels) {
            RAFT raft = DynamicMembershipTest.raft(ch);
            System.out.printf("%s: members=%s, last-applied=%d, commit-index=%d\n", ch.getAddress(), raft.members(), raft.lastApplied(), raft.commitIndex());
            assert (raft.commitIndex() == expected_commit) : String.format("%s: last-applied=%d, commit-index=%d", ch.getAddress(), raft.lastApplied(), raft.commitIndex());
        }
    }

    protected RAFT raft(Address addr) {
        return DynamicMembershipTest.raft(this.channel(addr));
    }

    protected JChannel channel(Address addr) {
        for (JChannel ch : Arrays.asList(this.channels)) {
            if (ch.getAddress() == null || !ch.getAddress().equals(addr)) continue;
            return ch;
        }
        return null;
    }

    protected static RAFT raft(JChannel ch) {
        return (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
    }

    protected void close(boolean remove_log, boolean remove_snapshot, JChannel ... channels) {
        for (JChannel ch : channels) {
            if (ch == null) continue;
            RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
            if (remove_log) {
                raft.log().delete();
            }
            if (remove_snapshot) {
                raft.deleteSnapshot();
            }
            Util.close((Closeable)ch);
        }
    }

    protected static class DummyStateMachine
    implements StateMachine {
        protected DummyStateMachine() {
        }

        @Override
        public byte[] apply(byte[] data, int offset, int length) throws Exception {
            return new byte[0];
        }

        @Override
        public void readContentFrom(DataInput in) throws Exception {
        }

        @Override
        public void writeContentTo(DataOutput out) throws Exception {
        }
    }
}

