/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.protocols.raft.ELECTION;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.protocols.raft.REDIRECT;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true)
public class ElectionsTest {
    protected JChannel a;
    protected JChannel b;
    protected JChannel c;
    protected static final String CLUSTER = "ElectionsTest";
    protected static final List<String> members = Arrays.asList("A", "B", "C");
    protected static final Method startElectionTimer;
    protected static final byte[] BUF;

    @BeforeMethod
    protected void init() throws Exception {
        this.a = this.create("A");
        this.a.connect(CLUSTER);
        this.b = this.create("B");
        this.b.connect(CLUSTER);
        this.c = this.create("C");
        this.c.connect(CLUSTER);
        Util.waitUntilAllChannelsHaveSameSize((long)10000L, (long)500L, (Channel[])new Channel[]{this.a, this.b, this.c});
    }

    @AfterMethod
    protected void destroy() {
        this.close(true, true, this.c, this.b, this.a);
    }

    public void testSimpleElection() throws Exception {
        this.startElections(this.a, this.b, this.c);
        this.assertLeader(20, 500L, null, this.a, this.b, this.c);
    }

    public void testElectionWithLongLog() throws Exception {
        this.setLog(this.b, 1, 1, 2);
        this.setLog(this.c, 1, 1, 2);
        this.startElections(this.a, this.b, this.c);
        Address leader = this.assertLeader(20, 500L, null, this.a, this.b, this.c);
        assert (leader.equals(this.b.getAddress()) || leader.equals(this.c.getAddress()));
        assert (!leader.equals(this.a.getAddress()));
    }

    protected JChannel create(String name) throws Exception {
        ELECTION election = new ELECTION().noElections(true);
        RAFT raft = new RAFT().members(members).raftId(name).logClass("org.jgroups.protocols.raft.InMemoryLog").logName(name + "-" + CLUSTER);
        REDIRECT client = new REDIRECT();
        return new JChannel(Util.getTestStack((Protocol[])new Protocol[]{election, raft, client})).name(name);
    }

    protected void close(boolean remove_log, boolean remove_snapshot, JChannel ... channels) {
        for (JChannel ch : channels) {
            if (ch == null) continue;
            RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
            if (remove_log) {
                raft.log().delete();
            }
            if (remove_snapshot) {
                raft.deleteSnapshot();
            }
            Util.close((Closeable)ch);
        }
    }

    protected void setLog(JChannel ch, int ... terms) {
        RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
        Log log = raft.log();
        int index = log.lastApplied();
        for (int term : terms) {
            log.append(++index, true, new LogEntry(term, BUF));
        }
    }

    protected void startElections(JChannel ... channels) throws Exception {
        for (JChannel ch : channels) {
            ELECTION election = (ELECTION)ch.getProtocolStack().findProtocol(ELECTION.class);
            election.noElections(false);
            startElectionTimer.invoke((Object)election, new Object[0]);
        }
    }

    protected boolean isLeader(JChannel ch) {
        RAFT raft = (RAFT)ch.getProtocolStack().findProtocol(RAFT.class);
        return ch.getAddress().equals(raft.leader());
    }

    protected List<Address> leaders(JChannel ... channels) {
        ArrayList<Address> leaders = new ArrayList<Address>(channels.length);
        for (JChannel ch : channels) {
            if (!this.isLeader(ch)) continue;
            leaders.add(ch.getAddress());
        }
        return leaders;
    }

    protected Address assertLeader(int times, long sleep, Address expected, JChannel ... channels) {
        for (int i = 0; i < times; ++i) {
            List<Address> leaders = this.leaders(channels);
            if (!leaders.isEmpty()) {
                int size = leaders.size();
                assert (size <= 1);
                Address leader = leaders.get(0);
                System.out.println("leader: " + leader);
                if (expected != null) assert (expected.equals(leader));
                break;
            }
            Util.sleep((long)sleep);
        }
        List<Address> leaders = this.leaders(channels);
        assert (leaders.size() == 1) : "leaders=" + leaders;
        Address leader = leaders.get(0);
        System.out.println("leader = " + leader);
        return leader;
    }

    static {
        BUF = new byte[0];
        try {
            startElectionTimer = ELECTION.class.getDeclaredMethod("startElectionTimer", new Class[0]);
            startElectionTimer.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
    }
}

