/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.raft.util.IntegerHelper;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true)
public class IntegerHelperTest {
    public void testNull() {
        Assert.assertEquals((int)0, (int)IntegerHelper.fromByteArrayToInt(null));
    }

    public void testZeroConversion() {
        Assert.assertEquals((int)0, (int)this.convertToBytesAndBack(0));
    }

    public void testPositiveConversion() {
        Assert.assertEquals((int)42, (int)this.convertToBytesAndBack(42));
    }

    public void testMaxConversion() {
        Assert.assertEquals((int)Integer.MAX_VALUE, (int)this.convertToBytesAndBack(Integer.MAX_VALUE));
    }

    public void testNegativeConversion() {
        Assert.assertEquals((int)-42, (int)this.convertToBytesAndBack(-42));
    }

    public void testMinConversion() {
        Assert.assertEquals((int)Integer.MIN_VALUE, (int)this.convertToBytesAndBack(Integer.MIN_VALUE));
    }

    private int convertToBytesAndBack(int number) {
        byte[] b = IntegerHelper.fromIntToByteArray(number);
        return IntegerHelper.fromByteArrayToInt(b);
    }
}

